function  decodedSymbols = RFI_ZeroForcingRx(Y, H, M)
% decodedSymbols = decodedSymbols = RFI_ZeroForcingRx(Y, H, M)
% This function implements the zero-forcing equaliztion for a 2x2 MIMO
% system and independent maximum likelihood decoding at each antenna
% Inputs:   Y - matrix of the received signal
%           H - 2x2 channel matrix
%           M - Modulation order for the QAM constellation used in
%               transmission (M-QAM)
% Outputs:  decodedSymbols - Matrix of the ML decoded symbols
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Aditya Chopra  (chopra@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 11/11/08  1.2 Beta    gulati    Initial Implementation

R = inv(H) * Y;                     % Zero Forcing equalization
decodedSymbols = qamdemod(R, M);    % ML at each antenna

return;
