function decodedSymbols = RFI_AlamoutiRx(Y, H, M)
% decodedSymbols = RRFI_AlamoutiRx(Y, H, M)
% This function implements the maximum likelihood (ML) decoder for Alamouti
% coded transmission in a 2x2 MIMO system
% Inputs:   Y - matrix of the received signal
%           H - 2x2 channel matrix 
%           M - Modulation order for the QAM constellation used in
%               transmission (M-QAM)
% Outputs:  decodedSymbols - Matrix of the decoded symbols 
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Aditya Chopra  (chopra@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 11/11/08  1.2 Beta    gulati    Initial Implementation

H_bar = [H(1,1) H(2,1); -H(2,1)' H(1,1)'; H(1,2) H(2,2); -H(2,2)' H(1,2)'];
Y_bar = [Y(1,1); -Y(2,1)'; Y(1,2); -Y(2,2)'];
decodedSymbols = qamdemod(H_bar'*Y_bar./sum(sum(abs(H).^2)), M);

return;
