function [dem_bits err_rate_opt] = RFI_detect_opt_quant( corrupted_signal, trans_bits, N, A, T, trans_pulse, partition, codebook, SNR, NumTermsPDF )
%[dem_bits err_rate_opt] = RFI_detect_opt( corrupted_signal, trans_bits, N, A, T, trans_pulse );
%This function demodulates the signal using the optimal Bayesian detector 
%for Class A interference for the binary digital signaling like 2 PAM. 
%It assumes that the constellation is symmetric with respect to zero.
% Inputs:   corrupted_signal    - the transmitted signal corrupted by noise
%           transmitted_bits     - the vector of transmitted bits
%           N                   - number of samples per symbol
%           A                   - overlap index of class A interference
%           T                   - Gaussian factor of class A interference
%           trans_pulse         - is the pulse shape of the transmitted pulse
%                                 (ex raised cosine)
%           partion, codebook   - see lloyds algorithm for details
%           SNR
%           NumTermsPDF         - Number of terms to retain in infinite
%                                 series expansion
%
% Outputs:  dem_bits            - vector of demodulated bits
%           err_rate_opt       - the bit error rate using bayesian receiver
%
%References:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

no_symb = length(corrupted_signal)/N;
corrupted_signal=reshape(corrupted_signal,N,no_symb);
dem_bits = RFI_bi_detector_quant(-trans_pulse,trans_pulse,corrupted_signal,A,T, NumTermsPDF,partition, codebook, SNR); %here 2PAM is used

err_rate_opt = sum(dem_bits~=trans_bits)/no_symb;