function KLD = RFI_CalcKLDiver(FTrue, FEst, X)
% KLD = RFI_CalcKLDiver(FTrue, FEst, X) This function calculates the
% KullbackLeibler divergence (KLD) between two 1-D or 2-D probability
% density functions (PDFs). 
% Inputs :  FTrue - True probability density function evaluated at the
%                   values in X. FTrue is a vector for 1-D PDF and a square
%                   matrix for a 2-D PDF.
%           FEst  - Estimated probability density function evaluated at the
%                   values in X. FEst is a vector for 1-D PDF and a square
%                   matrix for a 2-D PDF.
%           X     - vector (for 1-D PDFs) or 2-column matrix (for 2-D PDFs)
%                   representing the meshgrid the values at which the true
%                   and estimated probability density functions are
%                   evaluated. First column vector of X corresponds to the
%                   first dimension of the PDF, and the second column of X
%                   corresponds to the second dimension of the true and
%                   esimated PDFs.
% Outputs : KLD   - The Kullback-Leibler divergence of the estimated
%                   probability density function (FEst) from the true
%                   probability density function (FTrue).
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 06/15/09  1.3 Beta    gulati    Initial Creation


func = FTrue.*log(FTrue./FEst);
[i1 i2] = find(FTrue == 0);
for i = 1:length(i1)
    func(i1(i), i2(i))  = 0;
end

for i = 1:size(X,2)
    func = trapz(X(:,i), func);
end
KLD = func;

return;