function varargout = RFI_DemoSISO(varargin)
% RFI_DEMOSISO M-file for RFI_DemoSISO.fig
%      RFI_DEMOSISO, by itself, creates a new RFI_DEMOSISO or raises the existing
%      singleton*.
%
%      H = RFI_DEMOSISO returns the handle to a new RFI_DEMOSISO or the handle to
%      the existing singleton*.
%
%      RFI_DEMOSISO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFI_DEMOSISO.M with the given input arguments.
%
%      RFI_DEMOSISO('Property','Value',...) creates a new RFI_DEMOSISO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RFI_DemoSISO_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to RFI_DemoSISO_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help RFI_DemoSISO

% Last Modified by GUIDE v2.5 29-Nov-2008 20:57:42

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @RFI_DemoSISO_OpeningFcn, ...
                   'gui_OutputFcn',  @RFI_DemoSISO_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoSISO is made visible.
function RFI_DemoSISO_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RFI_DemoSISO (see VARARGIN)

%addpath(genpath('../../'))  %add the directory that contians the required functions

% Choose default command line output for RFI_DemoSISO
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoSISO wait for user response (see UIRESUME)
% uiwait(handles.figure1);


ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(ESPL_logo);
%axis equal;
%axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');

WNCG_logo=imread('wncg-sm.jpg');
set(handles.WNCG_logo,'HandleVisibility','ON');
axes(handles.WNCG_logo);
image(WNCG_logo);
axis equal;
axis tight;
axis off;
set(handles.WNCG_logo,'HandleVisibility','OFF');

% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoSISO_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function bits_per_itr_Callback(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bits_per_itr as text
%        str2double(get(hObject,'String')) returns contents of bits_per_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end


% --- Executes during object creation, after setting all properties.
function bits_per_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function no_itr_Callback(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of no_itr as text
%        str2double(get(hObject,'String')) returns contents of no_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if (isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function no_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_low_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_low_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_low_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','-20');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
if (user_entry > high_limit)
    set(hObject, 'String', num2str(high_limit-30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_low_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_high_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_high_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_high_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
lower_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
if (user_entry < lower_limit)
    set(hObject, 'String', num2str(lower_limit+30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_high_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNR_step_size_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_step_size as text
%        str2double(get(hObject,'String')) returns contents of SNR_step_size as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_step_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function A_Callback(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A as text
%        str2double(get(hObject,'String')) returns contents of A as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.35');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-2)
    set(hObject,'String','0.35');
    errordlg('A range exceeded. A should belong to [0.01,1].','Bad Input','modal')
end;
    

% --- Executes during object creation, after setting all properties.
function A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma as text
%        str2double(get(hObject,'String')) returns contents of Gamma as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.001');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-6)
    set(hObject,'String','0.001');
    errordlg('Gamma range exceeded. Gamma should belong to [10^-6,1].','Bad Input','modal')
end;

% --- Executes during object creation, after setting all properties.
function Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_Callback(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r as text
%        str2double(get(hObject,'String')) returns contents of r as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry < 0 | user_entry > 1)
    set(hObject,'String','0.1');
    errordlg('Invalid value for r. r should be between 0 and 1.','Bad Input','modal');
end;



% --- Executes during object creation, after setting all properties.
function r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delay_Callback(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay as text
%        str2double(get(hObject,'String')) returns contents of delay as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a postive numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function sampling_ratio_Callback(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sampling_ratio as text
%        str2double(get(hObject,'String')) returns contents of sampling_ratio as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function sampling_ratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in corr_rx.
function corr_rx_Callback(hObject, eventdata, handles)
% hObject    handle to corr_rx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of corr_rx


% --- Executes on button press in wiener_dtc.
function wiener_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to wiener_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of wiener_dtc


% --- Executes on button press in bayesian_dtc.
function bayesian_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to bayesian_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bayesian_dtc


% --- Executes on button press in start_sim.
function start_sim_Callback(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% The UserData is being used to indicate if the button is in the Start mode
% (0) or the Stop mode (1)
% if (get(hObject, 'UserData') == 0)
%     set(hObject,'String','Stop Simulation');
%     set(hObject,'UserData',1);
% else
%     % Add ending code sequence here depending on the desired ending
%     % behavior
%     set(hObject,'String','Start Simulation');
%     set(hObject,'UserData',0);
%     return;
% end;
%Temporary button disbale functionality
set(hObject,'enable','inactive');
% Obtain necessary data from the GUI handles structure, I chose to get them
% rather than store then in the handles strucuture using guidata becuase
% the amount of data is small and this saves a lot of work in updating the
% fields and save some memory space

val = get(handles.Noise_type,'Value');
switch val
case 1
    is_class_A=1;
    is_alpha=0;
case 2
    is_class_A=0;
    is_alpha=1;
end;

NumTermsPDF = 100; % number of terms used in the pdf expansion of class A

% Determines the options settings
corr_status = get(handles.corr_rx, 'Value');
wiener_status = get(handles.wiener_dtc, 'Value');
bayes_status = get(handles.bayesian_dtc, 'Value');
bayes_aprx_status = get(handles.small_sig_aprx, 'Value');
bayes_quant_status = get(handles.quant, 'Value');
myriad_status_opt = get(handles.myriad_dtc, 'Value');
myriad_status_selec = get(handles.selec_myriad, 'Value');

% Get Class A parameters
A = str2double(get(handles.A, 'String')); 
T = str2double(get(handles.Gamma, 'String'));

quant_levels = str2double(get(handles.quant_level, 'String'));% number of quantazation levels

% Get Alpha Stable Parameters
alpha = str2double(get(handles.alpha, 'String')); % Characteristic Exponent
disper = str2double(get(handles.disp, 'String'));% Dispersion Parameter
delta = str2double(get(handles.delta, 'String'));% Localization Parameter

% Get Simulation Settings
SNR_low_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
SNR_high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
step_size = str2double(get(handles.SNR_step_size, 'String'));

if (corr_status + wiener_status + (bayes_status+bayes_quant_status+bayes_aprx_status)*is_class_A + (myriad_status_opt+myriad_status_selec)*is_alpha == 0)
    errordlg('Please select at least one detection method.','Irrational Settings','modal')
    set(hObject,'String','Start Simulation');
    set(hObject,'UserData',0); % related the note  above
    set(hObject,'enable','on');
    return;
end;

if (bayes_quant_status == 1 && is_class_A)
    % Settings for resolution of pdf generation
    MaxVal = 1; XRes = 10000;
    x = [linspace(-20, -MaxVal-1, XRes) linspace(-MaxVal, MaxVal, XRes) ...
     linspace(MaxVal+1, 20, XRes)]; % Range within which the data is generated
    thePDF = RFI_MakePDFClassA( x, A, T, NumTermsPDF);

    [partition, codebook] = lloyds(thePDF,quant_levels); % codebook generation
end;

SNR=SNR_low_limit:step_size:SNR_high_limit; %SNR range
err_rate_corr=zeros(1,length(SNR));
err_rate_opt=zeros(1,length(SNR));
err_rate_opt_quant=zeros(1,length(SNR));
err_rate_aprx=zeros(1,length(SNR));
err_rate_wiener=zeros(1,length(SNR));
err_rate_myriad_opt=zeros(1,length(SNR));
err_rate_myriad_selec=zeros(1,length(SNR));

no_bits = str2double(get(handles.bits_per_itr, 'String')); %number of bits for simulation per iteration
no_iterations = str2double(get(handles.no_itr, 'String')); %number of iterations
M=2; %number of constellation points (currently only 2 is supported)
delay = str2double(get(handles.delay, 'String')); %delay of the raised cosine filter
sampling_ratio = str2double(get(handles.sampling_ratio, 'String')); %the sampling ratio for the raised cosine filter
r = str2double(get(handles.r, 'String')); % r for the raised cosing filter
N=2*delay*sampling_ratio; %number of sampled points (raised cosine pulse shape, and received signal)

% Pulse Shape Design
y=rcosine(1,sampling_ratio,'default',r,delay);%Need to be adjusted to fit N (defined above)
%need to choose the right parameters acording to the value of N
%the value of N should satisfy N=k*2*delay (see help rcosine)
y=y(1:length(y)-1);

% Wiener Filter Design precalculations (autocorrelation)
if (wiener_status == 1)
    y_cor=xcorr(y,'unbiased');
    y_cor=y_cor(N:length(y_cor));
    Ry=toeplitz(y_cor); % The autocorrelation Matrix of y
end;

for j=1:no_iterations

% generate no_bits bits and modulate the signal
[x_pul x_mod ] = RFI_gen_binary_mod(no_bits,2,y);

% Noise generation and SNR sweep
if (is_class_A == 1)
    noise = RFI_MakeDataClassA(A,T,NumTermsPDF,N*no_bits);%can be included inside of the loop to provide more
                                                 %randomness at the cost
                                                 %of much more running
                                                 %time
else
    noise = RFI_MakeDataAlphaStable(alpha, disper, delta, N*no_bits);
end;

for i=1:length(SNR)
    per=randperm(length(noise)); % permuting noise samples since they are iid
    noise=noise(per);
    if (is_class_A == 1)
        z=noise*sqrt(10^(-SNR(i)/10)); %renormalize the noise for correct SNR
        r=x_pul+z(:); % add noise to the signal
    else
        Es = (disper*10^(SNR(i)/10));               % Signal Power as per the definition of a generalized SNR.
        r = x_pul.*sqrt(Es) + noise(:);      % add noise to the signal
    end;

    if (corr_status == 1)
        [dem_bits err_rate] = RFI_detect_cor( r, x_mod, N );
        err_rate_corr(i)= err_rate_corr(i)+err_rate;
    end;
    
    if (wiener_status == 1)
        w=inv(Ry+10^(-SNR(i)/10)*eye(N))*y_cor';%wiener filter coefficients (Solving Wiener-Hopf Equations)
        [dem_bits err_rate] = RFI_detect_wiener( r, x_mod, N, w );
        err_rate_wiener(i)=err_rate_wiener(i)+err_rate;
    end;
    
    % Add estimation in next release

    if (bayes_status*is_class_A == 1)
        % Optimal Bayesian Detection
        [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, A, T, y, NumTermsPDF, SNR(i));
        err_rate_opt(i)=err_rate_opt(i)+err_rate;
    end;
    
    if (bayes_aprx_status*is_class_A == 1)
        % Approximate Bayesian Detection
        [dem_bits err_rate] = RFI_detect_appx( r, x_mod, N, A, T, y, NumTermsPDF, SNR(i));
        err_rate_aprx(i)=err_rate_aprx(i)+err_rate;
    end;
    
    if (bayes_quant_status*is_class_A == 1)
        % Quantized Bayesian Detection
        [dem_bits err_rate] = RFI_detect_opt_quant( r, x_mod, N, A, T, y, partition, codebook, SNR(i), NumTermsPDF );
        err_rate_opt_quant(i)=err_rate_opt_quant(i)+err_rate;
    end;
    
    if (myriad_status_opt*is_alpha == 1)
        % Myriad Filtering (Implementation Option 1: Polynomial rooting)
        [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alpha, disper, 1 );
        err_rate_myriad_opt(i)=err_rate_myriad_opt(i)+err_rate;
    end;
    
    if (myriad_status_opt*is_alpha == 1)
        % Myriad Filtering (Implementation Option 2: Selection Myriad)
        [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alpha, disper, 2 );
        err_rate_myriad_selec(i)=err_rate_myriad_selec(i)+err_rate;
    end;
    
   
end;

end;

figure;
hold on;
xlabel('SNR');ylabel('BER');
title('Comunnication Performance');

if (corr_status == 1)
    err_rate_corr=err_rate_corr/no_iterations;
    plot(SNR,err_rate_corr, 'Displayname', 'Correlation Receiver');
end;
    
if (wiener_status == 1)
    err_rate_wiener=err_rate_wiener/no_iterations;
    plot(SNR, err_rate_wiener,'r','Displayname', 'Wiener Filtering');
end;
    
if (bayes_status*is_class_A == 1)
    err_rate_opt=err_rate_opt/no_iterations;
    plot(SNR, err_rate_opt,'g','Displayname', 'Bayesian Detection');
end;

if (bayes_aprx_status*is_class_A == 1)
     err_rate_aprx=err_rate_aprx/no_iterations;
     plot(SNR, err_rate_aprx,'k', 'Displayname', 'Small Signal Approximation');
end;
    
if (bayes_quant_status*is_class_A == 1)
     err_rate_opt_quant=err_rate_opt_quant/no_iterations;
     plot(SNR, err_rate_opt_quant,'m', 'Displayname', 'Quantized Bayesian Detection');
end;
    
if (myriad_status_opt*is_alpha == 1)
     err_rate_myriad_opt=err_rate_myriad_opt/no_iterations;
     plot(SNR, err_rate_myriad_opt,'g', 'Displayname', 'Optimal Myriad Filtering');
end;
    
if (myriad_status_opt*is_alpha == 1)
     err_rate_myriad_selec=err_rate_myriad_selec/no_iterations;
     plot(SNR, err_rate_myriad_selec,'k', 'Displayname', 'Selection Myriad Filtering');
end;
    

legend('show');
set(hObject,'enable','on');

% --- Executes on key press over start_sim with no controls selected.
function start_sim_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on selection change in Noise_type.
function Noise_type_Callback(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Noise_type contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Noise_type
val = get(hObject,'Value');
switch val
case 1
    set(handles.text11,'Visible','on');
    set(handles.A,'Visible','on');
    set(handles.text12,'Visible','on');
    set(handles.Gamma,'Visible','on');
    set(handles.alpha,'Visible','off');
    set(handles.disp,'Visible','off');
    set(handles.delta,'Visible','off');
    set(handles.text19,'Visible','off');
    set(handles.text20,'Visible','off');
    set(handles.text21,'Visible','off');
    set(handles.myriad_dtc,'Enable','off');
    set(handles.bayesian_dtc,'Enable','on');
    set(handles.selec_myriad,'Enable','off');
    set(handles.quant,'Enable','on');
    set(handles.small_sig_aprx,'Enable','on');
case 2
    set(handles.text11,'Visible','off');
    set(handles.A,'Visible','off');
    set(handles.text12,'Visible','off');
    set(handles.Gamma,'Visible','off');
    set(handles.alpha,'Visible','on');
    set(handles.disp,'Visible','on');
    set(handles.delta,'Visible','on');
    set(handles.text19,'Visible','on');
    set(handles.text20,'Visible','on');
    set(handles.text21,'Visible','on');
    set(handles.myriad_dtc,'Enable','on');
    set(handles.bayesian_dtc,'Enable','off');
    set(handles.selec_myriad,'Enable','on');
    set(handles.quant,'Enable','off');
    set(handles.quant_level,'Visible','off');
   set(handles.levels,'Visible','off');
   set(handles.small_sig_aprx,'Enable','off');
end;
% proceed with callback...

% --- Executes during object creation, after setting all properties.
function Noise_type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function alpha_Callback(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of alpha as text
%        str2double(get(hObject,'String')) returns contents of alpha as a double


% --- Executes during object creation, after setting all properties.
function alpha_CreateFcn(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function disp_Callback(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of disp as text
%        str2double(get(hObject,'String')) returns contents of disp as a double


% --- Executes during object creation, after setting all properties.
function disp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delta_Callback(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delta as text
%        str2double(get(hObject,'String')) returns contents of delta as a double


% --- Executes during object creation, after setting all properties.
function delta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on button press in myriad_dtc.
function myriad_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to myriad_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of myriad_dtc




% --- Executes on button press in selec_myriad.
function selec_myriad_Callback(hObject, eventdata, handles)
% hObject    handle to selec_myriad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of selec_myriad




% --- Executes on button press in quant.
function quant_Callback(hObject, eventdata, handles)
% hObject    handle to quant (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of quant
val = get(hObject,'Value');
if val == 0
   set(handles.quant_level,'Visible','off');
   set(handles.levels,'Visible','off');
else
   set(handles.quant_level,'Visible','on');
   set(handles.levels,'Visible','on');
end;


function quant_level_Callback(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of quant_level as text
%        str2double(get(hObject,'String')) returns contents of quant_level as a double


% --- Executes during object creation, after setting all properties.
function quant_level_CreateFcn(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in small_sig_aprx.
function small_sig_aprx_Callback(hObject, eventdata, handles)
% hObject    handle to small_sig_aprx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of small_sig_aprx


