function varargout = RFI_DemoTwoByTwoMIMO(varargin)
%RFI_DEMOTWOBYTWOMIMO M-file for RFI_DemoTwoByTwoMIMO.fig
%      RFI_DEMOTWOBYTWOMIMO, by itself, creates a new RFI_DEMOTWOBYTWOMIMO or raises the existing
%      singleton*.
%
%      H = RFI_DEMOTWOBYTWOMIMO returns the handle to a new RFI_DEMOTWOBYTWOMIMO or the handle to
%      the existing singleton*.
%
%      RFI_DEMOTWOBYTWOMIMO('Property','Value',...) creates a new RFI_DEMOTWOBYTWOMIMO using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to RFI_DemoTwoByTwoMIMO_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      RFI_DEMOTWOBYTWOMIMO('CALLBACK') and RFI_DEMOTWOBYTWOMIMO('CALLBACK',hObject,...) call the
%      local function named CALLBACK in RFI_DEMOTWOBYTWOMIMO.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RFI_DemoTwoByTwoMIMO

% Last Modified by GUIDE v2.5 22-Nov-2008 16:55:17

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @RFI_DemoTwoByTwoMIMO_OpeningFcn, ...
    'gui_OutputFcn',  @RFI_DemoTwoByTwoMIMO_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoTwoByTwoMIMO is made visible.
function RFI_DemoTwoByTwoMIMO_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for RFI_DemoTwoByTwoMIMO
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoTwoByTwoMIMO wait for user response (see UIRESUME)
% uiwait(handles.figure1);

ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(ESPL_logo);
%axis equal;
%axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');


% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoTwoByTwoMIMO_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function kappa_g_Callback(hObject, eventdata, handles)
% hObject    handle to kappa_g (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kappa_g as text
%        str2double(get(hObject,'String')) returns contents of kappa_g as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.2');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function kappa_g_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kappa_g (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Gamma2_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma2 as text
%        str2double(get(hObject,'String')) returns contents of Gamma2 as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function Gamma2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kappa_Callback(hObject, eventdata, handles)
% hObject    handle to kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kappa as text
%        str2double(get(hObject,'String')) returns contents of kappa as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.2');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function kappa_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Gamma1_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma1 as text
%        str2double(get(hObject,'String')) returns contents of Gamma1 as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.01');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function Gamma1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function A_Callback(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A as text
%        str2double(get(hObject,'String')) returns contents of A as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in BiVarClassA.
function BiVarClassA_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarClassA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of BiVarClassA


% --- Executes on button press in BiVarGaussian.
function BiVarGaussian_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of BiVarGaussian


% --- Executes on button press in SM_GaussianML.
function SM_GaussianML_Callback(hObject, eventdata, handles)
% hObject    handle to SM_GaussianML (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SM_GaussianML


% --- Executes on button press in SM_ZF.
function SM_ZF_Callback(hObject, eventdata, handles)
% hObject    handle to SM_ZF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SM_ZF


% --- Executes on button press in Alamouti.
function Alamouti_Callback(hObject, eventdata, handles)
% hObject    handle to Alamouti (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Alamouti


% --- Executes on button press in SM_MLOpt.
function SM_MLOpt_Callback(hObject, eventdata, handles)
% hObject    handle to SM_MLOpt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SM_MLOpt


% --- Executes on button press in SM_MLSubOpt2.
function SM_MLSubOpt2_Callback(hObject, eventdata, handles)
% hObject    handle to SM_MLSubOpt2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SM_MLSubOpt2


% --- Executes on button press in SM_MLSubOpt4.
function SM_MLSubOpt4_Callback(hObject, eventdata, handles)
% hObject    handle to SM_MLSubOpt4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SM_MLSubOpt4



function SNR_start_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_start as text
%        str2double(get(hObject,'String')) returns contents of SNR_start as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNR_stop_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_stop as text
%        str2double(get(hObject,'String')) returns contents of SNR_stop as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','20');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_stop_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNR_res_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_res (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_res as text
%        str2double(get(hObject,'String')) returns contents of SNR_res as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_res_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_res (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MQAM_Callback(hObject, eventdata, handles)
% hObject    handle to MQAM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MQAM as text
%        str2double(get(hObject,'String')) returns contents of MQAM as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','4');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function MQAM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MQAM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function NoSymbols_Callback(hObject, eventdata, handles)
% hObject    handle to NoSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NoSymbols as text
%        str2double(get(hObject,'String')) returns contents of NoSymbols as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','100000');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function NoSymbols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NoSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Status_Callback(hObject, eventdata, handles)
% hObject    handle to Status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Status as text
%        str2double(get(hObject,'String')) returns contents of Status as a double


% --- Executes during object creation, after setting all properties.
function Status_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ClearStatus.
function ClearStatus_Callback(hObject, eventdata, handles)
% hObject    handle to ClearStatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Status,'String','');


% --- Executes on button press in EstParam.
function EstParam_Callback(hObject, eventdata, handles)
% hObject    handle to EstParam (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of EstParam



function N_train_Callback(hObject, eventdata, handles)
% hObject    handle to N_train (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_train as text
%        str2double(get(hObject,'String')) returns contents of N_train as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10000');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function N_train_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_train (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in startsimulation.
function startsimulation_Callback(hObject, eventdata, handles)
% hObject    handle to startsimulation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Starting Simluation...')); drawnow;

% Retrieve Simulation Parameters
% -------------------------------------------------------------------------
% SNR range
SNR_start   = str2double(get(handles.SNR_start, 'String'));
SNR_stop    = str2double(get(handles.SNR_stop, 'String'));
SNR_res     = str2double(get(handles.SNR_res, 'String'));
vectorSNR = logspace(SNR_start/10,SNR_stop/10,SNR_res);
% No of symbols
N_symbols   = str2double(get(handles.NoSymbols, 'String'));
% Parameters of BiVariate Middleton Class A
BiVarClassA = get(handles.BiVarClassA, 'Value');
if (BiVarClassA)
    A           = str2double(get(handles.A, 'String'));
    Gamma1      = str2double(get(handles.Gamma1, 'String'));
    Gamma2      = str2double(get(handles.Gamma2, 'String'));
    kappa       = str2double(get(handles.kappa, 'String'));
end
% Parameters of BiVariate Gaussian
BiVarGaussian   = get(handles.BiVarGaussian, 'Value');
if (BiVarGaussian)
    kappa_g = str2double(get(handles.kappa_g, 'String'));
end
% Modulation
M   = str2double(get(handles.MQAM, 'String'));
% Parameter Estimation and Training
EstParam    = get(handles.EstParam, 'Value');
if (EstParam)
    N_train     = str2double(get(handles.N_train, 'String'));
end
% Receivers Enabled
SM_GaussianML   = get(handles.SM_GaussianML, 'Value');
SM_ZF           = get(handles.SM_ZF, 'Value');
Alamouti        = get(handles.Alamouti, 'Value');
SM_MLOpt        = get(handles.SM_MLOpt, 'Value');
SM_MLSubOpt2    = get(handles.SM_MLSubOpt2, 'Value');
SM_MLSubOpt4    = get(handles.SM_MLSubOpt4, 'Value');

% Simulation
% -------------------------------------------------------------------------
% M-QAM modulation
input_symbols = floor(rand(N_symbols,2)*M);
input_sym_mod = qammod(input_symbols, M);
Es  = sum(abs(qammod(0:M-1,M)).^2)/M;
% M^2-QAM modulation for Alamouti
input_symbols_ALM = floor(rand(N_symbols,2)*M^2);
input_sym_mod_ALM = qammod(input_symbols_ALM, M^2);
Es_ALM  = sum(abs(qammod(0:M^2-1,M^2)).^2)/M^2;

% Codebook
for k1 = 0:M-1
    for k2 = 0:M-1
        codebook(k1*M+k2+1,:) = qammod([k1 k2],M);
    end
end
codebook = codebook.';

if (Alamouti)
    % For M^2-QAM
    for k1 = 0:M^2-1
        for k2 = 0:M^2-1
            codebook_ALM(k1*M^2+k2+1,:) = qammod([k1 k2],M^2);
        end
    end
    codebook_ALM = codebook_ALM.';
end

% Intialize Decoded Symbols vector
% -------------------------------------------------------------------------
if (BiVarGaussian)
    if (SM_MLOpt)
        D_SM_MLOpt_G        = zeros(N_symbols,2);
    end
    if (SM_MLSubOpt2)
        D_SM_MLSubOpt2_G    = zeros(N_symbols,2);
    end
    if (SM_MLSubOpt4)
        D_SM_MLSubOpt4_G    = zeros(N_symbols,2);
    end
    if (SM_GaussianML)
        D_SM_ML_G           = zeros(N_symbols,2);
    end
    if (SM_ZF)
        D_SM_ZF_G           = zeros(N_symbols,2);
    end
    if (Alamouti)
        D_ALM_G             = zeros(N_symbols,2);
    end
end
if (BiVarClassA)
    if (SM_MLOpt)
        D_SM_MLOpt_I      	= zeros(N_symbols,2);
    end
    if (SM_MLSubOpt2)
        D_SM_MLSubOpt2_I    = zeros(N_symbols,2);
    end
    if (SM_MLSubOpt4)
        D_SM_MLSubOpt4_I    = zeros(N_symbols,2);
    end
    if (SM_GaussianML)
        D_SM_ML_I           = zeros(N_symbols,2);
    end
    if (SM_ZF)
        D_SM_ZF_I           = zeros(N_symbols,2);
    end
    if (Alamouti)
        D_ALM_I             = zeros(N_symbols,2);
    end
end

if (BiVarClassA & BiVarGaussian)
    % Generate Parameters of Equi-Powered Gaussian
    sigma1_sum = exp(-A) * Gamma1/(1+Gamma1) + (1-exp(-A))*(1/A + Gamma1)/(1+ Gamma1);
    sigma2_sum = exp(-A) * Gamma2/(1+Gamma2) + (1-exp(-A))*(1/A + Gamma2)/(1+ Gamma2);
else
    sigma1_sum = 1;
    sigma2_sum = 1;
end

if (BiVarGaussian)
    theta = 0.5*asin(kappa_g);
    CorrMat = [sqrt(sigma1_sum) 0 ; 0 sqrt(sigma2_sum)] * [cos(theta) sin(theta); sin(theta) cos(theta)];
end

% Parameter Estimation
% -------------------------------------------------------------------------
if (EstParam)
    % Estimate Parameters
    % Status Update
    CurrStatus = get(handles.Status, 'String');
    set(handles.Status, 'String', strvcat(CurrStatus, 'Estimating Model Parameters...')); drawnow;

    if (BiVarClassA)    % BiVariate Middleton Class A
        noise_data_train = RFI_MakeDataBiVarClassA(A, Gamma1, Gamma2, kappa, N_train);
        [A_est Gamma1_est Gamma2_est kappa_est] = RFI_MOMBiVarClassAEst(noise_data_train);
        % Status Update
        CurrStatus = get(handles.Status, 'String');
        set(handles.Status, 'String', strvcat(CurrStatus, 'Estimated Class A parameters :', strcat('A = ', num2str(A_est), ', Gamma1 = ', num2str(Gamma1_est), ', Gamma2 = ', num2str(Gamma2_est), ', kappa_est =', num2str(kappa_est)))); drawnow;
        % Gaussian Model estimates to be used by Gaussian Receivers
        sigma1_est  = exp(-A_est) * Gamma1_est/(1+Gamma1_est) + (1-exp(-A_est))*(1/A_est + Gamma1_est)/(1+ Gamma1_est);
        sigma2_est  = exp(-A_est) * Gamma2_est/(1+Gamma2_est) + (1-exp(-A_est))*(1/A_est + Gamma2_est)/(1+ Gamma2_est);
        kappa_g_est = kappa_est;
    end
    if (BiVarGaussian)  % BiVariate Gaussian
        noise_data_train = CorrMat*randn(2,N_train);
        sigma1_est       = mean(noise_data_train(1,:).^2);
        sigma2_est       = mean(noise_data_train(2,:).^2);
        kappa_g_est      = mean(noise_data_train(1,:).*noise_data_train(2,:)) / sqrt(sigma1_est*sigma2_est);
        % Status Update
        CurrStatus = get(handles.Status, 'String');
        set(handles.Status, 'String', strvcat(CurrStatus, 'Estimated Gaussian parameters :', strcat('kappa = ', num2str(kappa_g_est)))); drawnow;
        % Estimate Class A model paramaters with Gaussian noise inputs.
        % These would be used by Class A receivers. Ideally, they should
        % come out so that the Class A model becomes a Gaussian model (high
        % A, Gamma1, Gamma2)
        [A_ca_est_g Gamma1_ca_est_g Gamma2_ca_est_g kappa_ca_est_g] = RFI_MOMBiVarClassAEst(noise_data_train.');
    end
else
    % Use actual parameters
    if (BiVarClassA)    % BiVariate Middleton Class A
        A_est       = A;
        Gamma1_est  = Gamma1;
        Gamma2_est  = Gamma2;
        kappa_est   = kappa;
        % Gaussian parameters to be used by the Gaussian Receivers
        kappa_g_est = kappa;
        sigma1_est  = sigma1_sum; % = 1
        sigma2_est  = sigma2_sum; % = 1
    end
    if (BiVarGaussian)  % BiVariate Gaussian
        kappa_g_est = kappa_g;
        sigma1_est  = sigma1_sum;
        sigma2_est  = sigma2_sum;
        % Class A model paramters to be used by Class A receivers in the
        % presence of Gaussian noise (A, Gamma set so that it's nearly a
        % Gaussian model)
        A_ca_est_g = 100;
        Gamma1_ca_est_g  = 10;
        Gamma2_ca_est_g  = 10;
        kappa_ca_est_g = kappa_g_est;
    end

end

% -------------------------------------------------------------------------



% Run for the entire SNR Range
% -------------------------------------------------------------------------
for s = 1:length(vectorSNR)

    SNR = vectorSNR(s);
    % Status Update
    CurrStatus = get(handles.Status, 'String');
    set(handles.Status, 'String', strvcat(CurrStatus, strcat('Simulating for SNR Index = ', num2str(s)))); drawnow;

    % Noise Generation
    % ----------------
    if (BiVarClassA)    % BiVariate Middleton Class A
        V_vec_r =  RFI_MakeDataBiVarClassA(A, Gamma1, Gamma2, kappa, N_symbols);
        V_vec_i =  RFI_MakeDataBiVarClassA(A, Gamma1, Gamma2, kappa, N_symbols);
        V_vec   =  1/sqrt(2)*(V_vec_r + sqrt(-1)*V_vec_i);
    end

    if (BiVarClassA & Alamouti)    % BiVariate Middleton Class A and Alamouti Coding
        V_vec_ALM_r =  RFI_MakeDataBiVarClassA(A, Gamma1, Gamma2, kappa, N_symbols * 2);
        V_vec_ALM_i =  RFI_MakeDataBiVarClassA(A, Gamma1, Gamma2, kappa, N_symbols * 2);
        V_vec_ALM   =  1/sqrt(2)*(V_vec_ALM_r + sqrt(-1)*V_vec_ALM_i);
    end

    if (BiVarGaussian)  % BiVariate Gaussian
        V_vec_gauss_r =  CorrMat*randn(2,N_symbols);
        V_vec_gauss_i =  CorrMat*randn(2,N_symbols);
        V_vec_gauss   =  1/sqrt(2)*(V_vec_gauss_r + sqrt(-1)*V_vec_gauss_i);
    end

    if (BiVarGaussian & Alamouti)  % BiVariate Gaussian and Alamouti Coding
        V_vec_ALM_gauss_r =  CorrMat*randn(2,N_symbols*2);
        V_vec_ALM_gauss_i =  CorrMat*randn(2,N_symbols*2);
        V_vec_ALM_gauss   =  1/sqrt(2)*(V_vec_ALM_gauss_r + sqrt(-1)*V_vec_ALM_gauss_i);
    end
    % -----------------

    % MC Simulation runs
    for i = 1:N_symbols
        % Get 1 symbol vector (2x1)
        % Get 1 noise vector (2x1)

        % Generate System Model
        % ---------------------
        % y = Hx + n
        % Channel
        H = 1/sqrt(2) .*(randn(2) + sqrt(-1).*randn(2));
        % Noise
        if (BiVarClassA)  % BiVariate Middleton Class A
            V = V_vec(i,:).';
            if (Alamouti) % Alamouti Coding
                V_ALM = V_vec_ALM(2*i-1:2*i,:).';
            end
        end

        if (BiVarGaussian)    % BiVariate Gaussian
            V_G = V_vec_gauss(:,i);
            if (Alamouti) % Alamouti Coding
                V_ALM_G = V_vec_ALM_gauss(:,2*i-1:2*i);
            end

        end
        % Received (w/o noise)
        Y = H*input_sym_mod(i,:).';

        % Received (Alamouti w/o noise)
        if (Alamouti) % Alamouti Coding
            S1_S2 = input_sym_mod_ALM(i,:).';
            S_ALM = [S1_S2(1) S1_S2(2); -S1_S2(2)' S1_S2(1)'];
            Y_ALM = S_ALM * H;
        end
        % -----------------------

        % Additive BiVariate Gaussian Noise
        % ---------------------------------
        if (BiVarGaussian)  % BiVariate Gaussian
            % --- Received Signal (w noise)
            Y_AWGN = Y + sqrt(Es/SNR*2)*V_G;

            % --- Receivers
            % SM with Gaussian ML
            if (SM_GaussianML)
                D_SM_ML_G(i,:) = RFI_TwoAntennaMLRx(Y_AWGN,H,codebook, M, sigma1_est, sigma2_est, kappa_g_est);
            end
            % SM with ZF receiver
            if (SM_ZF)
                D_SM_ZF_G(i,:) = RFI_ZeroForcingRx(Y_AWGN, H, M);
            end
            % SM with Class A ML Optimum
            if (SM_MLOpt)
                D_SM_MLOpt_G(i,:) = RFI_BiVarClassAMLRx(Y_AWGN, H, codebook, M, Es, SNR, A_ca_est_g, Gamma1_ca_est_g, Gamma2_ca_est_g, kappa_ca_est_g);
            end
            % SM with Class A ML SubOptimal (Two-Piece)
            if (SM_MLSubOpt2)
                D_SM_MLSubOpt2_G(i,:) = RFI_BiVarClassASubOptML2Rx(Y_AWGN, H, codebook, M, Es, SNR, A_ca_est_g, Gamma1_ca_est_g, Gamma2_ca_est_g, kappa_ca_est_g);
            end
            % SM with Class A ML SubOptimal (Four-Piece)
            if (SM_MLSubOpt4)
                D_SM_MLSubOpt4_G(i,:) = RFI_BiVarClassASubOptML4Rx(Y_AWGN, H, codebook, M, Es, SNR, A_ca_est_g, Gamma1_ca_est_g, Gamma2_ca_est_g, kappa_ca_est_g);
            end
            % Alamouti Coding
            if (Alamouti)
                % - Received Alamouti Signal (w noise)
                Y_ALM_AWGN = Y_ALM + sqrt(Es_ALM/SNR*2)*V_ALM_G;

                % - Receivers
                D_ALM_G(i,:) = RFI_AlamoutiRx(Y_ALM_AWGN, H, M^2);
            end
        end

        % Additive BiVariate Middleton Class A noise
        % ------------------------------------------
        if (BiVarClassA)  % BiVariate Gaussian
            % --- Received Signal (w noise)
            Y_I = Y + sqrt(Es/SNR*2)*V;

            % --- Receivers
            % SM with Gaussian ML
            if (SM_GaussianML)
                D_SM_ML_I(i,:) = RFI_TwoAntennaMLRx(Y_I,H,codebook, M, sigma1_est, sigma2_est, kappa_g_est);
            end
            % SM with ZF receiver
            if (SM_ZF)
                D_SM_ZF_I(i,:) = RFI_ZeroForcingRx(Y_I, H, M);
            end
            % SM with Class A ML Optimum
            if (SM_MLOpt)
                D_SM_MLOpt_I(i,:) = RFI_BiVarClassAMLRx(Y_I, H, codebook, M, Es, SNR, A_est, Gamma1_est, Gamma2_est, kappa_est);
            end
            % SM with Class A ML SubOptimal (Two-Piece)
            if (SM_MLSubOpt2)
                D_SM_MLSubOpt2_I(i,:) = RFI_BiVarClassASubOptML2Rx(Y_I, H, codebook, M, Es, SNR, A_est, Gamma1_est, Gamma2_est, kappa_est);
            end
            % SM with Class A ML SubOptimal (Four-Piece)
            if (SM_MLSubOpt4)
                D_SM_MLSubOpt4_I(i,:) = RFI_BiVarClassASubOptML4Rx(Y_I, H, codebook, M, Es, SNR, A_est, Gamma1_est, Gamma2_est, kappa_est);
            end
            % Alamouti Coding
            if (Alamouti)
                % - Received Alamouti Signal (w noise)
                Y_ALM_I = Y_ALM + sqrt(Es_ALM/SNR*2)*V_ALM;

                % - Receivers
                D_ALM_I(i,:) = RFI_AlamoutiRx(Y_ALM_I, H, M^2);
            end         
        end
    end

    if (BiVarGaussian)
        if (SM_MLOpt)
            errSym_SM_MLOpt_G(s)        = sum(sum(1*abs(D_SM_MLOpt_G - input_symbols),2)>0)/N_symbols;
        end
        if (SM_MLSubOpt2)
            errSym_SM_MLSubOpt2_G(s)    = sum(sum(1*abs(D_SM_MLSubOpt2_G - input_symbols),2)>0)/N_symbols;
        end
        if (SM_MLSubOpt4)
            errSym_SM_MLSubOpt4_G(s)    = sum(sum(1*abs(D_SM_MLSubOpt4_G - input_symbols),2)>0)/N_symbols;
        end
        if (SM_GaussianML)
            errSym_SM_ML_G(s)           = sum(sum(1*abs(D_SM_ML_G - input_symbols),2)>0)/N_symbols;
        end
        if (SM_ZF)
            errSym_SM_ZF_G(s)           = sum(sum(1*abs(D_SM_ZF_G - input_symbols),2)>0)/N_symbols;
        end
        if (Alamouti)
            errSym_ALM_G(s)             = sum(sum(1*abs(D_ALM_G - input_symbols_ALM),2)>0)/N_symbols;
        end
    end
    if (BiVarClassA)
        if (SM_MLOpt)
            errSym_SM_MLOpt_I(s)        = sum(sum(1*abs(D_SM_MLOpt_I - input_symbols),2)>0)/N_symbols;
        end
        if (SM_MLSubOpt2)
            errSym_SM_MLSubOpt2_I(s)    = sum(sum(1*abs(D_SM_MLSubOpt2_I - input_symbols),2)>0)/N_symbols;
        end
        if (SM_MLSubOpt4)
            errSym_SM_MLSubOpt4_I(s)    = sum(sum(1*abs(D_SM_MLSubOpt4_I - input_symbols),2)>0)/N_symbols;
        end
        if (SM_GaussianML)
            errSym_SM_ML_I(s)           = sum(sum(1*abs(D_SM_ML_I - input_symbols),2)>0)/N_symbols;
        end
        if (SM_ZF)
            errSym_SM_ZF_I(s)          = sum(sum(1*abs(D_SM_ZF_I - input_symbols),2)>0)/N_symbols;
        end
        if (Alamouti)
            errSym_ALM_I(s)             = sum(sum(1*abs(D_ALM_I - input_symbols_ALM),2)>0)/N_symbols;
        end
    end

end
% End of Simulation -------------------------------------------------------


% Make Plots
% -------------------------------------------------------------------------
inds = [];
s = cell(1,2*6);
h = zeros(1,2*6);
figure;

if (BiVarGaussian)
    if (SM_MLOpt)
        h(1) = semilogy(10*log10(vectorSNR), errSym_SM_MLOpt_G, 'bo-'); hold on;
        inds = [inds 1];
    end
    if (SM_MLSubOpt2)
        h(2) =  semilogy(10*log10(vectorSNR), errSym_SM_MLSubOpt2_G, 'rx-');  hold on;
        inds = [inds 2];
    end
    if (SM_MLSubOpt4)
        h(3) = semilogy(10*log10(vectorSNR), errSym_SM_MLSubOpt4_G, 'gs-');  hold on;
        inds = [inds 3];
    end
    if (SM_GaussianML)
        h(4) = semilogy(10*log10(vectorSNR), errSym_SM_ML_G, 'mv-');  hold on;
        inds = [inds 4];
    end
    if (SM_ZF)
        h(5) = semilogy(10*log10(vectorSNR), errSym_SM_ZF_G, 'c^-');  hold on;
        inds = [inds 5];
    end
    if (Alamouti)
        h(6) = semilogy(10*log10(vectorSNR), errSym_ALM_G, 'k*-');  hold on;
        inds = [inds 6];
    end
end
if (BiVarClassA)
    if (SM_MLOpt)
        h(7) = semilogy(10*log10(vectorSNR), errSym_SM_MLOpt_I, 'bo-.');  hold on;
        inds = [inds 7];
    end
    if (SM_MLSubOpt2)
        h(8) =  semilogy(10*log10(vectorSNR), errSym_SM_MLSubOpt2_I, 'rx-.');  hold on;
        inds = [inds 8];
    end
    if (SM_MLSubOpt4)
        h(9) = semilogy(10*log10(vectorSNR), errSym_SM_MLSubOpt4_I, 'gs-.');  hold on;
        inds = [inds 9];
    end
    if (SM_GaussianML)
        h(10) = semilogy(10*log10(vectorSNR), errSym_SM_ML_I, 'mv-.');  hold on;
        inds = [inds 10];
    end
    if (SM_ZF)
        h(11) = semilogy(10*log10(vectorSNR), errSym_SM_ZF_I, 'c^-.');  hold on;
        inds = [inds 11];
    end
    if (Alamouti)
        h(12) = semilogy(10*log10(vectorSNR), errSym_ALM_I, 'k*-.');  hold on;
        inds = [inds 12];
    end
end

s{1} = 'SM with Opt ML [Gaussian Noise]';
s{2} = 'SM with SubOpt ML (Two-Piece) [Gaussian Noise]';
s{3} = 'SM with SubOpt ML (Four-Piece) [Gaussian Noise]';
s{4} = 'SM with Gaussian ML [Gaussian Noise]';
s{5} = 'SM with ZF [Gaussian Noise]';
s{6} = 'Alamouti [Gaussian Noise]';
s{7} = 'SM with Opt ML [Class A Noise]';
s{8} = 'SM with SubOpt ML (Two-Piece) [Class A Noise]';
s{9} = 'SM with SubOpt ML (Four-Piece) [Class A Noise]';
s{10} = 'SM with Gaussian ML [Class A Noise]';
s{11} = 'SM with ZF [Class A Noise]';
s{12} = 'Alamouti [Class A Noise]';

xlabel('SNR [in dB]'); ylabel (' Symbol Error Rate');
legend(h(inds), s{inds});


% --- Executes on button press in ClearWorkSpace.
function ClearWorkSpace_Callback(hObject, eventdata, handles)
% hObject    handle to ClearWorkSpace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clear;
