function [dem_bits err_rate_wiener] = RFI_detect_wiener( corrupted_signal, trans_bits, N, w  )
%[dem_bits err_rate_wiener] = RFI_detect_wiener(corrupted_signal,trans_bits, N, w  );
%This function demodulates the signal by filtering it with a wiener filter 
%and then demodulating it with a correlator receiver for Class A interference 
%for the binary digital signaling like 2 PAM. It assumes that the constellation is 
%symmetric with respect to zero.
%
% Inputs:   corrupted_signal    - the transmitted signal corrupted by noise
%           transmitted_bits     - the vector of transmitted bits
%           N                   - number of samples per symbol
%           w                   - vector containing the designed Wiener
%                                 filter coefficients
%
% Outputs:  dem_bits            - vector of demodulated bits
%           err_rate_wiener     - the bit error rate using Wiener filtering
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

no_symb = length(corrupted_signal)/N;
corrupted_signal=reshape(corrupted_signal,N,no_symb);
r_filt=filter(w,1,corrupted_signal);
r_d=sum(r_filt);
dem_bits = sign(r_d);

err_rate_wiener=sum(dem_bits~=trans_bits)/no_symb;