function [ nonl_out ] = RFI_nonlinearity( x, A, Gamma, N_T, SNR )
%RFI_NONLINEARITY implements the nonlinearity found in the small signal
%approximation
% Inputs:   x                   - sample data matrix where the nonlinearity
%                                 is to be evaluated
%           A, Gamma            - Class A parameters
%           N_T                 - number of terms to retain in infinite
%                                 series
%           SNR                  - SNR
%        
% Outputs:  nonl_out             - value of non-linearity
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

%x=x/sqrt(1 + 10^(-SNR/10));
K =  10^(-SNR/10);
var1=0;
var2=0;
A_over_m = 1; % improve performance and range of usable A
sigma_sq_prime = A*Gamma; % This variable is sigma_sq * (1+gamma), this is done to induce recursion also on 
                        % sigma
x=x*sqrt((1+Gamma)*A)/sqrt(K); % This is to enable us to use the new modified variable defined above in the exponential of
                   % the recursion
%Evaluate the pdf based on Eq. 7 in [1]
for i=1:N_T
    var1 = var1 + (A_over_m/sqrt(sigma_sq_prime))*exp(-x.^2/(2*sigma_sq_prime));
    var2 = var2 + (A_over_m/(sigma_sq_prime)^(1.5))*exp(-x.^2/(2*sigma_sq_prime)).*x;
    A_over_m = A_over_m * A/i; %improves performance and extends the range of A by recursive implementation.
    sigma_sq_prime = sigma_sq_prime + 1;
end;
var1 = var1*sqrt((1+Gamma)*A)/sqrt(K);
var2 = var2*(((1+Gamma)*A))/K;
nonl_out = - var2./var1;