function varargout = RFI_DemoFileTRSF(varargin)
% RFI_DEMOFILETRSF M-file for RFI_DemoFileTRSF.fig
%      RFI_DEMOFILETRSF, by itself, creates a new RFI_DEMOFILETRSF or raises the existing
%      singleton*.
%
%      H = RFI_DEMOFILETRSF returns the handle to a new RFI_DEMOFILETRSF or the handle to
%      the existing singleton*.
%
%      RFI_DEMOFILETRSF('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFI_DEMOFILETRSF.M with the given input arguments.
%
%      RFI_DEMOFILETRSF('Property','Value',...) creates a new RFI_DEMOFILETRSF or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RFI_DemoFileTRSF_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to RFI_DemoFileTRSF_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help RFI_DemoFileTRSF

% Last Modified by GUIDE v2.5 04-Feb-2010 16:53:48

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @RFI_DemoFileTRSF_OpeningFcn, ...
    'gui_OutputFcn',  @RFI_DemoFileTRSF_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoFileTRSF is made visible.
function RFI_DemoFileTRSF_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RFI_DemoFileTRSF (see VARARGIN)

%addpath(genpath('../../../'))  %add the directory that contains the required functions

% Choose default command line output for RFI_DemoFileTRSF
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoFileTRSF wait for user response (see UIRESUME)
% uiwait(handles.figure1);


ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(imresize(ESPL_logo,0.8));
axis equal;
axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');



% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoFileTRSF_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function bits_per_itr_Callback(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bits_per_itr as text
%        str2double(get(hObject,'String')) returns contents of bits_per_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end


% --- Executes during object creation, after setting all properties.
function bits_per_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function no_itr_Callback(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of no_itr as text
%        str2double(get(hObject,'String')) returns contents of no_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if (isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function no_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRvalue_Callback(hObject, eventdata, handles)
% hObject    handle to SNRvalue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRvalue as text
%        str2double(get(hObject,'String')) returns contents of SNRvalue as a double


% --- Executes during object creation, after setting all properties.
function SNRvalue_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRvalue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_high_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_high_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_high_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
lower_limit = str2double(get(handles.SNRvalue, 'String'));
if (user_entry < lower_limit)
    set(hObject, 'String', num2str(lower_limit+30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_high_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNR_step_size_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_step_size as text
%        str2double(get(hObject,'String')) returns contents of SNR_step_size as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_step_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function A_Callback(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A as text
%        str2double(get(hObject,'String')) returns contents of A as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.35');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-2)
    set(hObject,'String','0.35');
    errordlg('A range exceeded. A should belong to [0.01,1].','Bad Input','modal')
end;


% --- Executes during object creation, after setting all properties.
function A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma as text
%        str2double(get(hObject,'String')) returns contents of Gamma as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.001');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-6)
    set(hObject,'String','0.001');
    errordlg('Gamma range exceeded. Gamma should belong to [10^-6,1].','Bad Input','modal')
end;

% --- Executes during object creation, after setting all properties.
function Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_Callback(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r as text
%        str2double(get(hObject,'String')) returns contents of r as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry < 0 | user_entry > 1)
    set(hObject,'String','0.1');
    errordlg('Invalid value for r. r should be between 0 and 1.','Bad Input','modal');
end;



% --- Executes during object creation, after setting all properties.
function r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delay_Callback(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay as text
%        str2double(get(hObject,'String')) returns contents of delay as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a postive numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function sampling_ratio_Callback(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sampling_ratio as text
%        str2double(get(hObject,'String')) returns contents of sampling_ratio as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function sampling_ratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in corr_rx.
function corr_rx_Callback(hObject, eventdata, handles)
% hObject    handle to corr_rx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of corr_rx


% --- Executes on button press in wiener_dtc.
function wiener_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to wiener_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of wiener_dtc


% --- Executes on button press in bayesian_dtc.
function bayesian_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to bayesian_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bayesian_dtc


% --- Executes on button press in start_sim.
function start_sim_Callback(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% The UserData is being used to indicate if the button is in the Start mode
% (0) or the Stop mode (1)
% if (get(hObject, 'UserData') == 0)
%     set(hObject,'String','Stop Simulation');
%     set(hObject,'UserData',1);
% else
%     % Add ending code sequence here depending on the desired ending
%     % behavior
%     set(hObject,'String','Start Simulation');
%     set(hObject,'UserData',0);
%     return;
% end;
%Temporary button disable functionality
%

set(handles.done_tag, 'String','');
set(handles.ber_tag, 'String', '');
set(handles.file_name, 'String', '');
set(handles.progress, 'String', '');

set(hObject,'enable','inactive');
set(hObject, 'String', 'Running...'); drawnow;
% Obtain necessary data from the GUI handles structure, I chose to get them
% rather than store then in the handles structure using guidata because
% the amount of data is small and this saves a lot of work in updating the
% fields and save some memory space

val = get(handles.Noise_type,'Value');
switch val
    case 1
        is_class_A=1;
        is_alpha=0;
    case 2
        is_class_A=0;
        is_alpha=1;
end;

NumTermsPDF = 100; % number of terms used in the pdf expansion of class A

% Get Class A parameters
A = str2double(get(handles.A, 'String'));
T = str2double(get(handles.Gamma, 'String'));

quant_levels = str2double(get(handles.quant_level, 'String'));% number of quantization levels

% Get Alpha Stable Parameters
alpha = str2double(get(handles.alpha, 'String')); % Characteristic Exponent
disper = str2double(get(handles.disp, 'String'));% Dispersion Parameter
delta = str2double(get(handles.delta, 'String'));% Localization Parameter

% Get Simulation Settings
SNR = str2double(get(handles.SNRvalue, 'String'));

no_bits = 8;
bytes_read = str2double(get(handles.read_size,'String'));
M=2; %number of constellation points (currently only 2 is supported)
delay = str2double(get(handles.delay, 'String')); %delay of the raised cosine filter
sampling_ratio = str2double(get(handles.sampling_ratio, 'String')); %the sampling ratio for the raised cosine filter
r = str2double(get(handles.r, 'String')); % r for the raised cosine filter
N=2*delay*sampling_ratio; %number of sampled points (raised cosine pulse shape, and received signal)

% Pulse Shape Design
y=rcosine(1,sampling_ratio,'sqrt',r,delay);%Need to be adjusted to fit N (defined above)
%need to choose the right parameters according to the value of N
%the value of N should satisfy N=k*2*delay (see help rcosine)
y=y(1:length(y)-1);

% get the selected detection method
val = get(handles.detect_method,'Value');
str = get(handles.detect_method,'String');

if (val == 5 && is_class_A)
    % Settings for resolution of pdf generation
    MaxVal = 1; XRes = 10000;
    x = [linspace(-20, -MaxVal-1, XRes) linspace(-MaxVal, MaxVal, XRes) ...
        linspace(MaxVal+1, 20, XRes)]; % Range within which the data is generated
    thePDF = RFI_MakePDFClassA( x, A, T, NumTermsPDF);

    [partition, codebook] = lloyds(thePDF,quant_levels); % codebook generation
elseif (val == 2)
    % Wiener Filter Design precalculations (autocorrelation)
    y_cor=xcorr(y,'unbiased');
    y_cor=y_cor(N:length(y_cor));
    Ry=toeplitz(y_cor); % The autocorrelation Matrix of y
    w=inv(Ry+10^(-SNR/10)*eye(N))*y_cor';%wiener filter coefficients (Solving Wiener-Hopf Equations)
end;

infile = get(handles.input_file, 'String' ); % file must be in the same directory
outfile = get(handles.output_file, 'String' );

%RDfid = fopen(strcat('./',infile),'r');
RDfid = fopen(infile,'r');
if (RDfid == -1)
    errordlg('Input file does not exist. Please choose a file in the current directory!','Irrational Settings','modal')
    set(hObject,'enable','on');
    return;
end;
%s = dir(which(infile));
s = dir(infile);
fileSIZE = s.bytes;
set(handles.file_name, 'String', [infile ' has been opened']);drawnow;
if (strcmp(infile,outfile))
    errordlg('Input and Output filenames can not be the same !','Irrational Settings','modal')
    set(hObject,'enable','on');
    return;
end;
WRfid = fopen(outfile, 'w');
if (WRfid == -1 && (~isempty(outfile)))
    errordlg('Error opening output file in write mode !', 'Error Dialog');
    set(hObject,'enable','on');
    fclose(RDfid);
    return;
end;

%total_WRbytes = 0; % represents the number of bytes already written to the file
err_rate_total =0;
bits_trans = 0; % number of transmitted bits over the channel
while(fileSIZE-bits_trans/8>0)
    bytes_to_read = min(bytes_read,fileSIZE - bits_trans/8);
    [x_pul x_mod Fstatus] = RFI_getANDmodFDATA( RDfid, bytes_to_read, 'uint8',8, 2, y );

    if (Fstatus==-1) % probably can be moved into the while condition
        break;
    end;

    % Noise generation and SNR sweep
    if (is_class_A == 1)
        noise = RFI_MakeDataClassA(A,T,NumTermsPDF,N*no_bits*bytes_to_read);%can be included inside of the loop to provide more
        %randomness at the cost
        %of much more running time
        z=noise*sqrt(10^(-SNR/10)); %renormalize the noise for correct SNR
        r=x_pul+z(:); % add noise to the signal
    else
        noise = RFI_MakeDataAlphaStable(alpha, disper, delta, N*no_bits*bytes_to_read);
        Es = (disper*10^(SNR/10));               % Signal Power as per the definition of a generalized SNR.
        r = x_pul.*sqrt(Es) + noise(:);      % add noise to the signal
    end;


    switch str{val};
        case 'Correlation Receiver'
            [dem_bits err_rate] = RFI_Matched_Filter( r, x_mod, N, sampling_ratio*delay, sampling_ratio, y, 2);
        case 'Wiener Filtering Detection'
            [dem_bits err_rate] = RFI_detect_wiener( r, x_mod, N, w, delay, sampling_ratio, y, 2);
        case 'Bayesian Detection'
            [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, A, T, y, NumTermsPDF, SNR);
        case 'Small Signal Approximation'
            [dem_bits err_rate] = RFI_detect_appx( r, x_mod, N, A, T, y, NumTermsPDF, SNR);
        case 'Quantized Bayesian Detection'
            [dem_bits err_rate] = RFI_detect_opt_quant( r, x_mod, N, A, T, y, partition, codebook, SNR, NumTermsPDF );
        case 'Optimal Myriad Detection'
            [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alpha, disper, 1, delay, sampling_ratio, y, 2 ); 
        case 'Selection Myriad Detection'
            [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alpha, disper, 2, delay, sampling_ratio, y, 2 );  
        otherwise

    end;

    [ count ] = RFI_decANDwrtFDATA( WRfid, dem_bits, 'uint8',8, M );
    bits_trans = bits_trans + length(dem_bits);
    %total_WRbytes = total_WRbytes + count;
    percDONE = bits_trans/fileSIZE/8 *100; %division by 8 to account for the fact that 1 byte is 8 bits
    set(handles.progress, 'String', [num2str(ceil(percDONE)) '% completed']);drawnow;

    err_rate_total = (err_rate * length(dem_bits) + err_rate_total* bits_trans) / (bits_trans + length(dem_bits));
    
end;

set(handles.progress, 'String', [num2str(ceil(100)) '% completed']);drawnow;
fclose(RDfid);
if (WRfid ~= -1)
    fclose(WRfid);
end

if (~isempty(outfile))    
    set(handles.done_tag, 'String', [outfile ' has been written']);drawnow;
end;

set(handles.ber_tag, 'String', ['Bit Error Rate =' num2str(err_rate_total)]);drawnow;

% Still beta version
img_status = get(handles.ANLZvideo, 'Value');
if (img_status == 1)
    mov_org = aviread(infile);
    s = lasterror('reset');
    try
        mov_rcv = aviread(outfile);
    catch
        s = lasterror('reset');
    end
    if (~strcmp(s.message,''))
        errordlg('Output file not recognizable as .avi due to errors in transmission','Irrational Settings','modal')
    else
        g = size(mov_org);
        no_frames = g(2);
        err = zeros(1,no_frames);
        for i=1:no_frames
            f1= mov_org(i).cdata;
            f2= mov_rcv(i).cdata;
            err(i) = mean(mean((f1-f2).^2));
        end;
        figure; plot(err); xlabel('Frame Number'); ylabel('Mean squared error'); title('Mean squared error per frame');
    end
end;

set(hObject,'enable','on');
set(hObject, 'String', 'Start Simulation'); drawnow;

% --- Executes on key press over start_sim with no controls selected.
function start_sim_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on selection change in Noise_type.
function Noise_type_Callback(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Noise_type contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Noise_type
val = get(hObject,'Value');
set(handles.detect_method, 'Value', 1);

str_A = {'Correlation Receiver';'Wiener Filtering Detection';'Bayesian Detection';'Small Signal Approximation';'Quantized Bayesian Detection'};
str_alpha = {'Correlation Receiver';'Wiener Filtering Detection';'Optimal Myriad Detection';'Selection Myriad Detection'};

switch val
    case 1
        set(handles.text11,'Visible','on');
        set(handles.A,'Visible','on');
        set(handles.text12,'Visible','on');
        set(handles.Gamma,'Visible','on');
        set(handles.alpha,'Visible','off');
        set(handles.disp,'Visible','off');
        set(handles.delta,'Visible','off');
        set(handles.text19,'Visible','off');
        set(handles.text20,'Visible','off');
        set(handles.text21,'Visible','off');
        set(handles.detect_method, 'String', str_A);
    case 2
        set(handles.text11,'Visible','off');
        set(handles.A,'Visible','off');
        set(handles.text12,'Visible','off');
        set(handles.Gamma,'Visible','off');
        set(handles.alpha,'Visible','on');
        set(handles.disp,'Visible','on');
        set(handles.delta,'Visible','on');
        set(handles.text19,'Visible','on');
        set(handles.text20,'Visible','on');
        set(handles.text21,'Visible','on');
        set(handles.detect_method, 'String', str_alpha);
        set(handles.quant_level,'Visible','off');
        set(handles.levels,'Visible','off');
end;
% proceed with callback...

% --- Executes during object creation, after setting all properties.
function Noise_type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function alpha_Callback(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of alpha as text
%        str2double(get(hObject,'String')) returns contents of alpha as a double


% --- Executes during object creation, after setting all properties.
function alpha_CreateFcn(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function disp_Callback(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of disp as text
%        str2double(get(hObject,'String')) returns contents of disp as a double


% --- Executes during object creation, after setting all properties.
function disp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delta_Callback(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delta as text
%        str2double(get(hObject,'String')) returns contents of delta as a double


% --- Executes during object creation, after setting all properties.
function delta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on button press in myriad_dtc.
function myriad_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to myriad_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of myriad_dtc




% --- Executes on button press in selec_myriad.
function selec_myriad_Callback(hObject, eventdata, handles)
% hObject    handle to selec_myriad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of selec_myriad




% --- Executes on button press in quant.
function quant_Callback(hObject, eventdata, handles)
% hObject    handle to quant (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of quant
val = get(hObject,'Value');
if val == 0
    set(handles.quant_level,'Visible','off');
    set(handles.levels,'Visible','off');
else
    set(handles.quant_level,'Visible','on');
    set(handles.levels,'Visible','on');
end;


function quant_level_Callback(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of quant_level as text
%        str2double(get(hObject,'String')) returns contents of quant_level as a double


% --- Executes during object creation, after setting all properties.
function quant_level_CreateFcn(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in small_sig_aprx.
function small_sig_aprx_Callback(hObject, eventdata, handles)
% hObject    handle to small_sig_aprx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of small_sig_aprx





function output_file_Callback(hObject, eventdata, handles)
% hObject    handle to output_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of output_file as text
%        str2double(get(hObject,'String')) returns contents of output_file as a double


% --- Executes during object creation, after setting all properties.
function output_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to output_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in detect_method.
function detect_method_Callback(hObject, eventdata, handles)
% hObject    handle to detect_method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns detect_method contents as cell array
%        contents{get(hObject,'Value')} returns selected item from detect_method
val = get(handles.Noise_type, 'Value');
if (get(hObject,'Value')==5 && val ==1)   % corresponds to the quantized level entry string
    set(handles.quant_level,'Visible','on');
    set(handles.levels,'Visible','on');
else
    set(handles.quant_level,'Visible','off');
    set(handles.levels,'Visible','off');
end;

% Set current data to the selected data set.




% --- Executes during object creation, after setting all properties.
function detect_method_CreateFcn(hObject, eventdata, handles)
% hObject    handle to detect_method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function input_file_Callback(hObject, eventdata, handles)
% hObject    handle to input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of input_file as text
%        str2double(get(hObject,'String')) returns contents of input_file as a double


% --- Executes during object creation, after setting all properties.
function input_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function read_size_Callback(hObject, eventdata, handles)
% hObject    handle to read_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of read_size as text
%        str2double(get(hObject,'String')) returns contents of read_size as a double
if (str2double(get(hObject,'String')) <= 0)
    set(hObject, 'String', '1000');
    errordlg('Number of bytes to be read in each iteration should be greater than 0 !', 'Error Dialog');
end;

if (str2double(get(hObject,'String')) ~= floor(str2double(get(hObject,'String'))))
    set(hObject, 'String', '1000');
    errordlg('Number of bytes to be read in each iteration should be natural number !', 'Error Dialog');
end;


% --- Executes during object creation, after setting all properties.
function read_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to read_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit25_Callback(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit25 as text
%        str2double(get(hObject,'String')) returns contents of edit25 as a double


% --- Executes during object creation, after setting all properties.
function edit25_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in ANLZvideo.
function ANLZvideo_Callback(hObject, eventdata, handles)
% hObject    handle to ANLZvideo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ANLZvideo




% --- Executes on button press in input_browse.
function input_browse_Callback(hObject, eventdata, handles)
% hObject    handle to input_browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uigetfile('*','Choose a file to transfer'); 
if (FileName ~= 0)
    set(handles.input_file,'String',[PathName FileName]);
end;




% --- Executes on button press in output_file_button.
function output_file_button_Callback(hObject, eventdata, handles)
% hObject    handle to output_file_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uiputfile('*.*','Choose a file to save the result to');
if (FileName ~= 0)
    if (FileName(length(FileName)) == '*') %remove * character in case the user didnt include a file extension
        FileName = FileName(1:length(FileName)-2);
    end;
    set(handles.output_file,'String',[PathName FileName]);
end;

