function varargout = RFI_DemoStatisticalModeling(varargin)
%RFI_DEMOSTATISTICALMODELING M-file for RFI_DemoStatisticalModeling.fig
%      RFI_DEMOSTATISTICALMODELING, by itself, creates a new RFI_DEMOSTATISTICALMODELING or raises the existing
%      singleton*.
%
%      H = RFI_DEMOSTATISTICALMODELING returns the handle to a new RFI_DEMOSTATISTICALMODELING or the handle to
%      the existing singleton*.
%
%      RFI_DEMOSTATISTICALMODELING('Property','Value',...) creates a new RFI_DEMOSTATISTICALMODELING using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to RFI_DemoStatisticalModeling_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      RFI_DEMOSTATISTICALMODELING('CALLBACK') and RFI_DEMOSTATISTICALMODELING('CALLBACK',hObject,...) call the
%      local function named CALLBACK in RFI_DEMOSTATISTICALMODELING.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RFI_DemoStatisticalModeling

% Last Modified by GUIDE v2.5 16-Jul-2009 03:14:58

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @RFI_DemoStatisticalModeling_OpeningFcn, ...
    'gui_OutputFcn',  @RFI_DemoStatisticalModeling_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoStatisticalModeling is made visible.
function RFI_DemoStatisticalModeling_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for RFI_DemoStatisticalModeling
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoStatisticalModeling wait for user response (see UIRESUME)
% uiwait(handles.figure1);
clc;
ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(imresize(ESPL_logo, 0.4));
axis equal;
axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');

% Default selection: Gaussian 
set(handles.RFIGen,'SelectedObject',handles.RFIGen_Gaussian);

% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoStatisticalModeling_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function Status_Callback(hObject, eventdata, handles)
% hObject    handle to Status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Status as text
%        str2double(get(hObject,'String')) returns contents of Status as a double


% --- Executes during object creation, after setting all properties.
function Status_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ClearStatus.
function ClearStatus_Callback(hObject, eventdata, handles)
% hObject    handle to ClearStatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Status,'String','');


function ResultsBox_Callback(hObject, eventdata, handles)
% hObject    handle to ResultsBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ResultsBox as text
%        str2double(get(hObject,'String')) returns contents of ResultsBox as a double


% --- Executes during object creation, after setting all properties.
function ResultsBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ResultsBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarGaussian_kappa_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarGaussian_kappa as text
%        str2double(get(hObject,'String')) returns contents of BiVarGaussian_kappa as a double


% --- Executes during object creation, after setting all properties.
function BiVarGaussian_kappa_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_Gamma2_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Gamma2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_Gamma2 as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_Gamma2 as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_Gamma2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Gamma2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_kappa_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_kappa as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_kappa as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_kappa_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_kappa (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_Gamma1_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Gamma1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_Gamma1 as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_Gamma1 as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_Gamma1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Gamma1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_A_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_A as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_A as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MCA_Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_Gamma as text
%        str2double(get(hObject,'String')) returns contents of MCA_Gamma as a double


% --- Executes during object creation, after setting all properties.
function MCA_Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MCA_A_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_A as text
%        str2double(get(hObject,'String')) returns contents of MCA_A as a double


% --- Executes during object creation, after setting all properties.
function MCA_A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SAS_Dispersion_Callback(hObject, eventdata, handles)
% hObject    handle to SAS_Dispersion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SAS_Dispersion as text
%        str2double(get(hObject,'String')) returns contents of SAS_Dispersion as a double


% --- Executes during object creation, after setting all properties.
function SAS_Dispersion_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAS_Dispersion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SAS_CharExp_Callback(hObject, eventdata, handles)
% hObject    handle to SAS_CharExp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SAS_CharExp as text
%        str2double(get(hObject,'String')) returns contents of SAS_CharExp as a double


% --- Executes during object creation, after setting all properties.
function SAS_CharExp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAS_CharExp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SAS_Localization_Callback(hObject, eventdata, handles)
% hObject    handle to SAS_Localization (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SAS_Localization as text
%        str2double(get(hObject,'String')) returns contents of SAS_Localization as a double


% --- Executes during object creation, after setting all properties.
function SAS_Localization_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAS_Localization (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Filename_Callback(hObject, eventdata, handles)
% hObject    handle to Filename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Filename as text
%        str2double(get(hObject,'String')) returns contents of Filename as a double


% --- Executes during object creation, after setting all properties.
function Filename_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Filename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in FileFormatHelp.
function FileFormatHelp_Callback(hObject, eventdata, handles)
% hObject    handle to FileFormatHelp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
helpdlg('One Column for NAntennas = 1 and Real or Envelope Data. Two Column data otherwise separated by space(s).','Expected File Format');


function NAntennas_Callback(hObject, eventdata, handles)
% hObject    handle to NAntennas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NAntennas as text
%        str2double(get(hObject,'String')) returns contents of NAntennas as a double

NAntennas = str2double(get(handles.NAntennas,'String'));
if (NAntennas ~= 1 && NAntennas ~= 2)
    errordlg('Only One or Two antenna measurement data fitting is currently supported.', 'Error Dialog');
    set(handles.NAntennas,'String','1');
end

NAntennas    = str2double(get(handles.NAntennas,'String'));
RFIGen_index = get(get(handles.RFIGen,'SelectedObject'),'Userdata');
if (RFIGen_index == 1)
    % If RFI Generator is measurement data set, then also change the the
    % modeling types
    if (NAntennas == 1)
        set(handles.RFIFit_MCA,'Enable','on');
        set(handles.RFIFit_SAS,'Enable','on');
        set(handles.RFIFit_Gaussian,'Enable','on');
        set(handles.RFIFit_BiVarMCA,'Enable','off'); set(handles.RFIFit_BiVarMCA,'Value',0);
        set(handles.RFIFit_BiVarGaussian,'Enable','off'); set(handles.RFIFit_BiVarGaussian,'Value',0);

        set(handles.FileFormat,'String',strvcat('Real Data (I or Q)','Complex Data (I + j*Q)','Envelope Data'));
    else
        set(handles.RFIFit_MCA,'Enable','off'); set(handles.RFIFit_MCA,'Value',0);
        set(handles.RFIFit_SAS,'Enable','off'); set(handles.RFIFit_SAS,'Value',0);
        set(handles.RFIFit_Gaussian,'Enable','off'); set(handles.RFIFit_Gaussian,'Value',0);
        set(handles.RFIFit_BiVarMCA,'Enable','on');
        set(handles.RFIFit_BiVarGaussian,'Enable','on');

        set(handles.FileFormat,'String','Real Data (I or Q)');
    end
else
    % If measured data is not checked, then just change file format options
    % based on NAntennas selection
    if (NAntennas == 1)
        set(handles.FileFormat,'String',strvcat('Real Data (I or Q)','Complex Data (I + j*Q)','Envelope Data'));
        set(handles.FileFormat,'Value',1);
        set(handles.FileFormat,'Max',3);
    else
        set(handles.FileFormat,'String','Real Data (I or Q)');
        set(handles.FileFormat,'Value',1);
        set(handles.FileFormat,'Max',1);
    end
end




% --- Executes during object creation, after setting all properties.
function NAntennas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NAntennas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in FileBrowse.
function FileBrowse_Callback(hObject, eventdata, handles)
% hObject    handle to FileBrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename pathname filterindex] = uigetfile('*','Please choose measurement data set');
if (filename ~= 0)
    set(handles.Filename,'String',strcat(pathname, filename));
end

function Gaussian_SigmaSq_Callback(hObject, eventdata, handles)
% hObject    handle to Gaussian_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gaussian_SigmaSq as text
%        str2double(get(hObject,'String')) returns contents of Gaussian_SigmaSq as a double


% --- Executes during object creation, after setting all properties.
function Gaussian_SigmaSq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gaussian_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Poisson_lambda_Callback(hObject, eventdata, handles)
% hObject    handle to Poisson_lambda (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Poisson_lambda as text
%        str2double(get(hObject,'String')) returns contents of Poisson_lambda as a double


% --- Executes during object creation, after setting all properties.
function Poisson_lambda_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Poisson_lambda (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Poisson_rl_Callback(hObject, eventdata, handles)
% hObject    handle to Poisson_rl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Poisson_rl as text
%        str2double(get(hObject,'String')) returns contents of Poisson_rl as a double


% --- Executes during object creation, after setting all properties.
function Poisson_rl_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Poisson_rl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Poisson_rh_Callback(hObject, eventdata, handles)
% hObject    handle to Poisson_rh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Poisson_rh as text
%        str2double(get(hObject,'String')) returns contents of Poisson_rh as a double


% --- Executes during object creation, after setting all properties.
function Poisson_rh_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Poisson_rh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in RFIFit_MCA.
function RFIFit_MCA_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_MCA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_MCA


% --- Executes on button press in RFIFit_SAS.
function RFIFit_SAS_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_SAS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_SAS


% --- Executes on button press in RFIFit_Gaussian.
function RFIFit_Gaussian_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_Gaussian (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_Gaussian


% --- Executes on button press in RFIFit_BiVarMCA.
function RFIFit_BiVarMCA_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_BiVarMCA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_BiVarMCA


% --- Executes on button press in RFIFit_BiVarGaussian.
function RFIFit_BiVarGaussian_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_BiVarGaussian (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_BiVarGaussian



function xmax_Callback(hObject, eventdata, handles)
% hObject    handle to xmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xmax as text
%        str2double(get(hObject,'String')) returns contents of xmax as a double


% --- Executes during object creation, after setting all properties.
function xmax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function xmax_a2_Callback(hObject, eventdata, handles)
% hObject    handle to xmax_a2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xmax_a2 as text
%        str2double(get(hObject,'String')) returns contents of xmax_a2 as a double


% --- Executes during object creation, after setting all properties.
function xmax_a2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xmax_a2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function xres_Callback(hObject, eventdata, handles)
% hObject    handle to xres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xres as text
%        str2double(get(hObject,'String')) returns contents of xres as a double


% --- Executes during object creation, after setting all properties.
function xres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in ClearWorkspace.
function ClearWorkspace_Callback(hObject, eventdata, handles)
% hObject    handle to ClearWorkspace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.ResultsBox, 'String','');
set(handles.Status,'String','');
clear; clc;

function NSymbols_Callback(hObject, eventdata, handles)
% hObject    handle to NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NSymbols as text
%        str2double(get(hObject,'String')) returns contents of NSymbols as a double


% --- Executes during object creation, after setting all properties.
function NSymbols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function BiVarGaussian_Sigma1Sq_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_Sigma1Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarGaussian_Sigma1Sq as text
%        str2double(get(hObject,'String')) returns contents of BiVarGaussian_Sigma1Sq as a double


% --- Executes during object creation, after setting all properties.
function BiVarGaussian_Sigma1Sq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_Sigma1Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarGaussian_Sigma2Sq_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_Sigma2Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarGaussian_Sigma2Sq as text
%        str2double(get(hObject,'String')) returns contents of BiVarGaussian_Sigma2Sq as a double


% --- Executes during object creation, after setting all properties.
function BiVarGaussian_Sigma2Sq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarGaussian_Sigma2Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_Sigma1Sq_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Sigma1Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_Sigma1Sq as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_Sigma1Sq as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_Sigma1Sq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Sigma1Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function BiVarMCA_Sigma2Sq_Callback(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Sigma2Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of BiVarMCA_Sigma2Sq as text
%        str2double(get(hObject,'String')) returns contents of BiVarMCA_Sigma2Sq as a double


% --- Executes during object creation, after setting all properties.
function BiVarMCA_Sigma2Sq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BiVarMCA_Sigma2Sq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MCA_SigmaSq_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_SigmaSq as text
%        str2double(get(hObject,'String')) returns contents of MCA_SigmaSq as a double


% --- Executes during object creation, after setting all properties.
function MCA_SigmaSq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on selection change in FileFormat.
function FileFormat_Callback(hObject, eventdata, handles)
% hObject    handle to FileFormat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns FileFormat contents as cell array
%        contents{get(hObject,'Value')} returns selected item from FileFormat


% --- Executes during object creation, after setting all properties.
function FileFormat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FileFormat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in Poisson_Fading.
function Poisson_Fading_Callback(hObject, eventdata, handles)
% hObject    handle to Poisson_Fading (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Poisson_Fading



function Poisson_Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to Poisson_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Poisson_Gamma as text
%        str2double(get(hObject,'String')) returns contents of Poisson_Gamma as a double


% --- Executes during object creation, after setting all properties.
function Poisson_Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Poisson_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes when selected object is changed in RFIGen.
function RFIGen_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in RFIGen
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

RFIGen_index = get(get(handles.RFIGen,'SelectedObject'),'Userdata');
NAntennas    = str2double(get(handles.NAntennas,'String'));
if ((RFIGen_index == 1 && NAntennas == 1) || ( RFIGen_index >= 2 && RFIGen_index <= 5))
    set(handles.RFIFit_MCA,'Enable','on');
    set(handles.RFIFit_SAS,'Enable','on');
    set(handles.RFIFit_Gaussian,'Enable','on');
    set(handles.RFIFit_BiVarMCA,'Enable','off'); set(handles.RFIFit_BiVarMCA,'Value',0);
    set(handles.RFIFit_BiVarGaussian,'Enable','off'); set(handles.RFIFit_BiVarGaussian,'Value',0);
else
    set(handles.RFIFit_MCA,'Enable','off'); set(handles.RFIFit_MCA,'Value',0);
    set(handles.RFIFit_SAS,'Enable','off'); set(handles.RFIFit_SAS,'Value',0);
    set(handles.RFIFit_Gaussian,'Enable','off'); set(handles.RFIFit_Gaussian,'Value',0);
    set(handles.RFIFit_BiVarMCA,'Enable','on');
    set(handles.RFIFit_BiVarGaussian,'Enable','on');
end


function Gaussian_mean_Callback(hObject, eventdata, handles)
% hObject    handle to Gaussian_mean (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gaussian_mean as text
%        str2double(get(hObject,'String')) returns contents of Gaussian_mean as a double


% --- Executes during object creation, after setting all properties.
function Gaussian_mean_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gaussian_mean (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in HelpButton.
function HelpButton_Callback(hObject, eventdata, handles)
% hObject    handle to HelpButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
fid = fopen('RFI_DemoStatisticalModeling.txt','r');
MsgStrCell = textscan(fid, '%s','delimiter', '\n');
fclose (fid);

h = figure;
set(h,'Menubar','none'); 
set(h,'NumberTitle','off'); 
set(h, 'Name','Demo Help');
set(h, 'ResizeFcn', @HelpFigResize);
PosFigure = get(h,'Position');
uicontrol('Parent', h, 'Style', 'edit','Max',2,'String',MsgStrCell{:},'Position',[1 1 PosFigure(3) PosFigure(4)],'HorizontalAlignment','Left');

function HelpFigResize(src,evt)
h = gcbo;
PosFigure = get(h, 'Position');
hChild = get(h,'Children');
set(hChild, 'Position',[1 1 PosFigure(3) PosFigure(4)]);


% --- Executes on button press in StartSimulation.
function StartSimulation_Callback(hObject, eventdata, handles)
% hObject    handle to StartSimulation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Starting Simulation...')); drawnow;

% Retrieve Simulation Parameters
% -------------------------------------------------------------------------

% RFI Generator
RFIGen_index = get(get(handles.RFIGen,'SelectedObject'),'Userdata');
NAntennas    = str2double(get(handles.NAntennas,'String'));

% RFI Fitting
RFIFit_MCA      = get(handles.RFIFit_MCA,'Value');
RFIFit_SAS      = get(handles.RFIFit_SAS,'Value');
RFIFit_Gaussian = get(handles.RFIFit_Gaussian,'Value');
RFIFit_BiVarMCA = get(handles.RFIFit_BiVarMCA,'Value');
RFIFit_BiVarGaussian = get(handles.RFIFit_BiVarGaussian,'Value');

% No of symbols used to fit the data
NSymbols   = str2double(get(handles.NSymbols, 'String'));
% X_max and X_res
xmax       = str2double(get(handles.xmax, 'String'));
xmax_a2    = str2double(get(handles.xmax_a2, 'String'));
xres       = str2double(get(handles.xres, 'String'));


% HardCoded Parameters (Try to remove or make user controlled)
% -------------------------------------------------------------------------
NTerms_MCA      = 100;
NPoissonPoints  = 1000;
SAS_K           = 8;
VALUESMALL      = 10^-8;
NTrainSymbols   = 10000;
xres2D          = 1024;
NPointsTailProb = 100;
% RFI Generation
% -------------------------------------------------------------------------

switch RFIGen_index
    case (1)
        % Measurement Data Set

        filename    = get(handles.Filename,'String');
        NAntennas   = str2double(get(handles.NAntennas,'String'));
        F_Format    = get(handles.FileFormat,'Value');

        % Open File and Read Data
        fid = fopen(filename,'r');
        % Read Data
        switch F_Format
            case (1)
                % Real Only
                format_str = repmat('%f',1, NAntennas);
                noise_data = cell2mat(textscan(fid,format_str, NSymbols));
            case (2)
                % Real + j * Imaginary; Only NAntennas == 1 allowed
                format_str = repmat('%f',1, NAntennas * 2);
                noise_data = cell2mat(textscan(fid,format_str, NSymbols));
            case (3)
                % Envelope Data; Only NAntennas == 1 allowed
                format_str = repmat('%f',1, NAntennas);
                noise_data = cell2mat(textscan(fid,format_str, NSymbols));
        end
        fclose (fid);

    case (2)
        % Poisson Interference Field
        NAntennas       = 1;

        Poisson_lambda  = str2double(get(handles.Poisson_lambda,'String'));
        Poisson_Gamma   = str2double(get(handles.Poisson_Gamma,'String'));
        Poisson_rl      = str2double(get(handles.Poisson_rl,'String'));
        Poisson_rh      = str2double(get(handles.Poisson_rh,'String'));
        Poisson_Fading  = get(handles.Poisson_Fading,'Value');

        noise_data = zeros(NSymbols,1);
        for i = 1:length(noise_data)
            temp = random('exp',1/(Poisson_lambda*pi),NPoissonPoints,1);
            g = cumsum(temp);

            % Limit in [rl, rh]
            inds = find (g.^(1/2) > Poisson_rl);
            g = g(inds);

            inds = find (g.^(1/2) <= Poisson_rh);
            g = g(inds);

            if (Poisson_Fading == 0)
                h = 1;
            else
                h = random('rayl', 1/sqrt(2), length(g),1);
            end

            x = h.*(cos(2*pi*(rand(length(g),1) - 0.5))) ;
            noise_data(i) = sum((g.^(-Poisson_Gamma/4)).*x );
        end


    case (3)
        % Middleton Class A
        NAntennas   = 1;

        MCA_A       = str2double(get(handles.MCA_A,'String'));
        MCA_Gamma   = str2double(get(handles.MCA_Gamma,'String'));
        MCA_SigmaSq = str2double(get(handles.MCA_SigmaSq,'String'));

        noise_data = sqrt(MCA_SigmaSq) .* RFI_MakeDataClassA (MCA_A, MCA_Gamma, NTerms_MCA, NSymbols);
        noise_data = noise_data(:);

    case (4)
        % Symmetric Alpha Stable
        NAntennas       = 1;

        SAS_CharExp     = str2double(get(handles.SAS_CharExp,'String'));
        SAS_Localization= str2double(get(handles.SAS_Localization,'String'));
        SAS_Dispersion  = str2double(get(handles.SAS_Dispersion,'String'));

        noise_data = RFI_MakeDataAlphaStable(SAS_CharExp, SAS_Dispersion, SAS_Localization, NSymbols);
        noise_data = noise_data(:);
    case (5)
        % Gaussian
        NAntennas        = 1;
        Gaussian_mean    = str2double(get(handles.Gaussian_mean,'String'));
        Gaussian_SigmaSq = str2double(get(handles.Gaussian_SigmaSq,'String'));

        noise_data = Gaussian_mean + sqrt(Gaussian_SigmaSq).* randn(NSymbols,1);

    case (6)
        % BiVariate Middleton Class A
        NAntennas       = 2;

        BiVarMCA_A      = str2double(get(handles.BiVarMCA_A,'String'));
        BiVarMCA_Gamma1 = str2double(get(handles.BiVarMCA_Gamma1,'String'));
        BiVarMCA_Gamma2 = str2double(get(handles.BiVarMCA_Gamma2,'String'));
        BiVarMCA_kappa  = str2double(get(handles.BiVarMCA_kappa,'String'));
        BiVarMCA_Sigma1Sq   = str2double(get(handles.BiVarMCA_Sigma1Sq,'String'));
        BiVarMCA_Sigma2Sq   = str2double(get(handles.BiVarMCA_Sigma2Sq,'String'));

        noise_data  = RFI_MakeDataBiVarClassA(BiVarMCA_A, BiVarMCA_Gamma1, BiVarMCA_Gamma2, BiVarMCA_kappa, NSymbols);
        noise_data  = noise_data * [sqrt(BiVarMCA_Sigma1Sq) 0; 0 sqrt(BiVarMCA_Sigma2Sq)];          % NSymbols x 2

    case (7)
        % Bivariate Gaussian
        NAntennas       = 2;

        BiVarGaussian_kappa   = str2double(get(handles.BiVarGaussian_kappa,'String'));
        BiVarGaussian_Sigma1Sq = str2double(get(handles.BiVarGaussian_Sigma1Sq,'String'));
        BiVarGaussian_Sigma2Sq = str2double(get(handles.BiVarGaussian_Sigma2Sq,'String'));

        theta       = 0.5*asin(BiVarGaussian_kappa);
        CorrMat     = [sqrt(BiVarGaussian_Sigma1Sq) 0; 0 sqrt(BiVarGaussian_Sigma2Sq)] * [cos(theta) sin(theta); sin(theta) cos(theta)];
        noise_data  = CorrMat * randn(2,NSymbols);                                                  % 2 x NSymbols
        noise_data  = noise_data.';                                                                 % NSymbols x 2
end

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Data Read or Generated...')); drawnow;

% Just checking (Errors should not be flagged as illegal selections are not
% allowed
if (NAntennas == 1 && ((RFIFit_BiVarMCA == 1) || (RFIFit_BiVarGaussian == 1)))
    errordlg('This choice of RFI Model not supported for 1-antenna data', 'Error Dialog');
end
if (NAntennas == 2 && ((RFIFit_MCA == 1) || (RFIFit_SAS == 1) || (RFIFit_Gaussian == 1)))
    errordlg('This choice of RFI Model not supported for 2-antenna data', 'Error Dialog');
end

% Center the data
noise_data = noise_data - repmat(mean(noise_data),NSymbols,1);

% Generating Envelope and Real signals
% -------------------------------------------------------------------------
if (NAntennas == 1)
    if (RFIGen_index == 1)
        % Measured data
        F_Format    = get(handles.FileFormat,'Value');
        switch F_Format
            case (1)
                % Real ( I or Q)
                noise_data_env  = abs(hilbert(noise_data));
                noise_data_real = noise_data;
            case (2)
                % I + j Q
                noise_data_env  = sqrt(sum(noise_data.^2,2));
                noise_data_real = noise_data(:,1);                               % Considering only In-phase data to do parameter estimation etc. Assumption is that I and Q have the same statistics
            case (3)
                % Envelope Data
                noise_data_env  = noise_data;
                noise_data_real = noise_data.*(cos(2*pi*(rand(size(noise_data)) - 0.5)));
        end
    else
        % Synthetic data
        noise_data_env  = abs(hilbert(noise_data));
        noise_data_real = noise_data;
    end

else
    % NAntennas == 2
    noise_data_real = noise_data;                                               % (NSymbols x 2) or (2 x NSymbols)
end


% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Estimating Parameters...')); drawnow;

% RFI Statistical Fitting
% -------------------------------------------------------------------------


% Middleton Class A Model
if (RFIFit_MCA == 1)
    % Uses envelope data to estimate parameters
    MCA_SigmaSq_Est         = mean(noise_data_real.^2);

    [MCA_A_Est MCA_K_Est]   = RFI_EstMethodofMoments(noise_data_env);
    MCA_Gamma_Est           = MCA_K_Est / MCA_A_Est;

    % Result Update
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ','Estimated Parameters for Middleton Class A Model', '------------------------------------------------'));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('A  = ', num2str(MCA_A_Est)), strcat('Gamma  = ', num2str(MCA_Gamma_Est)), strcat('Sigma_Sq  = ', num2str(MCA_SigmaSq_Est))));
    drawnow;
end

% Symmetric Alpha Stable Model
if (RFIFit_SAS == 1)
    % Uses real data for estimating parameters

    % noise_data_real might be modified during estimating parameters. Hence, we
    % save a copy and restore it later
    noise_data_real_saved = noise_data_real;

    % Localization parameter
    SAS_Localization_Est = RFI_EstAlphaS_Localization(noise_data_real);

    % Characteristic Exponential estimate
    L       = NSymbols/SAS_K;                                                               % # of sub-signals of size K each
    inds    = find(noise_data_real - SAS_Localization_Est == 0);
    noise_data_real(inds)   = (-1)^(round(rand))*VALUESMALL + SAS_Localization_Est;
    SAS_CharExp_Est         = RFI_EstAlphaS_Alpha(noise_data_real, L, SAS_Localization_Est);
    if (SAS_CharExp_Est > 2)
        SAS_CharExp_Est = 2;
    end

    % Dispersion
    SAS_Dispersion_Est      = RFI_EstAlphaS_Dispersion(noise_data_real, SAS_CharExp_Est, SAS_Localization_Est);

    % Restore noise_data_real
    noise_data_real = noise_data_real_saved;
    clear noise_data_real_saved;

    % Result Update
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ','Estimated Parameters for Symmetric Alpha Stable Model', '------------------------------------------------'));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('Location  = ', num2str(SAS_Localization_Est)), strcat('CharExp  = ', num2str(SAS_CharExp_Est)), strcat('Dispersion  = ', num2str(SAS_Dispersion_Est))));
    drawnow;

    % Remove mean/median and make it centered (for PDF estimation)
    % noise_data_real = noise_data_real - SAS_Localization_Est;
end

% Gaussian Model
if (RFIFit_Gaussian == 1)
    % Uses real data for estimating parameters

    Gaussian_Mean_Est       = mean(noise_data_real);
    Gaussian_SigmaSq_Est    = moment(noise_data_real,2);

    % Result Update
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ', 'Estimated Parameters for Gaussian Model', '------------------------------------------------'));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('Mean  = ', num2str(Gaussian_Mean_Est)), strcat('Variance  = ', num2str(Gaussian_SigmaSq_Est))));
    drawnow;

    % Remove mean and make it centered (for PDF estimation etc)
    noise_data_real = noise_data_real - Gaussian_Mean_Est;
end


% BiVariate Middleton Class A Model
if (RFIFit_BiVarMCA == 1)
    % Uses real data (Nsymbols x 2)

    BiVarMCA_Sigma1Sq_Est = moment(noise_data(:,1),2);
    BiVarMCA_Sigma2Sq_Est = moment(noise_data(:,2),2);
    noise_data_real_norm  = noise_data_real./repmat([sqrt(BiVarMCA_Sigma1Sq_Est) sqrt(BiVarMCA_Sigma2Sq_Est)], NSymbols, 1);
    [BiVarMCA_A_Est BiVarMCA_Gamma1_Est BiVarMCA_Gamma2_Est BiVarMCA_kappa_Est] = RFI_MOMBiVarClassAEst(noise_data_real_norm);

    % Result Update
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ', 'Estimated Parameters for BiVariate Middleton Class A Model', '------------------------------------------------'));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('A  = ', num2str(BiVarMCA_A_Est)), strcat('Gamma1  = ', num2str(BiVarMCA_Gamma1_Est)), strcat('Gamma2  = ', num2str(BiVarMCA_Gamma2_Est))));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('kappa  = ', num2str(BiVarMCA_kappa_Est)), strcat('Sigma1_Sq  = ', num2str(BiVarMCA_Sigma1Sq_Est)), strcat('Sigma2_Sq  = ', num2str(BiVarMCA_Sigma2Sq_Est))));
    drawnow;

    clear noise_data_real_norm;
end


% BiVariate Gaussian Model
if (RFIFit_BiVarGaussian == 1)
    % Uses real data (Nsymbols x 2)

    BiVarGaussian_Sigma1Sq_Est  = moment(noise_data_real(:,1),2);
    BiVarGaussian_Sigma2Sq_Est  = moment(noise_data_real(:,2),2);
    BiVarGaussian_kappa_Est     = mean(noise_data_real(:,1).*noise_data_real(:,2))/sqrt(BiVarGaussian_Sigma1Sq_Est * BiVarGaussian_Sigma2Sq_Est);

    % Result Update
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ', 'Estimated Parameters for BiVariate Gaussian Model', '------------------------------------------------'));
    CurrResults = get(handles.ResultsBox, 'String');
    set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('kappa  = ', num2str(BiVarGaussian_kappa_Est)), strcat('Sigma1_Sq  = ', num2str(BiVarGaussian_Sigma1Sq_Est)), strcat('Sigma2_Sq  = ', num2str(BiVarGaussian_Sigma2Sq_Est))));
    drawnow;

end


% Flag Error if Estimated parameters are invalid (e.g. negative Gamma)
% -------------------------------------------------------------------------
ErrFlag = 0;
if (RFIFit_MCA)
    if (MCA_Gamma_Est < 0)
        ErrFlag = 1;
    end
end
if (RFIFit_BiVarMCA)
    if (BiVarMCA_Gamma1_Est < 0 || BiVarMCA_Gamma2_Est < 0)
        ErrFlag = 1;
    end
end

if (ErrFlag == 1)
    errordlg('One (or more) of the estimated parameters are incorrect and cause problems in statistical fitting. Please rerun the simulation.', 'Error Dialog');
    return;
end


% Evaluating accuracy of Fit
% -------------------------------------------------------------------------

% Probability Density Functions
% - Real data, In-phase only for complex data

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Estimating Densities and Evaluating Accuracy of Fit...')); drawnow;

XRange = linspace(-xmax, xmax, xres);
% Result Update
CurrResults = get(handles.ResultsBox, 'String');
set(handles.ResultsBox, 'String', strvcat(CurrResults, ' ', 'KL Divergence', '------------------------------------------------'));


if (NAntennas == 1)

    inds   = [1];
    s      = cell(1,4);
    h      = zeros(1,4);

    figure;
    % Empirical
    PDF_Empirical   = ksdensity(noise_data_real, XRange);
    h(1)            = plot(XRange, PDF_Empirical);
    hold on;

    % Middleton Class A
    if (RFIFit_MCA)
        PDF_MCA     = RFI_MakePDFClassA (XRange./sqrt(MCA_SigmaSq_Est), MCA_A_Est, MCA_Gamma_Est, NTerms_MCA)./sqrt(MCA_SigmaSq_Est);
        h(2)        = plot(XRange, PDF_MCA,'m'); hold on;
        inds        = [inds 2];

        KLD_MCA     = RFI_CalcKLDiver(PDF_Empirical, PDF_MCA, XRange.');
        % Result Update
        CurrResults = get(handles.ResultsBox, 'String');
        set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('Middleton Class A Model        :    ', num2str(KLD_MCA))));
        drawnow;
    end

    % Symmetric Alpha Stable
    if (RFIFit_SAS)
        noise_train     = RFI_MakeDataAlphaStable(SAS_CharExp_Est, SAS_Dispersion_Est, SAS_Localization_Est, NTrainSymbols);
        PDF_SAS         = ksdensity(noise_train, XRange);
        h(3)            = plot(XRange, PDF_SAS,'r');
        inds            = [inds 3];

        KLD_SAS         = RFI_CalcKLDiver(PDF_Empirical, PDF_SAS, XRange.');
        % Result Update
        CurrResults = get(handles.ResultsBox, 'String');
        set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('Symmetric Alpha Stable Model    :    ', num2str(KLD_SAS))));
        drawnow;

    end

    % Gaussian
    if (RFIFit_Gaussian)
        PDF_Gaussian    = normpdf(XRange, Gaussian_Mean_Est, sqrt(Gaussian_SigmaSq_Est));
        h(4)            = plot(XRange, PDF_Gaussian,'g');
        inds            = [inds 4];

        KLD_Gaussian    = RFI_CalcKLDiver(PDF_Empirical, PDF_Gaussian, XRange.');
        % Result Update
        CurrResults = get(handles.ResultsBox, 'String');
        set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('Gaussian Model                  :    ', num2str(KLD_Gaussian))));
        drawnow;
    end

    s{1} = 'Empirical';
    s{2} = 'Middleton Class A';
    s{3} = 'Symmetric Alpha Stable';
    s{4} = 'Gaussian';

    legend(h(inds),s(inds));
    xlabel('Centered amplitude'); ylabel('Probability density function'); title('Probability Density Function');

    clear PDF_Empirical PDF_MCA PDF_SAS PDF_Gaussian;
end

if (NAntennas == 2)

    XRange_A2 = linspace(-xmax_a2, xmax_a2, xres);

    inds   = [1];
    s      = cell(1,3);
    h_1    = zeros(1,3);
    h_2    = zeros(1,3);

    s{1} = 'Empirical';
    s{2} = 'BiVariate Middleton Class A';
    s{3} = 'BiVariate Gaussian';

    figure;
    % Empirical
    PDF_Empirical_Antenna1  = ksdensity(noise_data_real(:,1), XRange);
    PDF_Empirical_Antenna2  = ksdensity(noise_data_real(:,2), XRange_A2);
    h_1(1)                  = plot(XRange, PDF_Empirical_Antenna1);
    hold on;

    [bandwidth, PDF_Empirical_2D, X, Y]   = RFI_kde2d(noise_data_real, xres2D,  [-xmax -xmax_a2], [xmax xmax_a2]);
    XVec  = X(1,:).';
    YVec  = Y(:,1)  ;
    XYMesh      = [X(:) Y(:)];

    %figure; surf(X,Y, PDF_Empirical_2D);

    % BiVariate Middleton Class A
    if (RFIFit_BiVarMCA)
        PDF_BiVarMCA_Antenna1    = RFI_MakePDFClassA (XRange./sqrt(BiVarMCA_Sigma1Sq_Est), BiVarMCA_A_Est, BiVarMCA_Gamma1_Est, NTerms_MCA)./sqrt(BiVarMCA_Sigma1Sq_Est);
        PDF_BiVarMCA_Antenna2    = RFI_MakePDFClassA (XRange_A2./sqrt(BiVarMCA_Sigma2Sq_Est), BiVarMCA_A_Est, BiVarMCA_Gamma2_Est, NTerms_MCA)./sqrt(BiVarMCA_Sigma2Sq_Est);
        h_1(2)                   = plot(XRange, PDF_BiVarMCA_Antenna1,'m');
        inds                     = [inds 2];

        PDF_BiVarMCA_2D         = RFI_MakePDFBiVarClassA(BiVarMCA_A_Est, BiVarMCA_Gamma1_Est,  BiVarMCA_Gamma2_Est, BiVarMCA_kappa_Est, XYMesh./repmat([sqrt(BiVarMCA_Sigma1Sq_Est) sqrt(BiVarMCA_Sigma2Sq_Est)], xres2D^2, 1)) ./ sqrt(BiVarMCA_Sigma1Sq_Est*BiVarMCA_Sigma2Sq_Est);
        PDF_BiVarMCA_2D         = reshape(PDF_BiVarMCA_2D, xres2D, xres2D);
        KLD_BiVarMCA            = abs(RFI_CalcKLDiver(PDF_Empirical_2D, PDF_BiVarMCA_2D, [YVec XVec]));

        % Result Update
        CurrResults = get(handles.ResultsBox, 'String');
        set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('BiVariate Middleton Class A Model  :    ', num2str(KLD_BiVarMCA))));
        drawnow;
    end

    % BiVariate Gaussian
    if (RFIFit_BiVarGaussian)
        PDF_BiVarGaussian_Antenna1  = normpdf(XRange, 0, sqrt(BiVarGaussian_Sigma1Sq_Est));
        PDF_BiVarGaussian_Antenna2  = normpdf(XRange_A2, 0, sqrt(BiVarGaussian_Sigma2Sq_Est));
        h_1(3)                      = plot(XRange, PDF_BiVarGaussian_Antenna1,'g');
        inds                        = [inds 3];

        CovMat      = zeros(2,2);
        CovMat(1,:) = [BiVarGaussian_Sigma1Sq_Est ,  BiVarGaussian_kappa_Est*sqrt(BiVarGaussian_Sigma2Sq_Est * BiVarGaussian_Sigma1Sq_Est)];
        CovMat(2,:) = [BiVarGaussian_kappa_Est*sqrt(BiVarGaussian_Sigma2Sq_Est * BiVarGaussian_Sigma1Sq_Est) , BiVarGaussian_Sigma2Sq_Est ];

        PDF_BiVarGaussian_2D   = reshape(mvnpdf(XYMesh, [0 0], CovMat), xres2D, xres2D);
        KLD_BiVarGaussian      = abs(RFI_CalcKLDiver(PDF_Empirical_2D, PDF_BiVarGaussian_2D, [YVec XVec]));

        % Result Update
        CurrResults = get(handles.ResultsBox, 'String');
        set(handles.ResultsBox, 'String', strvcat(CurrResults, strcat('BiVariate Gaussian Model          :    ', num2str(KLD_BiVarGaussian))));
        drawnow;
    end

    xlabel('Centered amplitude'); ylabel('Probability density function'); title('Marginal PDF at Antenna 1');
    legend(h_1(inds),s(inds));

    % Plotting density function at Antenna #2
    figure;
    h_2(1)  = plot(XRange_A2, PDF_Empirical_Antenna2);
    hold on;

    % BiVariate Middleton Class A
    if (RFIFit_BiVarMCA)
        h_2(2)  = plot(XRange_A2, PDF_BiVarMCA_Antenna2,'m');
    end

    % BiVariate Gaussian
    if (RFIFit_BiVarGaussian)
        h_2(3)  = plot(XRange_A2, PDF_BiVarGaussian_Antenna2,'g');
    end

    legend(h_2(inds),s(inds));
    xlabel('Centered amplitude'); ylabel('Probability density function'); title('Marginal PDF at Antenna 2');

    %     figure; surf(PDF_Empirical_2D);
    %     figure; surf(PDF_BiVarMCA_2D);
    %     figure; surf(PDF_BiVarGaussian_2D);

    clear PDF_Empirical_Antenna1 PDF_Empirical_Antenna2 PDF_BiVarMCA_Antenna1 PDF_BiVarMCA_Antenna2 PDF_BiVarGaussian_Antenna1 PDF_BiVarGaussian_Antenna2;

end

% Tail Probabilities
% -------------------------------------------------------------------------

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'Calculating Tail Probabilities...')); drawnow;

if (NAntennas == 1)
    inds   = [1];
    s      = cell(1,4);
    h      = zeros(1,4);

    XRange = linspace(max(0,xmax-3), xmax, NPointsTailProb);

    % Empirical
    Empirical_CCDF = zeros(1,length(XRange));
    for i = 1:length(XRange)
        Empirical_CCDF(i) = length(find(noise_data_real > XRange(i)))/length(noise_data_real);
    end
    figure;
    h(1) = semilogy(XRange, Empirical_CCDF);
    hold on;

    % Middleton Class A
    if (RFIFit_MCA)
        MCA_CCDF = zeros(size(XRange));
        for m = 0:NTerms_MCA;
            v = MCA_SigmaSq_Est * (m / MCA_A_Est + MCA_Gamma_Est) / (1 + MCA_Gamma_Est);
            MCA_CCDF = MCA_CCDF + exp (-MCA_A_Est) * MCA_A_Est.^m / factorial(m) * 1/2 * erfc(XRange*1/sqrt(2*v));
        end

        h(2) = semilogy(XRange, MCA_CCDF,'m');
        inds = [inds 2];
    end

    % Symmetric Alpha Stable
    if (RFIFit_SAS)
        if (SAS_CharExp_Est == 2)
            SAS_CCDF = 1/2*erfc(XRange.*1/(sqrt(2*SAS_Dispersion_Est)*sqrt(2)));
        else
            if (SAS_CharExp_Est == 1)
                C_alpha = 2/pi;
            else
                C_alpha = (1-SAS_CharExp_Est)/(Gamma(2-SAS_CharExp_Est)*cos(pi*SAS_CharExp_Est/2));

            end
            SAS_CCDF = XRange.^(-SAS_CharExp_Est) * SAS_Dispersion_Est^SAS_CharExp_Est * C_alpha / 2 ;
        end

        h(3) = semilogy(XRange, SAS_CCDF, 'r');
        inds = [inds 3];
    end

    % Gaussian
    if (RFIFit_Gaussian)
        Gaussian_CCDF = 1/2*erfc(XRange.*1/(sqrt(Gaussian_SigmaSq_Est)*sqrt(2)));

        h(4) = semilogy(XRange, Gaussian_CCDF,'g');
        inds = [inds 4];
    end

    s{1} = 'Empirical';
    s{2} = 'Middleton Class A';
    s{3} = 'Symmetric Alpha Stable';
    s{4} = 'Gaussian';

    legend(h(inds),s(inds));
    xlabel('Threshold Amplitude (a)'); ylabel('Tail Probabilities [P(X > a)]'); title('Tail Probability')

end


if (NAntennas == 2)
    XRange_A1 = linspace(max(0,xmax-3)   , xmax   , NPointsTailProb);
    XRange_A2 = linspace(max(0,xmax_a2-3), xmax_a2, NPointsTailProb);

    inds   = [1];
    s      = cell(1,3);
    h_1    = zeros(1,3);
    h_2    = zeros(1,3);

    s{1} = 'Empirical';
    s{2} = 'BiVariate Middleton Class A';
    s{3} = 'BiVariate Gaussian';

    % Empirical
    Empirical_CCDF_A1 = zeros(1,length(XRange_A1));
    Empirical_CCDF_A2 = zeros(1,length(XRange_A2));
    for i = 1:NPointsTailProb
        Empirical_CCDF_A1(i) = length(find(noise_data_real(:,1) > XRange_A1(i)))/length(noise_data_real(:,1));
        Empirical_CCDF_A2(i) = length(find(noise_data_real(:,2) > XRange_A2(i)))/length(noise_data_real(:,2));
    end
    figure;
    h_1(1) = semilogy(XRange_A1, Empirical_CCDF_A1);
    hold on;

    % BiVariate Middleton Class A
    if (RFIFit_BiVarMCA)

        BiVarMCA_CCDF_A1 = zeros(size(XRange_A1));
        BiVarMCA_CCDF_A2 = zeros(size(XRange_A2));

        for m = 0:NTerms_MCA;
            v_a1 = BiVarMCA_Sigma1Sq_Est * (m / BiVarMCA_A_Est + BiVarMCA_Gamma1_Est) / (1 + BiVarMCA_Gamma1_Est);
            v_a2 = BiVarMCA_Sigma2Sq_Est * (m / BiVarMCA_A_Est + BiVarMCA_Gamma2_Est) / (1 + BiVarMCA_Gamma2_Est);

            BiVarMCA_CCDF_A1 = BiVarMCA_CCDF_A1 + exp (-BiVarMCA_A_Est) * BiVarMCA_A_Est.^m / factorial(m) * 1/2 * erfc(XRange_A1*1/sqrt(2*v_a1));
            BiVarMCA_CCDF_A2 = BiVarMCA_CCDF_A2 + exp (-BiVarMCA_A_Est) * BiVarMCA_A_Est.^m / factorial(m) * 1/2 * erfc(XRange_A2*1/sqrt(2*v_a2));
        end

        h_1(2) = semilogy(XRange_A1, BiVarMCA_CCDF_A1,'m');
        inds = [inds 2];
    end

    % BiVariate Gaussian
    if (RFIFit_BiVarGaussian)
        BiVarGaussian_CCDF_A1 = 1/2*erfc(XRange_A1.*1/(sqrt(BiVarGaussian_Sigma1Sq_Est)*sqrt(2)));
        BiVarGaussian_CCDF_A2 = 1/2*erfc(XRange_A2.*1/(sqrt(BiVarGaussian_Sigma2Sq_Est)*sqrt(2)));

        h_1(3) = semilogy(XRange_A1, BiVarGaussian_CCDF_A1,'g');
        inds = [inds 3];
    end

    legend(h_1(inds),s(inds));
    xlabel('Threshold Amplitude (a)'); ylabel('Tail Probabilities [P(X > a)]'); title('Tail Probability at Antenna #1')


    % Plotting tail probabilities at Antenna #2
    figure;
    h_2(1)  = semilogy(XRange_A2, Empirical_CCDF_A2);
    hold on;

    % BiVariate Middleton Class A
    if (RFIFit_BiVarMCA)
        h_2(2)  = semilogy(XRange_A2, BiVarMCA_CCDF_A2,'m');
    end

    % BiVariate Gaussian
    if (RFIFit_BiVarGaussian)
        h_2(3)  = semilogy(XRange_A2, BiVarGaussian_CCDF_A2,'g');
    end

    legend(h_2(inds),s(inds));
    xlabel('Threshold Amplitude (a)'); ylabel('Tail Probabilities [P(X > a)]'); title('Tail Probability at Antenna #2')

end

% Status Update
CurrStatus = get(handles.Status, 'String');
set(handles.Status, 'String', strvcat(CurrStatus, 'End of Simulation.')); drawnow;
