function [dem_bits err_rate_corr] = RFI_Matched_Filter( corrupted_signal, trans_bits, N, Prop_delay, SampRatio, PulseShape, M )
%[dem_bits err_rate_corr] = RFI_Matched_Filter( corrupted_signal, trans_bits, N, Prop_delay, SampRatio, PulseShape, M );
%This function demodulates the signal using a Matched Filter for any M-PAM
%signal.
% Inputs:   corrupted_signal    - the transmitted signal corrupted by noise
%           transmitted_bits    - the vector of transmitted bits
%           N                   - number of samples per symbol
%           Prop_delay          - delay of the raised cosine filter
%           SampRatio           - the sampling ratio for the sqrt raised cosine filter
%           PulseShape          - impulse response of the pulse shape filter 
%           M                   - number of constellation points for M-PAM
%
% Outputs:  dem_bits            - vector of demodulated bits
%           err_rate_corr       - the bit error rate using correlation receiver
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Ben Okafor  (benemeka@mail.utexas.edu)
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 12/12/09  1.4 Beta    okafor    Initial Implementation

no_symb = length(corrupted_signal)/N;
x_filtered = rcosflt(corrupted_signal,1,SampRatio,'sqrt/Fs/filter',PulseShape);
x_filtered = x_filtered./sum(PulseShape.^2);

x_recovered = x_filtered(2*Prop_delay + 1: 2*Prop_delay: end);
dem_symbols = pamdemod(x_recovered,M);                                        %adjusted to recover M-PAM symbols
dem_bits = pammod(dem_symbols,M);

err_rate_corr = sum(dem_bits'~=trans_bits)/no_symb;