function decodedSymbols = RFI_TwoAntennaMLRx(Y,H,codebook,M,En1,En2,kappa)
% decodedSymbols = RFI_TwoAntennaMLRx(Y, H, codebook, M, En1, En2, kappa)
% This function implements the Gaussian maximum likelihood (ML) decoder
% (minimum distance decoder) for a 2x2 MIMO system
% Inputs:   Y - matrix of the received signal
%           H - 2x2 channel matrix
%           codebook - codebook that contains all the possible 2x1
%                      codewords that could have been transmitted. This
%                      defines the ML search space.
%           M - Modulation order for the QAM constellation used in
%               transmission (M-QAM)
%           Es - Transmit symbol energy
%           En1 - Noise energy at the receiver at antenna 1
%           En2 - Noise energy at the receiver at antenna 2
%           kappa  - Correlation coefficient between the noise samples at
%                    the receiver
% Outputs:  decodedSymbols - Matrix of the ML decoded symbols
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Aditya Chopra  (chopra@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 11/11/08  1.2 Beta    gulati    Initial Implementation

% Determine the covariance matrix of Gaussian noise
Kmat = [En1 kappa*sqrt(En1*En2); kappa*sqrt(En1*En2) En2];

% Real Component
N = real(repmat(Y, 1, M^2) - H * codebook);
P_real = N.'*inv(Kmat)*N;

% Imaginary Component
N = imag(repmat(Y, 1, M^2) - H * codebook);
P_imag = N.'*inv(Kmat)*N;

% Choose the symbol that minimizes the minimum distance metric
[val ind] = min(diag(P_real + P_imag));
decodedSymbols = qamdemod(codebook(:,ind),M);

return;

