function phix_approx = RFI_ApproxFuncPhiSubOpt(x, r, a)
% phix_approx = RFI_ApproxFuncPhiSubOpt(x, r, a)
% This function return the approximate value of the function phi(x) =
% ln(1+e^x) using the four piece linear approximation
%            |  0               if x < -r
% phi(x)  =  |  ax + ar         if -r <= x < 0
%            | (1-a)x + ar      if 0 <= x < r 
%            |  x               if x >= r
% Inputs:   x - argument vector of the function phi(x) to be evaluated
%           r - parameter of the linear approximation for the function
%           phi(x)
%           a - parameter of the linear approximating for the function
%           phi(x)
%           Note: r = 2.507 and a = 0.236 minimize the approximation error
% Outputs:  phi_approx - Approximate value of the function ln(1+e^x)
%           evaluated at x
%
%References:
% [1] K. Gulati, A. Chopra, R. W. Heath, Jr., B. L. Evans, K. R. Tinsley,
% and X. E. Lin, "MIMO Receiver Design in the Presence of Radio Frequency
% Interference", Proc. IEEE Int. Global Communications Conf., Nov. 30-Dec.
% 4th, 2008, New Orleans, LA USA. 
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Aditya Chopra  (chopra@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 11/11/08  1.2 Beta    gulati    Initial Implementation

phix_approx = zeros(size(x));

phix_approx =  a*(x+r).*(x<0).*(x>-r) + (a*r + (1-a)*x).*(x<r).*(x>0) + x.*(x>=r);

return