function [dem_bits err_rate_wiener] = RFI_detect_wiener( corrupted_signal, trans_bits, N, w, delay, sampling_ratio, y, M )
%[dem_bits err_rate_wiener] = RFI_detect_wiener(corrupted_signal, trans_bits, N, w, delay, sampling_ratio, y, M )
%This function demodulates the signal by filtering it with a wiener filter 
%and then demodulating it with a correlator receiver for Class A interference 
%for the binary digital signaling like 2 PAM. It assumes that the constellation is 
%symmetric with respect to zero.
%
% Inputs:   corrupted_signal    - the transmitted signal corrupted by noise
%           transmitted_bits     - the vector of transmitted bits
%           N                   - number of samples per symbol
%           w                   - vector containing the designed Wiener
%                                 filter coefficients
%           delay               - delay of the raised cosine filter
%           sampling_ratio      - the sampling ratio for the raised cosine filter
%           y                   - impulse response of the pulse shape filter
%           M                   - number of constellation points for M-PAM
%
% Outputs:  dem_bits            - vector of demodulated bits
%           err_rate_wiener     - the bit error rate using Wiener filtering
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar  (nassar@ece.utexas.edu)
%              Ben Okafor     (benemeka@mail.utexas.edu)
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 09/22/07  1.0         nassar    Initial Implementation
% 12/12/09  1.4 Beta    okafor    Replaced RFI_detect_cor with RFI_Matched_Filter


r_filt=filter(w,1,corrupted_signal);

% Matched Filter 
[dem_bits err_rate_wiener] = RFI_Matched_Filter( r_filt, trans_bits, N, sampling_ratio*delay, sampling_ratio, y, M);