function delta_est = RFI_EstAlphaS_Localization(noise_data)
% [delta_est] = RFI_EstAlphaS_Localization(noise_data) 
% Estimates the localization parameter of the symmetric alpha stable model using the
% estimator described in [1]
% Inputs:  noise_data - Vector of symmetric alpha stable noise
% 
% Outputs: delta_est - Estimate of the localization parameter of the
%                      symmetric alpha stable model
%
% References:
% [1] G. A. Tsihrintzis and C. L. Nikias, "Fast estimation of the
%     parameters of alpha-stable impulsive interference", IEEE Transactions 
%     on Signal Processing, vol. 44, no 6, pp. 1492-1503, June 1996.
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%              Arvind Sujeeth (arvind.sujeeth@mail.utexas.edu) 


delta_est = median(noise_data);  % Estimator as described in equation (2-2) in [1]

return;