function varargout = RFI_DemoSISO(varargin)
% RFI_DEMOSISO M-file for RFI_DemoSISO.fig
%      RFI_DEMOSISO, by itself, creates a new RFI_DEMOSISO or raises the existing
%      singleton*.
%
%      H = RFI_DEMOSISO returns the handle to a new RFI_DEMOSISO or the handle to
%      the existing singleton*.
%
%      RFI_DEMOSISO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFI_DEMOSISO.M with the given input arguments.
%
%      RFI_DEMOSISO('Property','Value',...) creates a new RFI_DEMOSISO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RFI_DemoSISO_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to RFI_DemoSISO_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help RFI_DemoSISO

% Last Modified by GUIDE v2.5 29-Jun-2010 20:50:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @RFI_DemoSISO_OpeningFcn, ...
    'gui_OutputFcn',  @RFI_DemoSISO_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoSISO is made visible.
function RFI_DemoSISO_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RFI_DemoSISO (see VARARGIN)

%addpath(genpath('../../'))  %add the directory that contains the required functions

% Choose default command line output for RFI_DemoSISO
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoSISO wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% ---------------------------------------------------------------------
% Setup Gaussian Mixture Parameters
% ---------------------------------------------------------------------
global GMixtureParams;
GMixtureParams = struct('numComps', 3, ... %number of components
    'p', [.8 .15 .05], ... %probability vector of each component
    'SIGMAs', [1 10 100]); % the variances of each component

ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(ESPL_logo);
%axis equal;
%axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');

% WNCG_logo=imread('wncg-sm.jpg');
% set(handles.WNCG_logo,'HandleVisibility','ON');
% axes(handles.WNCG_logo);
% image(WNCG_logo);
% axis equal;
% axis tight;
% axis off;
% set(handles.WNCG_logo,'HandleVisibility','OFF');

% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoSISO_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function bits_per_itr_Callback(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bits_per_itr as text
%        str2double(get(hObject,'String')) returns contents of bits_per_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end


% --- Executes during object creation, after setting all properties.
function bits_per_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bits_per_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function no_itr_Callback(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of no_itr as text
%        str2double(get(hObject,'String')) returns contents of no_itr as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if (isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function no_itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to no_itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_low_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_low_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_low_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','-20');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
if (user_entry > high_limit)
    set(hObject, 'String', num2str(high_limit-30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_low_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_low_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNRrange_high_limit_Callback(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRrange_high_limit as text
%        str2double(get(hObject,'String')) returns contents of SNRrange_high_limit as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','10');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
lower_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
if (user_entry < lower_limit)
    set(hObject, 'String', num2str(lower_limit+30));
    errordlg('Inconsistent SNR range.','Bad Input','modal');
end;


% --- Executes during object creation, after setting all properties.
function SNRrange_high_limit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRrange_high_limit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function SNR_step_size_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_step_size as text
%        str2double(get(hObject,'String')) returns contents of SNR_step_size as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function SNR_step_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_step_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function A_Callback(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of A as text
%        str2double(get(hObject,'String')) returns contents of A as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.35');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-2)
    set(hObject,'String','0.35');
    errordlg('A range exceeded. A should belong to [0.01,1].','Bad Input','modal')
end;


% --- Executes during object creation, after setting all properties.
function A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gamma as text
%        str2double(get(hObject,'String')) returns contents of Gamma as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.001');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry > 1 | user_entry < 10^-6)
    set(hObject,'String','0.001');
    errordlg('Gamma range exceeded. Gamma should belong to [10^-6,1].','Bad Input','modal')
end;

% --- Executes during object creation, after setting all properties.
function Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function r_Callback(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r as text
%        str2double(get(hObject,'String')) returns contents of r as a double
user_entry = str2double(get(hObject,'String'));
if isnan(user_entry)
    set(hObject,'String','0.1');
    errordlg('You must enter a numeric value','Bad Input','modal')
end
if (user_entry < 0 | user_entry > 1)
    set(hObject,'String','0.1');
    errordlg('Invalid value for r. r should be between 0 and 1.','Bad Input','modal');
end;



% --- Executes during object creation, after setting all properties.
function r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delay_Callback(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay as text
%        str2double(get(hObject,'String')) returns contents of delay as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','10');
    errordlg('You must enter a postive numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function sampling_ratio_Callback(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sampling_ratio as text
%        str2double(get(hObject,'String')) returns contents of sampling_ratio as a double
user_entry = str2double(get(hObject,'String'));
set(hObject,'String', num2str(round(user_entry)));
if ( isnan(user_entry) | user_entry < 0)
    set(hObject,'String','5');
    errordlg('You must enter a numeric value','Bad Input','modal')
end

% --- Executes during object creation, after setting all properties.
function sampling_ratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sampling_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in corr_rx.
function corr_rx_Callback(hObject, eventdata, handles)
% hObject    handle to corr_rx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of corr_rx


% --- Executes on button press in wiener_dtc.
function wiener_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to wiener_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of wiener_dtc


% --- Executes on button press in bayesian_dtc.
function bayesian_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to bayesian_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bayesian_dtc


% --- Executes on button press in start_sim.
function start_sim_Callback(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% The UserData is being used to indicate if the button is in the Start mode
% (0) or the Stop mode (1)
% if (get(hObject, 'UserData') == 0)
%     set(hObject,'String','Stop Simulation');
%     set(hObject,'UserData',1);
% else
%     % Add ending code sequence here depending on the desired ending
%     % behavior
%     set(hObject,'String','Start Simulation');
%     set(hObject,'UserData',0);
%     return;
% end;

set(handles.status, 'String', 'Simulation Started...');
%Temporary button disbale functionality
set(hObject,'enable','inactive');
set(hObject, 'String', 'Running...');drawnow;
% Obtain necessary data from the GUI handles structure, I chose to get them
% rather than store then in the handles structure using guidata because
% the amount of data is small and this saves a lot of work in updating the
% fields and save some memory space

val = get(handles.Noise_type,'Value');
switch val
    case 1
        is_class_A=1;
        is_alpha=0;
        is_GMixture = 0;
    case 2
        is_class_A=0;
        is_alpha=1;
        is_GMixture = 0;
    case 3
        is_class_A=0;
        is_alpha=0;
        is_GMixture = 1;
end;


% Noise Parameters
% ---------------------------------------------------------------------
% Get Class A parameters
A = str2double(get(handles.A, 'String'));
T = str2double(get(handles.Gamma, 'String'));
% Get Alpha Stable Parameters
alpha = str2double(get(handles.alpha, 'String')); % Characteristic Exponent
disper = str2double(get(handles.disp, 'String'));% Dispersion Parameter
% Get Gaussian Mixture parameters
eval(['p=' get(handles.pValue,'String') ';']);
eval(['sigmas=' get(handles.sigmas, 'String') ';']);
NumComps = length(p);

% Common Simulation Setings
% ----------------------------------------------------------------------
NumTermsPDF = 100; % number of terms used in the pdf expansion of class A
quant_levels = str2double(get(handles.quant_level, 'String'));% number of quantization levels
M=str2double(get(handles.MPAM_M, 'String')); %number of constellation points (currently only 2 is supported)                                                        
delay = str2double(get(handles.delay, 'String')); %delay of the raised cosine filter
sampling_ratio = str2double(get(handles.sampling_ratio, 'String')); %the sampling ratio for the raised cosine filter
r = str2double(get(handles.r, 'String')); % r for the raised cosine filter
N=2*delay*sampling_ratio; %number of sampled points (raised cosine pulse shape, and received signal)


% Class-A quantization parameters
%----------------------------------------------------------------------
% Settings for resolution of pdf generation
MaxVal = 1; XRes = 10000;
x = [linspace(-20, -MaxVal-1, XRes) linspace(-MaxVal, MaxVal, XRes) ...
    linspace(MaxVal+1, 20, XRes)]; % Range within which the data is generated
thePDF = RFI_MakePDFClassA( x, A, T, NumTermsPDF);

[partition, codebook] = lloyds(thePDF,quant_levels); % codebook generation


% Pulse Shape Design
% ----------------------------------------------------------------------
y=rcosine(1,sampling_ratio,'sqrt',r,delay);%Need to be adjusted to fit N (defined above)
%need to choose the right parameters according to the value of N
%the value of N should satisfy N=k*2*delay (see help rcosine)
y=y(1:length(y)-1);

% Wiener Filter Design precalculations (autocorrelation)
% -------------------------------------------------------
y_cor=xcorr(y,'unbiased');
y_cor=y_cor(N:length(y_cor));
Ry=toeplitz(y_cor); % The autocorrelation Matrix of y


SelectedDataSrc = get(handles.DataSourcePanel, 'SelectedObject'); % this is the selected data source

%% Simulation for Random Data
%----------------------------------------------------------------------
if strcmp(get(SelectedDataSrc, 'Tag'), 'RndDataTag')
    
totalno_bits = str2double(get(handles.bits_per_itr, 'String')); %number of bits for simulation per iteration
no_iterations = 10; %str2double(get(handles.no_itr, 'String')); %number of iterations (fixed to 10 now)
no_bits = totalno_bits/no_iterations;  % number of bits per iteration
    
% Determines the options settings
corr_status = get(handles.corr_rx, 'Value');
wiener_status = get(handles.wiener_dtc, 'Value');
bayes_status = get(handles.bayesian_dtc, 'Value');
bayes_aprx_status = get(handles.small_sig_aprx, 'Value');
bayes_quant_status = get(handles.quant, 'Value');
myriad_status_opt = get(handles.myriad_dtc, 'Value');
myriad_status_selec = get(handles.selec_myriad, 'Value');
    
% Get Simulation Settings
SNR_low_limit = str2double(get(handles.SNRrange_low_limit, 'String'));
SNR_high_limit = str2double(get(handles.SNRrange_high_limit, 'String'));
step_size = str2double(get(handles.SNR_step_size, 'String'));

if (corr_status + wiener_status + (bayes_status + bayes_aprx_status)*is_GMixture + ...
        (bayes_status+bayes_quant_status+bayes_aprx_status)*is_class_A + ... 
        (myriad_status_opt+myriad_status_selec)*is_alpha == 0)
    errordlg('Please select at least one detection method.','Irrational Settings','modal')
    set(hObject,'String','Start Simulation');
    set(hObject,'UserData',0); % related the note  above
    set(hObject,'enable','on');
    return;
end;

SNR=SNR_low_limit:step_size:SNR_high_limit; %SNR range
err_rate_corr=zeros(1,length(SNR));
err_rate_opt=zeros(1,length(SNR));
err_rate_opt_quant=zeros(1,length(SNR));
err_rate_aprx=zeros(1,length(SNR));
err_rate_wiener=zeros(1,length(SNR));
err_rate_myriad_opt=zeros(1,length(SNR));
err_rate_myriad_selec=zeros(1,length(SNR));
    
% Status Update Variables
%-----------------------------
StatusString = get(handles.status, 'String');
iterNum = 0;
% ------------------------------------------

for j=1:no_iterations

    % generate no_bits bits and modulate the signal
    [x_pul x_mod ] = RFI_gen_binary_mod(no_bits,M,y);

    % -------------------------------------------------------------------
    % Noise generation and SNR sweep
    if (is_class_A == 1)
        noise = RFI_MakeDataClassA(A,T,NumTermsPDF,length(x_pul));%can be included inside of the loop to provide more
        %randomness at the cost of much more running time
    elseif is_alpha
        noise = RFI_MakeDataAlphaStable(alpha, 1, 0, length(x_pul));
    elseif is_GMixture
        noise = RFI_MakeDataGMM(1, zeros(NumComps,1), sigmas', p', length(x_pul))/realsqrt(p*sigmas.');
    end;
    % -------------------------------------------------------------------
    
    % -------------------------------------------------------------------
    % Parameter Estimation
    if get(handles.EstimateParams, 'Value')
        [A_est K_est ] = RFI_EMTwoParamEst(length(noise), 10, noise, 0.35, 0.35*0.01);
        alpha_est = RFI_EstAlphaS_Alpha(noise, length(noise)/8, 0); %localization assumed zero
        disper_est = RFI_EstAlphaS_Dispersion(noise, alpha_est, 0);
    end;
    % -------------------------------------------------------------------
    
    % Used Parameters
    % -------------------------------------------------------------------
    switch get(handles.EstimateParams, 'Value')
        case 0
            alphaUsed = alpha;
            disperUsed = disper;
            AUsed = A; 
            GammaUsed = T;
        case 1
            alphaUsed = alpha_est;
            disperUsed = disper_est;
            AUsed = A_est;
            GammaUsed = K_est/A_est;
        otherwise
            disp('Should not be here!')
    end

    for i=1:length(SNR)
        per=randperm(length(noise)); % permuting noise samples since they are iid
        noise=noise(per);
        Es = mean(pammod([0:M-1],M).^2) * mean(y.^2); % Es_normFactor * mean(Pulse Shape.^2)                        
        if (is_class_A == 1 || is_GMixture) %class A and GM
            z= noise * sqrt(10^(-SNR(i)/10)*Es); %renormalize the noise for correct SNR                                  
            r=x_pul+z(:); % add noise to the signal
        else % alpha stable
            disper = Es * 10^(-SNR(i)/10);               % Signal Power as per the definition of a generalized SNR.         
            r = x_pul + disper^(1/alpha) * noise(:);             % add noise to the signal                                  
        end;

        if (corr_status == 1)
            [dem_bits err_rate] = RFI_Matched_Filter( r, x_mod, N, sampling_ratio*delay, sampling_ratio, y, M);         
            err_rate_corr(i)= err_rate_corr(i)+err_rate;
        end;

        if (wiener_status == 1)
            w=inv(Ry+10^(-SNR(i)/10)*mean(y.^2)*eye(N))*y_cor'; %wiener filter coefficients (Solving Wiener-Hopf Equations)
            [dem_bits err_rate] = RFI_detect_wiener( r, x_mod, N, w, delay, sampling_ratio, y, M);   
            err_rate_wiener(i)=err_rate_wiener(i)+err_rate;
        end;

        if (bayes_status) % Optimal Bayesian Detection
            if (is_class_A)
                PDFfhandle = @RFI_MakePDFClassA;
                [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, y, SNR(i), PDFfhandle, AUsed, GammaUsed, NumTermsPDF);
            elseif (is_GMixture)
                PDFfhandle = @RFI_MakePDFGMM;
                [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, y, SNR(i), PDFfhandle, zeros(NumComps,1),(10^(-SNR(i)/10)*Es)*sigmas'/(p*sigmas.'), p');
            end;              
            %[dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, AUsed, GammaUsed, y, NumTermsPDF, SNR(i));
            err_rate_opt(i)=err_rate_opt(i)+err_rate;
        end;

        if (bayes_aprx_status) % Approximate Bayesian Detection
            if (is_class_A)
                fhandle = @RFI_nonlinearity;
                [dem_bits err_rate] = RFI_detect_appx( r, y, x_mod, N, SNR(i), fhandle, AUsed, GammaUsed, NumTermsPDF);
            elseif (is_GMixture)
                fhandle = @RFI_GMnonlinearity;
                [dem_bits err_rate] = RFI_detect_appx( r, y, x_mod, N, SNR(i), fhandle, p, Es*sigmas', length(p));
            end;
            err_rate_aprx(i) = err_rate_aprx(i) + err_rate;
        end;

        if (bayes_quant_status) % Quantized Bayesian Detection
            [dem_bits err_rate] = RFI_detect_opt_quant( r, x_mod, N, AUsed, GammaUsed, y, partition, codebook, SNR(i), NumTermsPDF );
            err_rate_opt_quant(i)=err_rate_opt_quant(i)+err_rate;
        end;

        if (myriad_status_opt)% Myriad Filtering (Implementation Option 1: Polynomial rooting)
            [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alphaUsed, disperUsed, 1, delay, sampling_ratio, y, M );
            err_rate_myriad_opt(i)=err_rate_myriad_opt(i)+err_rate;
        end;

        if (myriad_status_selec) % Myriad Filtering (Implementation Option 2: Selection Myriad)
            [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alphaUsed, disperUsed, 2, delay, sampling_ratio, y, M );
            err_rate_myriad_selec(i)=err_rate_myriad_selec(i)+err_rate;
        end;
        
        % Status Update
        %---------------------------------------------------------------------
        iterNum = iterNum + 1;
        percDone = ceil(iterNum/no_iterations/length(SNR)*100); %percentage completed
        set(handles.status, 'String', strvcat(StatusString, ['Percentage Completed: ' num2str(percDone) '%']));drawnow;    
        %------------------------------------------------------------------
    end;

end;


% Figure Plotting
figure;
if (corr_status == 1)
    err_rate_corr=err_rate_corr/no_iterations;
    semilogy(SNR,err_rate_corr, 'Displayname', 'Correlation Receiver');
    hold on;
end;
if (wiener_status == 1)
    err_rate_wiener=err_rate_wiener/no_iterations;
    semilogy(SNR, err_rate_wiener,'r','Displayname', 'Wiener Filtering');
    hold on;
end;
if (bayes_status == 1)
    err_rate_opt=err_rate_opt/no_iterations;
    semilogy(SNR, err_rate_opt,'g','Displayname', 'Bayesian Detection');
    hold on;
end;
if (bayes_aprx_status == 1)
    err_rate_aprx=err_rate_aprx/no_iterations;
    semilogy(SNR, err_rate_aprx,'k', 'Displayname', 'Small Signal Approximation');
    hold on;
end;
if (bayes_quant_status == 1)
    err_rate_opt_quant=err_rate_opt_quant/no_iterations;
    semilogy(SNR, err_rate_opt_quant,'m', 'Displayname', 'Quantized Bayesian Detection');
    hold on;
end;
if (myriad_status_opt == 1)
    err_rate_myriad_opt=err_rate_myriad_opt/no_iterations;
    semilogy(SNR, err_rate_myriad_opt,'c', 'Displayname', 'Optimal Myriad Filtering');
    hold on;
end;
if (myriad_status_selec == 1)
    err_rate_myriad_selec=err_rate_myriad_selec/no_iterations;
    semilogy(SNR, err_rate_myriad_selec, 'Color', [0.6 0.2 0.8], 'Displayname', 'Selection Myriad Filtering');
    hold on;
end;

xlim([SNR_low_limit SNR_high_limit]);
xlabel('SNR');ylabel('BER');
title('Communication Performance');
legend('show');

%% Simulation for File Source
elseif strcmp(get(SelectedDataSrc, 'Tag'), 'UseFileTag')
    
    % Settings
    % ------------------------------------------------------------------
    no_bits = 8;
    bytes_read = 1000; % could be made larger to make program faster at the expense of memory req.
    SNR = str2double(get(handles.SNRFileTrsfTag, 'String' ));
    
    % Open input and output files
    % -------------------------------------------------------------
    infile = get(handles.input_file, 'String' ); 
    outfile = get(handles.output_file, 'String' );
    
    RDfid = fopen(infile,'r');
    if (RDfid == -1)
        errordlg('Input file does not exist. Please choose a file in the current directory!','Irrational Settings','modal')
        set(hObject,'String','Start Simulation');
        set(hObject,'enable','on');
        return;
    end;

    s = dir(infile);
    fileSIZE = s.bytes;
    currentStatus = get(handles.status, 'String');
    set(handles.status, 'String', strvcat(currentStatus, [infile ' has been opened']));drawnow;
    if (strcmp(infile,outfile))
        errordlg('Input and Output filenames can not be the same !','Irrational Settings','modal')
        set(hObject,'String','Start Simulation');
        set(hObject,'enable','on');
        return;
    end;
    WRfid = fopen(outfile, 'w');
    if (WRfid == -1 && (~isempty(outfile)))
        errordlg('Error opening output file in write mode !', 'Error Dialog');
        set(hObject,'String','Start Simulation');
        set(hObject,'enable','on');
        fclose(RDfid);
        return;
    end;
    
    % Get the selected detection method
    % ----------------------------------------------------------------
    SelectedDetectionMethod = get(handles.DetectionMethodsBtnTag, 'SelectedObject');
    
    currentStatus = get(handles.status, 'String');
    
    err_rate_total =0;
    bits_trans = 0; % number of transmitted bits over the channel
    while(fileSIZE-bits_trans/8>0)
        bytes_to_read = min(bytes_read,fileSIZE - bits_trans/8);
        [x_pul x_mod Fstatus] = RFI_getANDmodFDATA( RDfid, bytes_to_read, 'uint8',8, 2, y );
        
        if (Fstatus==-1) % probably can be moved into the while condition
            break;
        end;
        
        % Noise generation and SNR sweep
        Es = mean(pammod([0:M-1],M).^2) * mean(y.^2); % Es_normFactor * mean(Pulse Shape.^2) 
        if (is_class_A == 1)
            noise = RFI_MakeDataClassA(A,T,NumTermsPDF,N*no_bits*bytes_to_read);%can be included inside of the loop to provide more
            %randomness at the cost
            %of much more running time
            z=noise*sqrt(10^(-SNR/10)*Es); %renormalize the noise for correct SNR
            r=x_pul+z(:); % add noise to the signal
        elseif (is_alpha == 1)
            noise = RFI_MakeDataAlphaStable(alpha, disper, delta, N*no_bits*bytes_to_read);
            Es = (disper*10^(SNR/10));               % Signal Power as per the definition of a generalized SNR.
            r = x_pul.*sqrt(Es) + noise(:);      % add noise to the signal
        elseif (is_GMixture)
            noise = RFI_MakeDataGMM(1, zeros(NumComps,1), sigmas', p', length(x_pul))/realsqrt(p*sigmas.');
            z= noise * sqrt(10^(-SNR/10)*Es); %renormalize the noise for correct SNR
            r=x_pul+z(:); % add noise to the signal
        end;
        
        % -------------------------------------------------------------------
        % Parameter Estimation
        if get(handles.EstimateParams, 'Value')
            [A_est K_est ] = RFI_EMTwoParamEst(length(noise), 10, noise, 0.35, 0.35*0.01);
            alpha_est = RFI_EstAlphaS_Alpha(noise, length(noise)/8, 0); %localization assumed zero
            disper_est = RFI_EstAlphaS_Dispersion(noise, alpha_est, 0);
        end;
        % -------------------------------------------------------------------
        
        % Used Parameters
        % -------------------------------------------------------------------
        switch get(handles.EstimateParams, 'Value')
            case 0
                alphaUsed = alpha;
                disperUsed = disper;
                AUsed = A;
                GammaUsed = T;
            case 1
                alphaUsed = alpha_est;
                disperUsed = disper_est;
                AUsed = A_est;
                GammaUsed = K_est/A_est;
            otherwise
                disp('Should not be here!')
        end
        
        
        switch get(SelectedDetectionMethod, 'String')
            case 'Correlation Receiver'
                [dem_bits err_rate] = RFI_Matched_Filter( r, x_mod, N, sampling_ratio*delay, sampling_ratio, y, 2);
            case 'Wiener Filtering Detection'
                [dem_bits err_rate] = RFI_detect_wiener( r, x_mod, N, w, delay, sampling_ratio, y, 2);
            case 'Bayesian Detection'
                if (is_class_A)
                    PDFfhandle = @RFI_MakePDFClassA;
                    [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, y, SNR, PDFfhandle, AUsed, GammaUsed,  NumTermsPDF);
                elseif (is_GMixture)
                    PDFfhandle = @RFI_MakePDFGMM;
                    [dem_bits err_rate] = RFI_detect_opt( r, x_mod, N, y, SNR, PDFfhandle, zeros(NumComps,1),(10^(-SNR/10)*Es)*sigmas'/(p*sigmas.'), p');
                end;
            case 'Small Signal Aproximation Bayesian Detection'
                if (is_class_A)
                    fhandle = @RFI_nonlinearity;
                    [dem_bits err_rate] = RFI_detect_appx( r, y, x_mod, N, SNR, fhandle, AUsed, GammaUsed, NumTermsPDF);
                elseif (is_GMixture)
                    fhandle = @RFI_GMnonlinearity;
                    [dem_bits err_rate] = RFI_detect_appx( r, y, x_mod, N, SNR, fhandle, p, Es*sigmas', length(p));
                end
            case 'Quantized Bayesian Detection:'
                [dem_bits err_rate] = RFI_detect_opt_quant( r, x_mod, N, AUsed, GammaUsed, y, partition, codebook, SNR, NumTermsPDF );
            case 'Optimal Myriad Detection'
                [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alphaUsed, disperUsed, 1, delay, sampling_ratio, y, 2 );
            case 'Selection Myriad Detection'
                [dem_bits err_rate] = RFI_detect_myriad( r, x_mod, N, alphaUsed, disperUsed, 2, delay, sampling_ratio, y, 2 );
            otherwise
                
        end;
        
        [ count ] = RFI_decANDwrtFDATA( WRfid, dem_bits, 'uint8',8, 2 );
        bits_trans = bits_trans + length(dem_bits);
        %total_WRbytes = total_WRbytes + count;
        percDONE = bits_trans/fileSIZE/8 *100; %division by 8 to account for the fact that 1 byte is 8 bits

        set(handles.status, 'String', strvcat(currentStatus ,[num2str(ceil(percDONE)) '% completed']));drawnow;
        
        err_rate_total = (err_rate * length(dem_bits) + err_rate_total* bits_trans) / (bits_trans + length(dem_bits));
        
    end;
    
    set(handles.status, 'String', strvcat(currentStatus, [num2str(ceil(100)) '% completed']));drawnow;
    fclose(RDfid);
    if (WRfid ~= -1)
        fclose(WRfid);
    end
    
    if (~isempty(outfile))
        currentStatus = get(handles.status, 'String');
        set(handles.status, 'String', strvcat(currentStatus, [outfile ' has been written']));drawnow;
    end;
    
    currentStatus = get(handles.status, 'String');
    set(handles.status, 'String', strvcat(currentStatus, ['Bit Error Rate =' num2str(err_rate_total)]));drawnow;
   
end

set(hObject,'enable','on');
set(hObject, 'String', 'Start Simulation'); drawnow; 


% --- Executes on key press over start_sim with no controls selected.
function start_sim_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to start_sim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on selection change in Noise_type.
function Noise_type_Callback(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Noise_type contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Noise_type
%val = get(hObject,'Value');

set(handles.EstimateParams, 'Enable', 'on');
EstimateParams = get(handles.EstimateParams, 'Value');
contents = get(hObject,'String');
MPAM_M = str2double(get(handles.MPAM_M,'String'));
set(handles.numComps , 'Visible', 'off');
set(handles.numCompstext , 'Visible', 'off');

% clear all previous selections
%--------------------------------------------------
set(handles.bayesian_dtc, 'Value', 0);
set(handles.small_sig_aprx, 'Value', 0);
set(handles.quant, 'Value', 0);
set(handles.myriad_dtc, 'Value', 0);
set(handles.selec_myriad, 'Value', 0);


switch lower(contents{get(hObject,'Value')})
    case 'class a'
        set(handles.sigmas, 'Visible', 'off');
        set(handles.pValue, 'Visible', 'off');
        set(handles.ptext, 'Visible', 'off');
        set(handles.sigmastext, 'Visible', 'off');
        set(handles.Atext,'Visible','on');
        set(handles.A,'Visible','on');
        set(handles.Gammatext,'Visible','on');
        set(handles.Gamma,'Visible','on');
        set(handles.Alphatext,'Visible','off');
        set(handles.alpha,'Visible','off');
        set(handles.disptext,'Visible','off');
        set(handles.disp,'Visible','off');
        if ~EstimateParams
            set(handles.optimalmyriadBtn,'Enable','off');
            set(handles.selectionmyriadBtn,'Enable','off');
            set(handles.myriad_dtc,'Enable','off');
            set(handles.selec_myriad,'Enable','off');
        end;
        if (MPAM_M ~= 2)
            % check box
            set(handles.bayesian_dtc,'Enable','off');
            set(handles.quant,'Enable','off');
            set(handles.small_sig_aprx,'Enable','off');
            set(handles.quant_level,'Visible','off');
            set(handles.levels,'Visible','off');
            % radio buttons
            set(handles.bayesiandetetionBtn,'Enable','off');
            set(handles.quantizeddetcBtn,'Enable','off');
            set(handles.smallsignalBtn,'Enable','off');
            set(handles.quantlvlsBtn,'Visible','off');
            set(handles.levelsradio,'Visible','off');
        else
            % check box
            set(handles.bayesian_dtc,'Enable','on');
            set(handles.quant,'Enable','on');
            set(handles.small_sig_aprx,'Enable','on');
            if (get(handles.quant,'Value') == 1)
                set(handles.quant_level,'Visible','on');
                set(handles.levels,'Visible','on');
            end
            % radio buttons
            set(handles.bayesiandetetionBtn,'Enable','on');
            set(handles.quantizeddetcBtn,'Enable','on');
            set(handles.smallsignalBtn,'Enable','on');
            if (get(handles.quantizeddetcBtn,'Value') == 1)
                set(handles.quantlvlsBtn,'Visible','on');
                set(handles.levelsradio,'Visible','on');
            end
        end

    case 'alpha stable'
        set(handles.sigmas, 'Visible', 'off');
        set(handles.pValue, 'Visible', 'off');
        set(handles.ptext, 'Visible', 'off');
        set(handles.sigmastext, 'Visible', 'off');
        set(handles.Atext,'Visible','off');
        set(handles.A,'Visible','off');
        set(handles.Gammatext,'Visible','off');
        set(handles.Gamma,'Visible','off');
        set(handles.alpha,'Visible','on');
        set(handles.disp,'Visible','on');
        set(handles.Alphatext,'Visible','on');
        set(handles.disptext,'Visible','on');
        %radio box
        set(handles.optimalmyriadBtn,'Enable','on');
        set(handles.selectionmyriadBtn,'Enable','on');
        %check box
        set(handles.myriad_dtc,'Enable','on');
        set(handles.selec_myriad,'Enable','on');
        if ~EstimateParams
            %check box
            set(handles.quant,'Enable','off');
            set(handles.quant_level,'Visible','off');
            set(handles.levels,'Visible','off');
            set(handles.small_sig_aprx,'Enable','off');
            set(handles.bayesian_dtc,'Enable','off');
            %radio box
            set(handles.bayesiandetetionBtn,'Enable','off');
            set(handles.quantizeddetcBtn,'Enable','off');
            set(handles.smallsignalBtn,'Enable','off');
            set(handles.quantlvlsBtn,'Visible','off');
            set(handles.levelsradio,'Visible','off');
        end;
        
    case 'gaussian mixture'
        set(handles.sigmas, 'Visible', 'on');
        set(handles.pValue, 'Visible', 'on');
        set(handles.ptext, 'Visible', 'on');
        set(handles.sigmastext, 'Visible', 'on');
        set(handles.Atext,'Visible','off');
        set(handles.A,'Visible','off');
        set(handles.Gammatext,'Visible','off');
        set(handles.Gamma,'Visible','off');
        set(handles.alpha,'Visible','off');
        set(handles.disp,'Visible','off');
        set(handles.Alphatext,'Visible','off');
        set(handles.disptext,'Visible','off');
        set(handles.myriad_dtc,'Enable','off');
        set(handles.bayesian_dtc,'Enable','on');
        set(handles.selec_myriad,'Enable','off');
        set(handles.quant,'Enable','off');
        set(handles.quant_level,'Visible','off');
        set(handles.levels,'Visible','off');
        set(handles.small_sig_aprx,'Enable','on');
        set(handles.numComps , 'Visible', 'on');
        set(handles.numCompstext , 'Visible', 'on');
        set(handles.bayesiandetetionBtn,'Enable','on'); %radio btn group
        set(handles.optimalmyriadBtn,'Enable','off');
        set(handles.selectionmyriadBtn,'Enable','off');
        set(handles.myriad_dtc,'Enable','off');
        set(handles.selec_myriad,'Enable','off');
        set(handles.quantizeddetcBtn,'Enable','off');
        set(handles.quantlvlsBtn,'Visible','off');
        set(handles.smallsignalBtn,'Enable','on');
        % -------------------------------------------------
        set(handles.EstimateParams, 'Enable', 'off');  % to be removed when parameter estimation will be allowed
        set(handles.EstimateParams, 'value', 0);
        %-------------------------------------------------
end;
% proceed with callback...

% --- Executes during object creation, after setting all properties.
function Noise_type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Noise_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function alpha_Callback(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of alpha as text
%        str2double(get(hObject,'String')) returns contents of alpha as a double


% --- Executes during object creation, after setting all properties.
function alpha_CreateFcn(hObject, eventdata, handles)
% hObject    handle to alpha (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function disp_Callback(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of disp as text
%        str2double(get(hObject,'String')) returns contents of disp as a double


% --- Executes during object creation, after setting all properties.
function disp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to disp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delta_Callback(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delta as text
%        str2double(get(hObject,'String')) returns contents of delta as a double


% --- Executes during object creation, after setting all properties.
function delta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on button press in myriad_dtc.
function myriad_dtc_Callback(hObject, eventdata, handles)
% hObject    handle to myriad_dtc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of myriad_dtc




% --- Executes on button press in selec_myriad.
function selec_myriad_Callback(hObject, eventdata, handles)
% hObject    handle to selec_myriad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of selec_myriad




% --- Executes on button press in quant.
function quant_Callback(hObject, eventdata, handles)
% hObject    handle to quant (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of quant
val = get(hObject,'Value');
if val == 0
    set(handles.quant_level,'Visible','off');
    set(handles.levels,'Visible','off');
else
    set(handles.quant_level,'Visible','on');
    set(handles.levels,'Visible','on');
end;


function quant_level_Callback(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of quant_level as text
%        str2double(get(hObject,'String')) returns contents of quant_level as a double


% --- Executes during object creation, after setting all properties.
function quant_level_CreateFcn(hObject, eventdata, handles)
% hObject    handle to quant_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in small_sig_aprx.
function small_sig_aprx_Callback(hObject, eventdata, handles)
% hObject    handle to small_sig_aprx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of small_sig_aprx





function MPAM_M_Callback(hObject, eventdata, handles)
% hObject    handle to MPAM_M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MPAM_M as text
%        str2double(get(hObject,'String')) returns contents of MPAM_M as a double
val = get(handles.Noise_type,'Value');
MPAM_M = str2double(get(handles.MPAM_M,'String'));

% clear checked boxes
%---------------------
set(handles.bayesian_dtc, 'Value', 0);
set(handles.small_sig_aprx, 'Value', 0);
set(handles.quant, 'Value', 0);

if (val == 1 || val ==3)
    if (MPAM_M ~= 2)
        set(handles.bayesian_dtc,'Enable','off');
        set(handles.quant,'Enable','off');
        set(handles.small_sig_aprx,'Enable','off');
        set(handles.quant_level,'Visible','off');
        set(handles.levels,'Visible','off');
    else
        set(handles.bayesian_dtc,'Enable','on');
        set(handles.quant,'Enable','on');
        set(handles.small_sig_aprx,'Enable','on');
        if (get(handles.quant,'Value') == 1)
            set(handles.quant_level,'Visible','on');
            set(handles.levels,'Visible','on');
        end
    end
end


% --- Executes during object creation, after setting all properties.
function MPAM_M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MPAM_M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in ImportParams.
function ImportParams_Callback(hObject, eventdata, handles)
% hObject    handle to ImportParams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global  ExportParams;
if isempty(ExportParams)
     errordlg('No Parameters have been exported!','Invalid Parameters');
     return;
end;
validParamsIndx = [ExportParams.isClassA_valid ExportParams.isAlphaStable_valid ExportParams.isGuassianMixture_valid];
if ~any(validParamsIndx)
    errordlg('No Valid Parameters that can be imported!','Invalid Parameters');
    return;
end;
optionsStr = {'Middleton Class A', 'Symmetric Alpha Stable', 'Gaussian Mixture'};
validParams = optionsStr(validParamsIndx); %only the distributions whose parameters can be imported should be displayed
[Selection,ok] = listdlg('ListString',validParams, 'SelectionMode', 'single', 'Name', 'Import Distribution Parameters', 'PromptString', 'Select a distribution', 'OKString', 'Import Parameters', 'ListSize', [270 150]);
if ok==0
    return;
end;
switch char(validParams(Selection))
    case 'Middleton Class A'
        set(handles.A, 'String', num2str(ExportParams.ClassAParams(2)));
        set(handles.Gamma, 'String', num2str(ExportParams.ClassAParams(3)));
        set(handles.Noise_type, 'Value', 1);
        Noise_type_Callback(handles.Noise_type, [], handles);
    case 'Symmetric Alpha Stable'
        set(handles.delta, 'String', num2str(ExportParams.SymAlphaStableParams(1)));
        set(handles.alpha, 'String', num2str(ExportParams.SymAlphaStableParams(2)));
        set(handles.disp, 'String', num2str(ExportParams.SymAlphaStableParams(3)));
        set(handles.Noise_type, 'Value', 2); 
        Noise_type_Callback(handles.Noise_type, [], handles);
    case 'Gaussian Mixture'
        set(handles.pValue, 'String', ['[ ' num2str(ExportParams.GMParams(1,:)) ' ]']);
        set(handles.sigmas, 'String', ['[ ' num2str(ExportParams.GMParams(2,:)) ' ]']);
        set(handles.Noise_type, 'Value', 3);
        Noise_type_Callback(handles.Noise_type, [], handles);
    otherwise
end;
    
    
    



% --- Executes on button press in GMparams.
function GMparams_Callback(hObject, eventdata, handles)
% hObject    handle to GMparams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global GMixtureParams; % the global variable for GMixture params

prompt = {'Enter probablity vector:', 'Enter the variance vector:'};
params = inputdlg(prompt, 'Input Gaussian Mixture Parameters');
eval(['tempParams.p =' params{1} ';']);
eval(['tempParams.SIGMAs =' params{2} ';' ]);

% --- Executes on button press in radiobutton4.
function roadiobutton4_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton4


% --- Executes on button press in radiobutton5.
function radiobutton5_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton5



function output_file_Callback(hObject, eventdata, handles)
% hObject    handle to output_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of output_file as text
%        str2double(get(hObject,'String')) returns contents of output_file as a double


% --- Executes during object creation, after setting all properties.
function output_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to output_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function input_file_Callback(hObject, eventdata, handles)
% hObject    handle to input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of input_file as text
%        str2double(get(hObject,'String')) returns contents of input_file as a double


% --- Executes during object creation, after setting all properties.
function input_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in input_browse.
function input_browse_Callback(hObject, eventdata, handles)
% hObject    handle to input_browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uigetfile('*','Choose a file to transfer'); 
if (FileName ~= 0)
    set(handles.input_file,'String',[PathName FileName]);
end;


% --- Executes on button press in output_browse.
function output_browse_Callback(hObject, eventdata, handles)
% hObject    handle to output_browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName,PathName,FilterIndex] = uiputfile('*.*','Choose a file to save the result to');
if (FileName ~= 0)
    if (FileName(length(FileName)) == '*') %remove * character in case the user didnt include a file extension
        FileName = FileName(1:length(FileName)-2);
    end;
    set(handles.output_file,'String',[PathName FileName]);
end;


% --- Executes when DataSourcePanel is resized.
function DataSourcePanel_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to DataSourcePanel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function edit27_Callback(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit27 as text
%        str2double(get(hObject,'String')) returns contents of edit27 as a double


% --- Executes during object creation, after setting all properties.
function edit27_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function status_Callback(hObject, eventdata, handles)
% hObject    handle to status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of status as text
%        str2double(get(hObject,'String')) returns contents of status as a double


% --- Executes during object creation, after setting all properties.
function status_CreateFcn(hObject, eventdata, handles)
% hObject    handle to status (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function pValue_Callback(hObject, eventdata, handles)
% hObject    handle to pValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of pValue as text
%        str2double(get(hObject,'String')) returns contents of pValue as a double
eval(['MixProbVec =' get(hObject, 'String') ';']);
numMixComps = str2double(get(handles.numComps, 'String'));
MixProbVec(MixProbVec<0) = 0; % set all negative probabilities to zero
if (length(MixProbVec)~= numMixComps)
   %errordlg('Invalid mixing probability vector! Parameters reset...');
    MixProbVec = [MixProbVec(1:min(numMixComps,length(MixProbVec))) zeros(1, max(0,numMixComps - length(MixProbVec)))]; %rand(1,numMixComps);
end;
if all(MixProbVec == 0) %make sure there is no all zero probabilities
    MixProbVec(1) = 1;
end;
MixProbVec = MixProbVec/sum(MixProbVec);
set(hObject, 'String', ['[ ' num2str(MixProbVec) ' ]' ]);


% --- Executes during object creation, after setting all properties.
function pValue_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in radiobutton10.
function radiobutton10_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton10


% --- Executes on button press in radiobutton11.
function radiobutton11_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton11


% --- Executes on button press in GenRandDataTag.
function GenRandDataTag_Callback(hObject, eventdata, handles)
% hObject    handle to GenRandDataTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of GenRandDataTag


% --- Executes when selected object is changed in DataSourcePanel.
function DataSourcePanel_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in DataSourcePanel 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
switch get(hObject, 'Tag')
    case 'RndDataTag'
        set(handles.DetectionMethodsBtnTag, 'Visible', 'off' );
        set(handles.DetectionMethodsSelectTag, 'Visible', 'on');
        set(handles.SNRindcTag, 'String', 'Range(dB):');
        set(handles.SNRFileTrsfTag, 'Visible', 'off');
        set(handles.SNRrange_low_limit, 'Visible', 'on');
        set(handles.SNR_step_size, 'Visible', 'on');
        set(handles.SNRrange_high_limit, 'Visible', 'on');
        set(handles.textSNRtag, 'Visible', 'on' );
    case 'UseFileTag'
        set(handles.DetectionMethodsBtnTag, 'Position', [2.4 0.769 66 15]);
        set(handles.DetectionMethodsBtnTag, 'Visible', 'on' );
        set(handles.DetectionMethodsSelectTag, 'Visible', 'off'); 
        set(handles.SNRindcTag, 'String', 'SNR(dB):');
        set(handles.SNRFileTrsfTag, 'Visible', 'on');
        set(handles.SNRrange_low_limit, 'Visible', 'off');
        set(handles.SNR_step_size, 'Visible', 'off');
        set(handles.textSNRtag, 'Visible', 'off' );
        set(handles.SNRrange_high_limit, 'Visible', 'off');
    otherwise
        disp('Should not be here');        
end;
Noise_type_Callback(handles.Noise_type, eventdata, handles);




function SNRFileTrsfTag_Callback(hObject, eventdata, handles)
% hObject    handle to SNRFileTrsfTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNRFileTrsfTag as text
%        str2double(get(hObject,'String')) returns contents of SNRFileTrsfTag as a double


% --- Executes during object creation, after setting all properties.
function SNRFileTrsfTag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNRFileTrsfTag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in EstimateParams.
function EstimateParams_Callback(hObject, eventdata, handles)
% hObject    handle to EstimateParams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of EstimateParams
noiseType = get(handles.Noise_type, 'String'); % noise values
MPAM_M = str2double(get(handles.MPAM_M,'String'));

EstimateParams = get(hObject, 'Value');
if EstimateParams
    if (MPAM_M ~= 2)
        set(handles.bayesian_dtc,'Enable','off');
        set(handles.quant,'Enable','off');
        set(handles.small_sig_aprx,'Enable','off');
        set(handles.quant_level,'Visible','off');
        set(handles.levels,'Visible','off');
        % radio buttons
        set(handles.bayesiandetetionBtn,'Enable','off');
        set(handles.quantizeddetcBtn,'Enable','off');
        set(handles.smallsignalBtn,'Enable','off');
        set(handles.quantlvlsBtn,'Visible','off');
        set(handles.levelsradio,'Visible','off');
    else
        set(handles.bayesian_dtc,'Enable','on');
        set(handles.quant,'Enable','on');
        set(handles.small_sig_aprx,'Enable','on');
        if (get(handles.quant,'Value') == 1)
            set(handles.quant_level,'Visible','on');
            set(handles.levels,'Visible','on');
        end
        % radio buttons
        set(handles.bayesiandetetionBtn,'Enable','on');
        set(handles.quantizeddetcBtn,'Enable','on');
        set(handles.smallsignalBtn,'Enable','on');
        if (get(handles.quantizeddetcBtn,'Value') == 1)
            set(handles.quantlvlsBtn,'Visible','on');
            set(handles.levelsradio,'Visible','on');
        end
    end;
    set(handles.myriad_dtc,'Enable','on');% checkbox
    set(handles.selec_myriad,'Enable','on');% checkbox
    set(handles.optimalmyriadBtn,'Enable','on'); %radio box
    set(handles.selectionmyriadBtn,'Enable','on');% radio box

else
    switch lower(noiseType{get(handles.Noise_type,'Value')})
        case 'class a'
            
            set(handles.myriad_dtc, 'Value', 0);
            set(handles.selec_myriad, 'Value', 0);
            
            set(handles.myriad_dtc,'Enable','off');
            set(handles.selec_myriad,'Enable','off');
            set(handles.optimalmyriadBtn,'Enable','off');
            set(handles.selectionmyriadBtn,'Enable','off');
            
            if (MPAM_M ~= 2)
                set(handles.bayesian_dtc,'Enable','off');
                set(handles.quant,'Enable','off');
                set(handles.small_sig_aprx,'Enable','off');
                set(handles.quant_level,'Visible','off');
                set(handles.levels,'Visible','off');
                % radio buttons
                set(handles.bayesiandetetionBtn,'Enable','off');
                set(handles.quantizeddetcBtn,'Enable','off');
                set(handles.smallsignalBtn,'Enable','off');
                set(handles.quantlvlsBtn,'Visible','off');
                set(handles.levelsradio,'Visible','off');
            else
                set(handles.bayesian_dtc,'Enable','on');
                set(handles.quant,'Enable','on');
                set(handles.small_sig_aprx,'Enable','on');
                if (get(handles.quant,'Value') == 1)
                    set(handles.quant_level,'Visible','on');
                    set(handles.levels,'Visible','on');
                end
                % radio buttons
                set(handles.bayesiandetetionBtn,'Enable','on');
                set(handles.quantizeddetcBtn,'Enable','on');
                set(handles.smallsignalBtn,'Enable','on');
                if (get(handles.quantizeddetcBtn,'Value') == 1)
                    set(handles.quantlvlsBtn,'Visible','on');
                    set(handles.levelsradio,'Visible','on');
                end
            end
            
        case 'alpha stable'
            set(handles.myriad_dtc,'Enable','on');
            set(handles.selec_myriad,'Enable','on');
            set(handles.optimalmyriadBtn,'Enable','on');
            set(handles.selectionmyriadBtn,'Enable','on');
            set(handles.quant,'Enable','off');
            set(handles.quant_level,'Visible','off');
            set(handles.levels,'Visible','off');
            set(handles.small_sig_aprx,'Enable','off');
            set(handles.bayesian_dtc,'Enable','off');
            set(handles.bayesiandetetionBtn,'Enable','off');
            set(handles.quantizeddetcBtn,'Enable','off');
            set(handles.smallsignalBtn,'Enable','off');
            set(handles.quantlvlsBtn,'Visible','off');
            set(handles.levelsradio,'Visible','off');
            
            set(handles.bayesian_dtc, 'Value', 0);
            set(handles.small_sig_aprx, 'Value', 0);
            set(handles.quant, 'Value', 0);
            
        case 'gaussian mixture'

    end;
end;



function quantlvlsBtn_Callback(hObject, eventdata, handles)
% hObject    handle to quantlvlsBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of quantlvlsBtn as text
%        str2double(get(hObject,'String')) returns contents of quantlvlsBtn as a double


% --- Executes during object creation, after setting all properties.
function quantlvlsBtn_CreateFcn(hObject, eventdata, handles)
% hObject    handle to quantlvlsBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes when selected object is changed in DetectionMethodsBtnTag.
function DetectionMethodsBtnTag_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in DetectionMethodsBtnTag 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
name = get(get(handles.DetectionMethodsBtnTag, 'SelectedObject'), 'Tag' );
if strcmp(name, 'quantizeddetcBtn')
    set(handles.quantlvlsBtn,'Visible','on');
    set(handles.levelsradio,'Visible','on');
else
    set(handles.quantlvlsBtn,'Visible','off');
    set(handles.levelsradio,'Visible','off');
end;



% --- Executes during object creation, after setting all properties.
function EstimateParams_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EstimateParams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on button press in clearstatus.
function clearstatus_Callback(hObject, eventdata, handles)
% hObject    handle to clearstatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.status, 'String', 'Idle.');


function edit33_Callback(hObject, eventdata, handles)
% hObject    handle to edit33 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit33 as text
%        str2double(get(hObject,'String')) returns contents of edit33 as a double


% --- Executes during object creation, after setting all properties.
function edit33_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit33 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function sigmas_Callback(hObject, eventdata, handles)
% hObject    handle to sigmas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmas as text
%        str2double(get(hObject,'String')) returns contents of sigmas as a double
eval(['MixVarVec =' get(hObject, 'String') ';']);
numMixComps = str2double(get(handles.numComps, 'String'));
MixVarVec(MixVarVec<=0) = 1;
if (length(MixVarVec)~= numMixComps)
    %errordlg('Invalid component variance vector! Parameters reset...');
    MixVarVec = [MixVarVec(1:min(numMixComps,length(MixVarVec))) ones(1, max(0,numMixComps - length(MixVarVec)))];%rand(1,numMixComps);
end;
set(hObject, 'String', ['[ ' num2str(MixVarVec) ' ]' ]);


% --- Executes during object creation, after setting all properties.
function sigmas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function numComps_Callback(hObject, eventdata, handles)
% hObject    handle to numComps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of numComps as text
%        str2double(get(hObject,'String')) returns contents of numComps as a double
numMixComps = floor(str2double(get(hObject, 'String')));
if numMixComps < 1 
    errordlg('Invalid number of Gaussian mixture components! Parameters reset...');
    numMixComps = 2;
    set(hObject, 'String', num2str(numMixComps));
end;
eval(['MixProbVec =' get(handles.pValue, 'String') ';']);
eval(['MixVarVec =' get(handles.sigmas, 'String') ';']);
if (length(MixProbVec)~= numMixComps || length(MixVarVec)~= numMixComps)
    pValue_Callback(handles.pValue, eventdata, handles);
    sigmas_Callback(handles.sigmas, eventdata, handles);
end;

% --- Executes during object creation, after setting all properties.
function numComps_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numComps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
