function bits = RFI_bi_detector( s1 , s2, x, SNR, PDFfhandle, opt ) % A, Gamma, N_T, 
%bits = RFI_bi_detector( s1 , s2, x, A, Gamma, N_T );
%This function chooses the most likelihood hypothesis between H1 and H2
%corresponding to s1 and s2, given that the additive noise follows Class A
%Middleton Model.
% Inputs:  
%           s1    - vector representing the transmitted signal under hypothesis
%                   H1 (bit 1 in this case)
%           s2    - vector representing the transmitted signal under hypothesis
%                   H2 (bit 0 in this case)
%           x     - matrix representing the received signal (each column represent
%                   a single modulated bit, that is given a i-th column it
%                   represents the i-th bit pulse shaped signal)
%           SNR    - is the SNR of the received signal. This is
%            necessary inorder to have the accurate pdf of class A (in dB)
%           PDFfhandle  -the handle the function that computes the PDF of
%                      the used noise model
%           opt     -opt the options for the PDF function (made of three components)
% Outputs:  bits       - a vector containing the detected bit stream
%
% Reference:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)
% 
%Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 06/28/10  1.5 beta    nassar    made the function more general to
% accomodate Gaussian mixture model

s1=s1(:);
s2=s2(:);

[N M]=size(x); % number of samples
% Implementing Eq 15 in [1]
diff_H1 = (x-s1(:,ones(1,M)))/sqrt(10^(-SNR/10)); 
diff_H2 = (x-s2(:,ones(1,M)))/sqrt(10^(-SNR/10));
% prob_H1 = prod(RFI_MakePDFClassA( diff_H1,A, Gamma, N_T));
% prob_H2 = prod(RFI_MakePDFClassA(diff_H2, A, Gamma, N_T));
prob_H1 = prod(reshape(PDFfhandle(diff_H1(:),opt{1}, opt{2}, opt{3}), N, M));
prob_H2 = prod(reshape(PDFfhandle(diff_H2(:),opt{1}, opt{2}, opt{3}), N, M));
[c sign_index] = max(abs(s1)); %obtain the index of the maximum magnitude of the raised cosine
                               % this maximum indicates the sign of the
                               % waveform s1, s2 has the same index
bits = (prob_H1 > prob_H2)*sign(s1(sign_index)) + (prob_H1 <= prob_H2)*sign(s2(sign_index)); %detect the bits