function GMMPDF = RFI_MakePDFGMM (noise_data, muMat, sigmaMat, mixProb )
%GMMPDF = RFI_MakePDFGMM (muMat, sigmaMat, mixProb, noise_data)
%This function evaluates the PDF of Gaussian mixture model (GMM) at the
%data samples values provided in noise_data
% Inputs:   muMat - NMixtures x NDim matrix of mean of each Gaussian
%                   mixture component. Each row corresponds to a NDim
%                   vector of mean value of each of the Gaussian
%                   components.
%           sigmaMat - NMixtures x NDim x NDim matrix of covariance
%                      matrices of each Gaussian mixture components. First
%                      index corresponds to the mixture, and second and
%                      third dimensions correspond to the NDim x NDim
%                      covariance matrix for that Gaussian mixture
%                      component.
%          mixProb - NMixtures x 1 vector of mixture probability of each of
%                    of the Gaussian mixture components.
%          noise_data - N x NDim matrix of data samples at which the PDF
%                       has to be evaluated.
% Outputs: GMMPDF - N x 1 vector of GMM PDF evaluated at data sample values
%                   in noise_data
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Kapil Gulati   (gulati@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 05/28/10  1.5 beta    gulati    Original RFI_MakePDFGMM
% 06/28/10  1.5 beta    nassar    modified the order of the input arguments
% to make implementaion consistent with other PDF functions
NMixtures   = length(mixProb);
GMMPDF      = zeros(size(noise_data,1),1);


for i = 1:NMixtures
    MU       = muMat(i,:);                      % MU is then (1 x NDim)
    SIGMA    = squeeze(sigmaMat(i,:,:));        % SIGMA is then (NDim x NDim)
    GMMPDF   = GMMPDF  + mixProb(i) .* mvnpdf(noise_data, MU, SIGMA);
end

return
