function [ count ] = RFI_decANDwrtFDATA( fid, demDATA, precision, NObits_pres, M )
%[ count ] = RFI_decANDwrtFDATA( fid, demDATA, precision, NObits_pres, M )
%   Function writes decoded bits into a binary file
% Inputs:   fid   - the id of the open file that will serve as the
%                   destination for the bits
%           demDATA - are the demodulated data to be written into the file
%                   with fid
%           precision  - specifies the precision used to write to the
%           destination file (use 'uint8' to ensure there are no issues at the end of the file)
%           M - the number of constellation point, use 2
%           NObits_pres - the number of bits used to represent variable saved with the given precision (8 for uint8) 
% Outputs: count - the number of bytes that have been copied into the file
%
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar (nassar@ece.utexas.edu)
%
% Revisions:
% Date      Version     Owner     Comments
% -------------------------------------------------------------------------
% 02/6/09    1.0        nassar    Original implementation 
% 12/14/09   1.4 beta   gulati    Added check for output file not existing


%binDATA = num2str((pamdemod(demDATA, M))');  % string implementation slow
binDATA = char((pamdemod(demDATA, M))' + 48); % Uint8 cast implementation
binDATA = reshape(binDATA, [], NObits_pres);% this ensures that only available number of bytes is read
WRdata = cast(bin2dec(binDATA), precision);
if (fid == -1)
    count = length(WRdata);
else
    count = fwrite(fid, WRdata, precision);
end
