function varargout = RFI_DemoModelingAndMitigation(varargin)
%RFI_DEMOMODELINGANDMITIGATION M-file for RFI_DemoModelingAndMitigation.fig
%      RFI_DEMOMODELINGANDMITIGATION, by itself, creates a new RFI_DEMOMODELINGANDMITIGATION or raises the existing
%      singleton*.
%
%      H = RFI_DEMOMODELINGANDMITIGATION returns the handle to a new RFI_DEMOMODELINGANDMITIGATION or the handle to
%      the existing singleton*.
%
%      RFI_DEMOMODELINGANDMITIGATION('Property','Value',...) creates a new RFI_DEMOMODELINGANDMITIGATION using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to RFI_DemoModelingAndMitigation_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      RFI_DEMOMODELINGANDMITIGATION('CALLBACK') and RFI_DEMOMODELINGANDMITIGATION('CALLBACK',hObject,...) call the
%      local function named CALLBACK in RFI_DEMOMODELINGANDMITIGATION.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RFI_DemoModelingAndMitigation

% Last Modified by GUIDE v2.5 05-Apr-2010 19:56:04

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @RFI_DemoModelingAndMitigation_OpeningFcn, ...
    'gui_OutputFcn',  @RFI_DemoModelingAndMitigation_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_DemoModelingAndMitigation is made visible.
function RFI_DemoModelingAndMitigation_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for RFI_DemoModelingAndMitigation
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_DemoModelingAndMitigation wait for user response (see UIRESUME)
% uiwait(handles.figure1);
clc;
ECE_logo=imread('neg_logo.jpg');
set(handles.ECE_logo,'HandleVisibility','ON');
axes(handles.ECE_logo);
image(ECE_logo);
axis equal;
axis tight;
axis off;
set(handles.ECE_logo,'HandleVisibility','OFF');

ESPL_logo=imread('ESPL_logo.jpg');
set(handles.ESPL_logo,'HandleVisibility','ON');
axes(handles.ESPL_logo);
image(imresize(ESPL_logo, 0.4));
axis equal;
axis tight;
axis off;
set(handles.ESPL_logo,'HandleVisibility','OFF');

% StartUp
ManageEnableDisableModelParams(hObject, eventdata, handles)

% --- Outputs from this function are returned to the command line.
function varargout = RFI_DemoModelingAndMitigation_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Help.
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
fid = fopen('RFI_DemoModelingAndMitigation.txt','r');
MsgStrCell = textscan(fid, '%s','delimiter', '\n');
fclose (fid);

h = figure;
set(h,'Menubar','none');
set(h,'NumberTitle','off');
set(h, 'Name','Demo Help');
set(h, 'ResizeFcn', @HelpFigResize);
PosFigure = get(h,'Position');
uicontrol('Parent', h, 'Style', 'edit','Max',2,'String',MsgStrCell{:},'Position',[1 1 PosFigure(3) PosFigure(4)],'HorizontalAlignment','Left');

function HelpFigResize(src,evt)
h = gcbo;
PosFigure = get(h, 'Position');
hChild = get(h,'Children');
set(hChild, 'Position',[1 1 PosFigure(3) PosFigure(4)]);



% --- Executes on button press in ClearStatus.
function ClearStatus_Callback(hObject, eventdata, handles)
% hObject    handle to ClearStatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.Results,'String','');


function Results_Callback(hObject, eventdata, handles)
% hObject    handle to Results (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Results as text
%        str2double(get(hObject,'String')) returns contents of Results as a double


% --- Executes during object creation, after setting all properties.
function Results_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Results (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in RxCorrelation.
function RxCorrelation_Callback(hObject, eventdata, handles)
% hObject    handle to RxCorrelation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RxCorrelation


% --- Executes on button press in RxBayesian.
function RxBayesian_Callback(hObject, eventdata, handles)
% hObject    handle to RxBayesian (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RxBayesian


% --- Executes on button press in RxMyriad.
function RxMyriad_Callback(hObject, eventdata, handles)
% hObject    handle to RxMyriad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RxMyriad


% --- Executes on button press in RFIFit_MCA.
function RFIFit_MCA_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_MCA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_MCA

RFIGen_index = get(get(handles.RFIGeneration,'SelectedObject'),'Userdata');

if (RFIGen_index == 1)
    set(handles.RFIFit_MCA, 'Value', 1);
    set(handles.RFIFit_SAS, 'Value', 0);
    set(handles.RFIFit_Gaussian, 'Value', 0);
end
ManageEnableDisableModelParams(hObject, eventdata, handles);

% --- Executes on button press in RFIFit_SAS.
function RFIFit_SAS_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_SAS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_SAS
RFIGen_index = get(get(handles.RFIGeneration,'SelectedObject'),'Userdata');

if (RFIGen_index == 1)
    set(handles.RFIFit_MCA, 'Value', 0);
    set(handles.RFIFit_SAS, 'Value', 1);
    set(handles.RFIFit_Gaussian, 'Value', 0);
end
ManageEnableDisableModelParams(hObject, eventdata, handles);

% --- Executes on button press in RFIFit_Gaussian.
function RFIFit_Gaussian_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_Gaussian (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of RFIFit_Gaussian
RFIGen_index = get(get(handles.RFIGeneration,'SelectedObject'),'Userdata');

if (RFIGen_index == 1)
    set(handles.RFIFit_MCA, 'Value', 0);
    set(handles.RFIFit_SAS, 'Value', 0);
    set(handles.RFIFit_Gaussian, 'Value', 1);
end
ManageEnableDisableModelParams(hObject, eventdata, handles);

function MCA_A_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_A as text
%        str2double(get(hObject,'String')) returns contents of MCA_A as a double


% --- Executes during object creation, after setting all properties.
function MCA_A_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_A (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MCA_Gamma_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_Gamma as text
%        str2double(get(hObject,'String')) returns contents of MCA_Gamma as a double


% --- Executes during object creation, after setting all properties.
function MCA_Gamma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_Gamma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function MCA_SigmaSq_Callback(hObject, eventdata, handles)
% hObject    handle to MCA_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MCA_SigmaSq as text
%        str2double(get(hObject,'String')) returns contents of MCA_SigmaSq as a double


% --- Executes during object creation, after setting all properties.
function MCA_SigmaSq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MCA_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SAS_CharExp_Callback(hObject, eventdata, handles)
% hObject    handle to SAS_CharExp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SAS_CharExp as text
%        str2double(get(hObject,'String')) returns contents of SAS_CharExp as a double


% --- Executes during object creation, after setting all properties.
function SAS_CharExp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAS_CharExp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SAS_Disper_Callback(hObject, eventdata, handles)
% hObject    handle to SAS_Disper (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SAS_Disper as text
%        str2double(get(hObject,'String')) returns contents of SAS_Disper as a double


% --- Executes during object creation, after setting all properties.
function SAS_Disper_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAS_Disper (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Gaussian_SigmaSq_Callback(hObject, eventdata, handles)
% hObject    handle to Gaussian_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Gaussian_SigmaSq as text
%        str2double(get(hObject,'String')) returns contents of Gaussian_SigmaSq as a double


% --- Executes during object creation, after setting all properties.
function Gaussian_SigmaSq_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Gaussian_SigmaSq (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function xmax_Callback(hObject, eventdata, handles)
% hObject    handle to xmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xmax as text
%        str2double(get(hObject,'String')) returns contents of xmax as a double


% --- Executes during object creation, after setting all properties.
function xmax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function xres_Callback(hObject, eventdata, handles)
% hObject    handle to xres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of xres as text
%        str2double(get(hObject,'String')) returns contents of xres as a double


% --- Executes during object creation, after setting all properties.
function xres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to xres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Filename_Callback(hObject, eventdata, handles)
% hObject    handle to Filename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Filename as text
%        str2double(get(hObject,'String')) returns contents of Filename as a double


% --- Executes during object creation, after setting all properties.
function Filename_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Filename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Browse.
function Browse_Callback(hObject, eventdata, handles)
% hObject    handle to Browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename pathname filterindex] = uigetfile('*','Please choose measurement data set');
if (filename ~= 0)
    set(handles.Filename,'String',strcat(pathname, filename));
end


% --- Executes on button press in HelpFileFormat.
function HelpFileFormat_Callback(hObject, eventdata, handles)
% hObject    handle to HelpFileFormat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
helpdlg('One Column for Real or Envelope Data. Two Column data otherwise separated by space(s).','Expected File Format');

% --- Executes on selection change in RFIEnvironment.
function RFIEnvironment_Callback(hObject, eventdata, handles)
% hObject    handle to RFIEnvironment (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns RFIEnvironment contents as cell array
%        contents{get(hObject,'Value')} returns selected item from RFIEnvironment

RFIGen_index    = get(get(handles.RFIGeneration,'SelectedObject'),'Userdata');
RFIEnv          = get(handles.RFIEnvironment,'Value');

if (RFIGen_index == 1)
    switch RFIEnv
        case (1)
            % Highly Impulsive
            MCA_A       = 0.01;
            MCA_Gamma   = 0.01;
            MCA_SigmaSq = 1;
            
            SAS_CharExp = 1.0;
            SAS_Disper  = 1;
            
            Gaussian_SigmaSq =  1;
            
        case (2)
            % Moderately Impulsive
            MCA_A       = 0.1;
            MCA_Gamma   = 0.1;
            MCA_SigmaSq = 1;
            
            SAS_CharExp = 1.5;
            SAS_Disper  = 1;
            
            Gaussian_SigmaSq =  1;
            
        case (3)
            % Nearly Gaussian
            MCA_A       = 1;
            MCA_Gamma   = 0.1;
            MCA_SigmaSq = 1;
            
            SAS_CharExp = 1.8;
            SAS_Disper  = 1;
            
            Gaussian_SigmaSq =  1;
    end
    
    % MCA Parameters
    set(handles.MCA_A, 'String', num2str(MCA_A));
    set(handles.MCA_Gamma, 'String', num2str(MCA_Gamma));
    set(handles.MCA_SigmaSq, 'String', num2str(MCA_SigmaSq));
    
    % SAS Parameters
    set(handles.SAS_CharExp, 'String', num2str(SAS_CharExp));
    set(handles.SAS_Disper, 'String', num2str(SAS_Disper));
    
    % Gaussian Parameters
    set(handles.Gaussian_SigmaSq, 'String', num2str(Gaussian_SigmaSq));
end


% --- Executes during object creation, after setting all properties.
function RFIEnvironment_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RFIEnvironment (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in FileFormat.
function FileFormat_Callback(hObject, eventdata, handles)
% hObject    handle to FileFormat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns FileFormat contents as cell array
%        contents{get(hObject,'Value')} returns selected item from FileFormat


% --- Executes during object creation, after setting all properties.
function FileFormat_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FileFormat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function NSymbols_Callback(hObject, eventdata, handles)
% hObject    handle to NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NSymbols as text
%        str2double(get(hObject,'String')) returns contents of NSymbols as a double


% --- Executes during object creation, after setting all properties.
function NSymbols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function RCP_ratio_Callback(hObject, eventdata, handles)
% hObject    handle to RCP_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RCP_ratio as text
%        str2double(get(hObject,'String')) returns contents of RCP_ratio as a double


% --- Executes during object creation, after setting all properties.
function RCP_ratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RCP_ratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function RCP_delay_Callback(hObject, eventdata, handles)
% hObject    handle to RCP_delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RCP_delay as text
%        str2double(get(hObject,'String')) returns contents of RCP_delay as a double


% --- Executes during object creation, after setting all properties.
function RCP_delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RCP_delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function RCP_r_Callback(hObject, eventdata, handles)
% hObject    handle to RCP_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RCP_r as text
%        str2double(get(hObject,'String')) returns contents of RCP_r as a double


% --- Executes during object creation, after setting all properties.
function RCP_r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RCP_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNR_min_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_min as text
%        str2double(get(hObject,'String')) returns contents of SNR_min as a double


% --- Executes during object creation, after setting all properties.
function SNR_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNR_step_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_step as text
%        str2double(get(hObject,'String')) returns contents of SNR_step as a double


% --- Executes during object creation, after setting all properties.
function SNR_step_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function SNR_max_Callback(hObject, eventdata, handles)
% hObject    handle to SNR_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of SNR_max as text
%        str2double(get(hObject,'String')) returns contents of SNR_max as a double


% --- Executes during object creation, after setting all properties.
function SNR_max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SNR_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function RFIFit_NSymbols_Callback(hObject, eventdata, handles)
% hObject    handle to RFIFit_NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RFIFit_NSymbols as text
%        str2double(get(hObject,'String')) returns contents of RFIFit_NSymbols as a double


% --- Executes during object creation, after setting all properties.
function RFIFit_NSymbols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RFIFit_NSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in SyntheticData.
function SyntheticData_Callback(hObject, eventdata, handles)
% hObject    handle to SyntheticData (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of SyntheticData
RFIFit_MCA      = get(handles.RFIFit_MCA,'Value');
RFIFit_SAS      = get(handles.RFIFit_SAS,'Value');
RFIFit_Gaussian = get(handles.RFIFit_Gaussian,'Value');

% Can choose only one of the statistical models in this case. Also, atleast
% one has to be selected.
if (RFIFit_MCA + RFIFit_SAS + RFIFit_Gaussian ~= 1)
    set(handles.RFIFit_MCA, 'Value', 1);
    set(handles.RFIFit_SAS, 'Value', 0);
    set(handles.RFIFit_Gaussian, 'Value', 0);
end
ManageEnableDisableModelParams(hObject, eventdata, handles);

% --- Executes on button press in MeasuredData.
function MeasuredData_Callback(hObject, eventdata, handles)
% hObject    handle to MeasuredData (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of MeasuredData
set(handles.RFIFit_MCA, 'Value', 1);
set(handles.RFIFit_SAS, 'Value', 1);
set(handles.RFIFit_Gaussian, 'Value', 1);
ManageEnableDisableModelParams(hObject, eventdata, handles);

function ManageEnableDisableModelParams(hObject, eventdata, handles)

RFIGen_index    = (get(get(handles.RFIGeneration,'SelectedObject'),'Userdata'));
RFIFit_MCA      = get(handles.RFIFit_MCA,'Value');
RFIFit_SAS      = get(handles.RFIFit_SAS,'Value');
RFIFit_Gaussian = get(handles.RFIFit_Gaussian,'Value');

if (isempty(RFIGen_index))
    return;
end

% MCA Parameters Enable
Enable_MCA_A        = 'off';
Enable_MCA_Gamma    = 'off';
Enable_MCA_SigmaSq  = 'off';
% SAS Parameters Enable
Enable_SAS_CharExp   = 'off';
Enable_SAS_Disper    = 'off';
% Gaussian Parameters Enable
Enable_Gaussian_SigmaSq = 'off';

switch RFIGen_index
    case (1)
        % Synthetic Data
        if (RFIFit_MCA == 1)
            Enable_MCA_A        = 'on';
            Enable_MCA_Gamma    = 'on';
            Enable_MCA_SigmaSq  = 'on';
        end
        
        if (RFIFit_SAS == 1)
            Enable_SAS_CharExp   = 'on';
            Enable_SAS_Disper    = 'on';
        end
        
        if (RFIFit_Gaussian == 1)
            Enable_Gaussian_SigmaSq = 'on';
        end
        
    case (2)
        % Measured Data
        % Keep everything disabled
end

% MCA Parameters Enable
set(handles.MCA_A, 'Enable', Enable_MCA_A);
set(handles.MCA_Gamma, 'Enable', Enable_MCA_Gamma);
set(handles.MCA_SigmaSq, 'Enable', Enable_MCA_SigmaSq);
% SAS Parameters Enable
set(handles.SAS_CharExp, 'Enable', Enable_SAS_CharExp);
set(handles.SAS_Disper, 'Enable', Enable_SAS_Disper);
% Gaussian Parameters Enable
set(handles.Gaussian_SigmaSq, 'Enable', Enable_Gaussian_SigmaSq);



% --- Executes on button press in StartSim.
function StartSim_Callback(hObject, eventdata, handles)
% hObject    handle to StartSim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Disable GUI to be chosen as a figure
set(handles.figure1, 'HandleVisibility','OFF');

% Status Update
CurrStatus = get(handles.Results, 'String');
set(handles.Results, 'String', strvcat(CurrStatus, 'Starting Simulation...')); drawnow;

% Retrieve Simulation Parameters
% -------------------------------------------------------------------------

% ---- RFI Generation
RFIGen_index = get(get(handles.RFIGeneration,'SelectedObject'),'Userdata');

% ---- RFI Modeling
RFIFit_MCA      = get(handles.RFIFit_MCA,'Value');
RFIFit_SAS      = get(handles.RFIFit_SAS,'Value');
RFIFit_Gaussian = get(handles.RFIFit_Gaussian,'Value');

% No of symbols used to fit the data
RFIFit_NSymbols = str2double(get(handles.RFIFit_NSymbols, 'String'));

% Parameters to determine the support over which the densities are
% estimated and plotted
RFIFit_xmax     = str2double(get(handles.xmax,'String'));
RFIFit_xres     = str2double(get(handles.xres,'String'));

% ---- RFI Mitigation
RxCorrelation   = get(handles.RxCorrelation, 'Value');
RxBayesian      = get(handles.RxBayesian, 'Value');
RxMyriad        = get(handles.RxMyriad, 'Value');
% Number of symbols to transmit
NSymbols        = str2double(get(handles.NSymbols, 'String'));
% Raised Cosine Pulse Shape Parameters
RCP_delay       = str2double(get(handles.RCP_delay, 'String'));
RCP_r           = str2double(get(handles.RCP_r, 'String'));
RCP_ratio       = str2double(get(handles.RCP_ratio, 'String'));
% SNR sweep parameters
SNR_min         = str2double(get(handles.SNR_min, 'String'));
SNR_max         = str2double(get(handles.SNR_max, 'String'));
SNR_step        = str2double(get(handles.SNR_step, 'String'));

% HardCoded Parameters (Try to remove or make user controlled)
% -------------------------------------------------------------------------
NTerms_MCA          = 100;
SAS_K               = 8;
VALUESMALL          = 10^-8;
NTrainSymbols       = 10000;
NPointsTailProb     = 100;
MPAM                = 2;    % BPSK only for this demo
MaxSymbolsPerIter   = 10000;

% RFI Generation
% -------------------------------------------------------------------------
if (isempty(RFIGen_index))
    errordlg('Please choose a RFI generation method and rerun the simulation.', 'Error Dialog');
    return;
end
    
switch RFIGen_index
    case (1)
        % Generate Synthetic RFI Data
        
        RFIFit_MCA      = get(handles.RFIFit_MCA,'Value');
        RFIFit_SAS      = get(handles.RFIFit_SAS,'Value');
        RFIFit_Gaussian = get(handles.RFIFit_Gaussian,'Value');
        
        if (RFIFit_MCA == 1)
            MCA_A       = str2double(get(handles.MCA_A, 'String'));
            MCA_Gamma   = str2double(get(handles.MCA_Gamma, 'String'));
            MCA_SigmaSq = str2double(get(handles.MCA_SigmaSq, 'String'));
            
            noise_data = sqrt(MCA_SigmaSq) .* RFI_MakeDataClassA (MCA_A, MCA_Gamma, NTerms_MCA, RFIFit_NSymbols);
            noise_data = noise_data(:);
            
        end
        
        if (RFIFit_SAS == 1)
            SAS_CharExp = str2double(get(handles.SAS_CharExp, 'String'));
            SAS_Disper  = str2double(get(handles.SAS_Disper, 'String'));
            
            noise_data = RFI_MakeDataAlphaStable(SAS_CharExp, SAS_Disper, 0, RFIFit_NSymbols);
            noise_data = noise_data(:);
        end
        
        if (RFIFit_Gaussian == 1)
            Gaussian_SigmaSq = str2double(get(handles.Gaussian_SigmaSq, 'String'));
            
            noise_data =  sqrt(Gaussian_SigmaSq).* randn(RFIFit_NSymbols,1);
        end
        
        
    case (2)
        % Measurement Data Set
        
        filename    = get(handles.Filename,'String');
        F_Format    = get(handles.FileFormat,'Value');
        
        % Open File and Read Data
        fid = fopen(filename,'r');
        
        % Check if file is readable
        if (fid == -1)
            errordlg('Input file does not exist or is not readable.','Irrational Settings','modal')
            return;
        end;
        
        % Read Data
        switch F_Format
            case (1)
                % Real Only
                format_str = repmat('%f',1, 1);
                noise_data = cell2mat(textscan(fid,format_str, RFIFit_NSymbols));
            case (2)
                % Real + j * Imaginary;
                format_str = repmat('%f',1, 2);
                noise_data = cell2mat(textscan(fid,format_str, RFIFit_NSymbols));
            case (3)
                % Envelope Data;
                format_str = repmat('%f',1, 1);
                noise_data = cell2mat(textscan(fid,format_str, RFIFit_NSymbols));
        end
        fclose (fid);
end



% Statistical Modeling of RFI
% -------------------------------------------------------------------------

% Center the data
noise_data = noise_data - repmat(mean(noise_data), RFIFit_NSymbols, 1);

if (RFIGen_index == 2)
    CurrResults = get(handles.Results, 'String');
    set(handles.Results, 'String', strvcat(CurrResults,'Fitting Measured Data to Statistical Models...'));
    drawnow;
end


% Generating Envelope and Real signals
% -------------------------------------------------------------------------
if (RFIGen_index == 2)
    % Measured Data
    F_Format    = get(handles.FileFormat,'Value');
else
    % Synthetic Data
    F_Format    = 1;
end

switch F_Format
    case (1)
        % Real ( I or Q)
        noise_data_env  = abs(hilbert(noise_data));
        noise_data_real = noise_data;
    case (2)
        % I + j Q
        noise_data_env  = sqrt(sum(noise_data.^2,2));
        noise_data_real = noise_data(:,1);                               % Considering only In-phase data to do parameter estimation etc. Assumption is that I and Q have the same statistics
    case (3)
        % Envelope Data
        noise_data_env  = noise_data;
        noise_data_real = noise_data.*(cos(2*pi*(rand(size(noise_data)) - 0.5)));
end


% Parameter Estimation
% -------------------------------------------------------------------------
% Performed if a) Measured Data + Statistical Model selected, or b) If
% a Rx is selected that requires the estimated parameters.

if (RFIFit_MCA  || RxBayesian )
    % Uses envelope data to estimate parameters
    MCA_SigmaSq_Est         = mean(noise_data_real.^2);
    
    [MCA_A_Est MCA_K_Est]   = RFI_EstMethodofMoments(noise_data_env);
    MCA_Gamma_Est           = MCA_K_Est / MCA_A_Est;
    
    % Result Update
    if (RFIGen_index == 2)
        
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, ' ','Estimated Parameters for Middleton Class A Model', '------------------------------------------------'));
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('A  = ', num2str(MCA_A_Est)), strcat('Gamma  = ', num2str(MCA_Gamma_Est)), strcat('Sigma_Sq  = ', num2str(MCA_SigmaSq_Est))));
        drawnow;
    end
end

% Symmetric Alpha Stable Model
if (RFIFit_SAS  || RxMyriad )
    % Uses real data for estimating parameters
    
    % noise_data_real might be modified during estimating parameters. Hence, we
    % save a copy and restore it later
    noise_data_real_saved = noise_data_real;
    
    % Localization parameter
    SAS_Localization_Est = RFI_EstAlphaS_Localization(noise_data_real);
    
    % Characteristic Exponential estimate
    L       = RFIFit_NSymbols/SAS_K;        % # of sub-signals of size K each
    inds    = find(noise_data_real - SAS_Localization_Est == 0);
    noise_data_real(inds)   = (-1)^(round(rand))*VALUESMALL + SAS_Localization_Est;
    SAS_CharExp_Est         = RFI_EstAlphaS_Alpha(noise_data_real, L, SAS_Localization_Est);
    if (SAS_CharExp_Est > 2)
        SAS_CharExp_Est = 2;
    end
    
    % Dispersion
    SAS_Dispersion_Est      = RFI_EstAlphaS_Dispersion(noise_data_real, SAS_CharExp_Est, SAS_Localization_Est);
    
    % Restore noise_data_real
    noise_data_real = noise_data_real_saved;
    clear noise_data_real_saved;
    
    % Result Update
    if (RFIGen_index == 2)
        
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, ' ','Estimated Parameters for Symmetric Alpha Stable Model', '------------------------------------------------'));
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('Location  = ', num2str(SAS_Localization_Est)), strcat('CharExp  = ', num2str(SAS_CharExp_Est)), strcat('Dispersion  = ', num2str(SAS_Dispersion_Est))));
        drawnow;
    end
    % Remove mean/median and make it centered (for PDF estimation)
    % noise_data_real = noise_data_real - SAS_Localization_Est;
end

% Gaussian Model
if (RFIFit_Gaussian == 1)
    % Uses real data for estimating parameters
    
    Gaussian_Mean_Est       = mean(noise_data_real);
    Gaussian_SigmaSq_Est    = moment(noise_data_real,2);
    
    % Result Update
    if (RFIGen_index == 2)
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, ' ', 'Estimated Parameters for Gaussian Model', '------------------------------------------------'));
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('Mean  = ', num2str(Gaussian_Mean_Est)), strcat('Variance  = ', num2str(Gaussian_SigmaSq_Est))));
        drawnow;
    end
    % Remove mean and make it centered (for PDF estimation etc)
    % noise_data_real = noise_data_real - Gaussian_Mean_Est;
end


% Flag Error if Estimated parameters are invalid (e.g. negative Gamma)
% -------------------------------------------------------------------------
ErrFlag = 0;
if (RFIFit_MCA || RxBayesian)
    if (MCA_Gamma_Est < 0)
        ErrFlag = 1;
    end
end

if (ErrFlag == 1)
    errordlg('One (or more) of the estimated parameters are incorrect and cause problems in statistical fitting. Please rerun the simulation.', 'Error Dialog');
    return;
end

if (RFIGen_index == 2)
    
    % Evaluating accuracy of Fit
    % -------------------------------------------------------------------------
    
    % Probability Density Functions
    % - Real data, In-phase only for complex data
    
    % Status Update
    CurrStatus = get(handles.Results, 'String');
    set(handles.Results, 'String', strvcat(CurrStatus, 'Estimating Densities and Evaluating Accuracy of Fit...')); drawnow;
    
    XRange = linspace(-RFIFit_xmax, RFIFit_xmax, RFIFit_xres);
    % Result Update
    CurrResults = get(handles.Results, 'String');
    set(handles.Results, 'String', strvcat(CurrResults, ' ', 'KL Divergence', '------------------------------------------------'));
    
    inds   = [1];
    s      = cell(1,4);
    h      = zeros(1,4);
    
    figure;
    % Empirical
    PDF_Empirical   = ksdensity(noise_data_real, XRange);
    h(1)            = plot(XRange, PDF_Empirical);
    hold on;
    
    % Middleton Class A
    if (RFIFit_MCA)
        PDF_MCA     = RFI_MakePDFClassA (XRange(:)./sqrt(MCA_SigmaSq_Est), MCA_A_Est, MCA_Gamma_Est, NTerms_MCA)./sqrt(MCA_SigmaSq_Est); 
        PDF_MCA     = PDF_MCA.';
        h(2)        = plot(XRange, PDF_MCA,'m'); hold on;
        inds        = [inds 2];
        
        KLD_MCA     = RFI_CalcKLDiver(PDF_Empirical, PDF_MCA, XRange.');
        % Result Update
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('Middleton Class A Model        :    ', num2str(KLD_MCA))));
        drawnow;
    end
    
    % Symmetric Alpha Stable
    if (RFIFit_SAS)
        noise_train     = RFI_MakeDataAlphaStable(SAS_CharExp_Est, SAS_Dispersion_Est, SAS_Localization_Est, NTrainSymbols);
        PDF_SAS         = ksdensity(noise_train, XRange);
        h(3)            = plot(XRange, PDF_SAS,'r');
        inds            = [inds 3];
        
        KLD_SAS         = RFI_CalcKLDiver(PDF_Empirical, PDF_SAS, XRange.');
        % Result Update
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('Symmetric Alpha Stable Model    :    ', num2str(KLD_SAS))));
        drawnow;
        
    end
    
    % Gaussian
    if (RFIFit_Gaussian)
        PDF_Gaussian    = normpdf(XRange, Gaussian_Mean_Est, sqrt(Gaussian_SigmaSq_Est));
        h(4)            = plot(XRange, PDF_Gaussian,'g');
        inds            = [inds 4];
        
        KLD_Gaussian    = RFI_CalcKLDiver(PDF_Empirical, PDF_Gaussian, XRange.');
        % Result Update
        CurrResults = get(handles.Results, 'String');
        set(handles.Results, 'String', strvcat(CurrResults, strcat('Gaussian Model                  :    ', num2str(KLD_Gaussian))));
        drawnow;
    end
    
    s{1} = 'Empirical';
    s{2} = 'Middleton Class A';
    s{3} = 'Symmetric Alpha Stable';
    s{4} = 'Gaussian';
    
    legend(h(inds),s(inds));
    xlabel('Centered amplitude'); ylabel('Probability density function'); title('Probability Density Function');
    
    clear PDF_Empirical PDF_MCA PDF_SAS PDF_Gaussian;
    
    
    % Tail Probabilities
    % -------------------------------------------------------------------------
    
    % Status Update
    CurrStatus = get(handles.Results, 'String');
    set(handles.Results, 'String', strvcat(CurrStatus, 'Calculating Tail Probabilities...')); drawnow;
    
    
    inds   = [1];
    s      = cell(1,4);
    h      = zeros(1,4);
    
    % Generate XRange so that there are more values close to the tails.
    % Sqrt function has that convex form required
    XRange = RFIFit_xmax * sqrt(linspace(1/RFIFit_xmax/NPointsTailProb, 1, NPointsTailProb));
    
    % Empirical
    Empirical_CCDF = zeros(1,length(XRange));
    for i = 1:length(XRange)
        Empirical_CCDF(i) = length(find(noise_data_real > XRange(i)))/length(noise_data_real);
    end
    figure;
    h(1) = semilogy(XRange, Empirical_CCDF);
    hold on;
    
    % Middleton Class A
    if (RFIFit_MCA)
        MCA_CCDF = zeros(size(XRange));
        for m = 0:NTerms_MCA;
            v = MCA_SigmaSq_Est * (m / MCA_A_Est + MCA_Gamma_Est) / (1 + MCA_Gamma_Est);
            MCA_CCDF = MCA_CCDF + exp (-MCA_A_Est) * MCA_A_Est.^m / factorial(m) * 1/2 * erfc(XRange*1/sqrt(2*v));
        end
        
        h(2) = semilogy(XRange, MCA_CCDF,'m');
        inds = [inds 2];
    end
    
    % Symmetric Alpha Stable
    if (RFIFit_SAS)
        if (SAS_CharExp_Est == 2)
            SAS_CCDF = 1/2*erfc(XRange.*1/(sqrt(2*SAS_Dispersion_Est)*sqrt(2)));
        else
            if (SAS_CharExp_Est == 1)
                C_alpha = 2/pi;
            else
                C_alpha = (1-SAS_CharExp_Est)/(gamma(2-SAS_CharExp_Est)*cos(pi*SAS_CharExp_Est/2));
                
            end
            SAS_CCDF = XRange.^(-SAS_CharExp_Est) * SAS_Dispersion_Est^SAS_CharExp_Est * C_alpha / 2 ;
        end
        
        h(3) = semilogy(XRange, SAS_CCDF, 'r');
        inds = [inds 3];
    end
    
    % Gaussian
    if (RFIFit_Gaussian)
        Gaussian_CCDF = 1/2*erfc(XRange.*1/(sqrt(Gaussian_SigmaSq_Est)*sqrt(2)));
        
        h(4) = semilogy(XRange, Gaussian_CCDF,'g');
        inds = [inds 4];
    end
    
    s{1} = 'Empirical';
    s{2} = 'Middleton Class A';
    s{3} = 'Symmetric Alpha Stable';
    s{4} = 'Gaussian';
    
    legend(h(inds),s(inds));
    xlabel('Threshold Amplitude (a)'); ylabel('Tail Probabilities [P(X > a)]'); title('Tail Probability')
    
end


% Communication Performance of Receivers in Presence of RFI
% -------------------------------------------------------------------------
% Result Update
CurrResults = get(handles.Results, 'String');
set(handles.Results, 'String', strvcat(CurrResults, ' ', 'Starting simulations for communication performance of receivers...'));
drawnow;

SNR_vec     = linspace(SNR_min, SNR_max, SNR_step);

if (RxCorrelation)
    SErr_RxCorrelation  = zeros(size(SNR_vec));
end
if (RxBayesian)
    SErr_RxBayesian     = zeros(size(SNR_vec));
end
if (RxMyriad)
    SErr_RxMyriad       = zeros(size(SNR_vec));
end

% Sqrt Raised Cosing Pulse Shape Design
RCP     =   rcosine(1, RCP_ratio, 'sqrt', RCP_r, RCP_delay);
RCP     =   RCP (1: length(RCP) - 1);

% Calculate Es
x_train = pammod(0:MPAM-1,MPAM);
Es_normFactor = mean(x_train.^2);
%
EsFactorUpsampling  = sum(RCP.^2) / RCP_ratio;
Prop_Delay          = RCP_ratio * RCP_delay;
SamplesPerSymbol    = 2 * Prop_Delay;
SymbolUpFactor      = 2 * RCP_delay;

% Open Measured Data File
if (RFIGen_index == 2)
    fid = fopen(filename,'r');
end
switch F_Format
    case (1)
        % Real Only
        format_str = repmat('%f',1, 1);
    case (2)
        % Real + j * Imaginary;
        format_str = repmat('%f',1, 2);
    case (3)
        % Envelope Data;
        format_str = repmat('%f',1, 1);
end

% Simulate Receivers
% -------------------------------------------------------------------------
NIters =  ceil(NSymbols / MaxSymbolsPerIter);

for i = 1:length(SNR_vec)
    
    SNR_dB = SNR_vec(i);
    SNR = 10^(SNR_dB/10);
    
    % Result Update
    CurrResults = get(handles.Results, 'String');
    set(handles.Results, 'String', strvcat(CurrResults, strcat('Running for SNR = ', num2str(SNR_dB),'dB')));
    drawnow;
    
    for Iters = 1: NIters
        NSymbolsThisIter = min((NSymbols - (Iters - 1) * MaxSymbolsPerIter), MaxSymbolsPerIter);
        
        % Transmitter
        % -------------------------------------------------------------------------
        
        % Generate Random symbols
        x_symbols = randint(1, NSymbolsThisIter, MPAM);
        
        % Modulate
        x_modulated = pammod(x_symbols, MPAM);                      % x_modulated has Es_normFactor energy
        
        % Pulse Shape Filter
        x_tx = rcosflt(x_modulated, 1, SymbolUpFactor * RCP_ratio, 'filter', RCP);
        
        % Generate noise
        switch(RFIGen_index)
            case (1)
                % ---- Synthetic Data
                % Noise generated using true noise parameters.
                % Variance / Dispersion adjusted according to SNR
                if (RFIFit_MCA)
                    % Middleton Class A
                    noise   = RFI_MakeDataClassA (MCA_A, MCA_Gamma, NTerms_MCA, length(x_tx) );             % Variance = 1
                    noise   = noise.*sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor);     % To have Signal-to-noise ratio of 'SNR'
                    noise   = noise(:);
                    
                    if (RxMyriad)
                        Rx_SAS_Dispersion_Est   = ((sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor))^SAS_CharExp_Est)  * ((sqrt(1/MCA_SigmaSq))^SAS_CharExp_Est) * SAS_Dispersion_Est;
                    end
                end
                
                if (RFIFit_SAS)
                    % Symmetric Alpha Stable
                    noise_dispersion =  1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor;        % Dispersion instead of variance
                    noise   =  RFI_MakeDataAlphaStable(SAS_CharExp, noise_dispersion, 0, length(x_tx));
                    noise   = noise(:);
                    
                    if (RxMyriad)
                        Rx_SAS_Dispersion_Est   = (1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor) ;
                    end
                end
                
                if (RFIFit_Gaussian)
                    % Gaussian
                    noise  = randn(1, length(x_tx));                                                        % Mean = 0, Variance 1
                    noise  = noise.*sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor);      % To have Signal-to-noise ratio of 'SNR'
                    noise   = noise(:);
                    
                    if (RxMyriad)
                        Rx_SAS_Dispersion_Est   = ((sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor))^SAS_CharExp_Est)  * ((sqrt(1/Gaussian_SigmaSq))^SAS_CharExp_Est) * SAS_Dispersion_Est;
                    end
                end
                
            case (2)
                % ---- Measured Data
                % Read Data
                noise       = cell2mat(textscan(fid, format_str, length(x_tx)));
                
                if (feof(fid))
                    % File ended while reading it
                    frewind(fid);
                    noise       = cell2mat(textscan(fid,format_str, length(x_tx)));
                    if (feof(fid))
                        % If again eof happened, then the file does not have
                        % NSymbols of data
                        errordlg('Measured data file does not have enough data. Please reduce NSymbols being simulated.', 'Error Dialog');
                        return;
                    end
                end
                if (F_Format == 3)
                    % Envelope data
                    noise = noise.*(cos(2*pi*(rand(size(noise)) - 0.5)));       % Generate real data (for BPSK)
                else
                    noise = noise(:,1);                                         % Just use the real data (for BPSK)
                end
                
                noise           = noise(randperm(length(noise)));
                noise           = noise - mean(noise);                                                        % Center the data
                noiseNormFactor = mean(noise.^2);
                noise           = noise ./ sqrt(mean(noise.^2));                                                % Normalize noise variance to 1
                noise           = sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor) * noise;    % Signal-to-noise ratio of 'SNR'
                
                if (RxMyriad)
                    Rx_SAS_Dispersion_Est   = ((sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor))^SAS_CharExp_Est)  * ((sqrt(1/noiseNormFactor))^SAS_CharExp_Est) * SAS_Dispersion_Est;
                end
        end
        
        % Channel
        % ---------------------------------------------------------------------
        x_rx = x_tx +  noise;
        
        
        % Receivers
        % -------------------------------------------------------------------------
        if (RxCorrelation)
            % Correlation detection
            [dem_bits err_rate]         = RFI_Matched_Filter(x_rx, x_modulated, SamplesPerSymbol, Prop_Delay, RCP_ratio, RCP, MPAM);
            SErr_RxCorrelation(i)       = SErr_RxCorrelation(i) + err_rate * NSymbolsThisIter;
        end;
        
        if (RxBayesian)
            % Bayesian detection
            PDFfhandle = @RFI_MakePDFClassA;
            [dem_bits err_rate]         = RFI_detect_opt(x_rx, x_modulated, SamplesPerSymbol, RCP, 10*log10(SNR / Es_normFactor / EsFactorUpsampling * SymbolUpFactor), PDFfhandle, MCA_A_Est, MCA_Gamma_Est, NTerms_MCA);
            SErr_RxBayesian(i)          = SErr_RxBayesian(i) + err_rate * NSymbolsThisIter;
        end
        
        if (RxMyriad)
            % Myriad prefiltering
            % Rx_SAS_Dispersion_Est   = ((sqrt(1/SNR * Es_normFactor * EsFactorUpsampling / SymbolUpFactor))^SAS_CharExp_Est)  * SAS_Dispersion_Est;
            [dem_bits err_rate]     = RFI_detect_myriad(x_rx, x_modulated, SamplesPerSymbol, SAS_CharExp_Est, Rx_SAS_Dispersion_Est, 2, RCP_delay, RCP_ratio, RCP, MPAM);
            SErr_RxMyriad(i)        = SErr_RxMyriad(i) + err_rate * NSymbolsThisIter;
        end
        
    end
end

figure;
%hold on;

if (RxCorrelation)
    semilogy(SNR_vec, SErr_RxCorrelation / NSymbols, 'Displayname', 'Correlation Receiver');
    hold on;
end;

if (RxBayesian)
    semilogy(SNR_vec, SErr_RxBayesian / NSymbols, 'g', 'Displayname', 'Bayesian Detection');
    hold on;
end;

if (RxMyriad)
    semilogy(SNR_vec, SErr_RxMyriad / NSymbols, 'r', 'Displayname', 'Selection Myriad PreFiltering');
    hold on;
end;

xlim([SNR_min SNR_max]);
xlabel('Signal to Noise Ratio (SNR) [in dB]'); ylabel('Symbol Error Rate');
title('Communication Performance');

legend('show');

% Result Update
CurrResults = get(handles.Results, 'String');
set(handles.Results, 'String', strvcat(CurrResults, 'Simulation Ended.'));
drawnow;


% Re-enable GUI to be chosen as a figure
set(handles.figure1, 'HandleVisibility','on');
