function varargout = RFI_OFDMDemo(varargin)
% RFI_OFDMDEMO M-file for RFI_OFDMDemo.fig
%      RFI_OFDMDEMO, by itself, creates a new RFI_OFDMDEMO or raises the existing
%      singleton*.
%
%      H = RFI_OFDMDEMO returns the handle to a new RFI_OFDMDEMO or the handle to
%      the existing singleton*.
%
%      RFI_OFDMDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RFI_OFDMDEMO.M with the given input arguments.
%
%      RFI_OFDMDEMO('Property','Value',...) creates a new RFI_OFDMDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before RFI_OFDMDemo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to RFI_OFDMDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help RFI_OFDMDemo

% Last Modified by GUIDE v2.5 13-Dec-2010 09:51:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @RFI_OFDMDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @RFI_OFDMDemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before RFI_OFDMDemo is made visible.
function RFI_OFDMDemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to RFI_OFDMDemo (see VARARGIN)

% Choose default command line output for RFI_OFDMDemo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes RFI_OFDMDemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = RFI_OFDMDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in start.
function start_Callback(hObject, eventdata, handles)
% hObject    handle to start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.simulationStatus, 'String', 'Simulation Started...');
%Temporary button disbale functionality
set(hObject,'enable','inactive');
set(hObject, 'String', 'Running...');drawnow;

% Simulation Settings
% ---------------------
NFFT        = str2double(get(handles.nSubCarriers, 'String')); % number of subcarriers (also the number of decomposed channels channels) and also the block code size
NVecOFDMSym = str2double(get(handles.nOFDMSymbols, 'String'));


%Modulation Setup
M           = str2double(get(handles.M, 'String')); %M-QAM
NR = 1; NT = 1; % not used currently (for future versions)
SymbolOrder = 'gray'; %'binary' 
QAMmod      = modem.qammod('M', M, 'SymbolOrder', SymbolOrder);
SymScale    = modnorm(QAMmod.constellation,'avpow',1);
QAMdemod    = modem.qamdemod('M', M, 'SymbolOrder', SymbolOrder);

% SNR = Es/N0 this has to be normalized by the number of transmit antennas
% which is done in the noise variance here
SNRlowerLimit   = str2double(get(handles.snrLowerLimit, 'String'));
SNRupperLimit   = str2double(get(handles.snrUpperLimit, 'String'));
stepSize        = str2double(get(handles.stepSize, 'String'));
SNRvector       = SNRlowerLimit:stepSize:SNRupperLimit; %dB;
%% Noise Settings
noise_type = 'GM'; %'classA'; %'gaussian'; ;

eval(['p=' get(handles.mixingVector,'String') ';']);
eval(['SIGMAs=' get(handles.sigmas, 'String') ';']);
SIGMAs      = SIGMAs/(p*SIGMAs'); %  normalize the second moment to 1
%numMix      =   length(p);
%SIGMA       =   reshape((repmat(SIGMAs(:)/2,1,2*NR))',1,2*NR,[]);
%noiseDistr  = gmdistribution(zeros(numMix, 2*NR), SIGMA, p);

% Simulation
%Preallocate the Number of vector symbol errors
NumVecSymErrsFFT        =   zeros(1,length(SNRvector)); % Regular OFDM
NumVecSymErrsTime       =   zeros(1,length(SNRvector)); % Single Carrier
NumVecSymErrsEstCSI     =   zeros(1,length(SNRvector)); % MMSE with CSI
NumVecSymErrsEstnoCSI   =   zeros(1,length(SNRvector)); % MMSE without CSI

for itSNR = 1:length(SNRvector)
    SNR = SNRvector(itSNR);
    currentStatus = get(handles.simulationStatus, 'String');
    set(handles.simulationStatus, 'String', strvcat(currentStatus, ['Running Simulations for SNR=' num2str(SNR)]));drawnow;
    
    %% Channel Generation
    for itSym = 1:NVecOFDMSym
                
        %% General Gaussian Mixture Generation
        NMixtures   = length(p);
        SigmaMat    = zeros(NMixtures, 2*NR, 2*NR);    % 2*NR since we have NR antennas and real-imaginary for each antenna.
        for MixIter = 1:NMixtures
            SigmaMat(MixIter, :, :) = SIGMAs(MixIter)/2 * eye(2*NR);
        end
        
        [unscaledNOISE_time, CSI]   =   RFI_MakeDataGMM (2*NR, zeros(NMixtures, 2*NR), SigmaMat, p.', NFFT);
        unscaledNOISE_time          =   (unscaledNOISE_time(:, 1:2:end) + 1i * unscaledNOISE_time(:, 2:2:end)).'; % Combine real and imaginary components to form a NR x NFFT matrix
        %[unscaledNOISE_time, CSI]   =   RFI_generateGMNoise(p,SIGMAs,NR,NFFT);              

        NOISE_time                  =   unscaledNOISE_time/realsqrt(10^(SNR/10)/NT);    % Time Domain Noise scaled to reflect SNR (NOISE = [N x T] matrix);
        NoiseTimeVec                =   NOISE_time(:);                                  % vectorize the noise = vec([NR,NFFT])
        
        %% Frequency Domain Transformations
        NOISE_FFT = 1/realsqrt(NFFT)*fft(NOISE_time, NFFT, 2); % transform the noise in the frequency domain [antenna x subcarrier]
        
        % Block Diagonalize the channel for faster multiplications
        NoiseFFTVec = NOISE_FFT(:); % block the noise correspondigly
        
        %% Generate Data for SM
        % -------------------------
        % generate symbols (for the mapping see 'Modulating Random Signals'
        % in the help) [transmit antennas x Block Size]
        Xsym        =   floor(M*rand(NT, NFFT)); %faster than "randint(N, NOFDMsym, M);" 
        X           =   SymScale * modulate(QAMmod, Xsym); % scale it to normalize the power to 1 ([NTxT] matrix)
        XIFFT       =   realsqrt(NFFT)*ifft(X, NFFT, 2); %OFDM coded symbols
        
        XVec        =   X(:);% get the block representation of the signal for transmission
        XIFFTVec    =   XIFFT(:); %vectorize the coded symbols vec([NT,NFFT])  
                
        %% Send Data through Channel using the Block Notation and detect
        % in block format for: 
        % ----------------------------------------------------------------
        
        % [(1) OFDM]
        YFFTVec                         =   XVec + NoiseFFTVec; 
        XFFThat                         =   demodulate(QAMdemod,reshape(YFFTVec, NT , NFFT)/SymScale); % in [receive antenna x subcarrier] format
        NumVecSymErrsFFT(itSNR)         =   NumVecSymErrsFFT(itSNR) + sum(Xsym~=XFFThat);%  vecsymerr(Xsym, XFFThat);
        % NOTE:  using sum(Xsym~=XFFThat) works only because we have a SISO
        % systems.

        % [(2) OFDM with CSI]
        YTimeVecEM                      =   XIFFTVec + NoiseTimeVec;
        UIFFThat                        =   RFI_EstimatewCSI(YTimeVecEM, CSI, p, SIGMAs, SNR, NR,0);
        Uhat                            =   1/realsqrt(NFFT)*fft(reshape(UIFFThat,NT, NFFT), NFFT ,2);
        XEMCSIhat                       =   demodulate(QAMdemod, Uhat/SymScale);
        NumVecSymErrsEstCSI(itSNR)      =   NumVecSymErrsEstCSI(itSNR) + sum(Xsym~=XEMCSIhat);%  vecsymerr(Xsym, XFFThat);
        % NOTE:  using sum(Xsym~=XFFThat) works only because we have a SISO
        % systems.
        
        % [(3) OFDM with without CSI]
        UIFFThatnoCSI                   =   RFI_EstimatewoCSI(YTimeVecEM, p, SIGMAs, SNR, NR);
        UhatnoCSI                       =   1/realsqrt(NFFT)*fft(reshape(UIFFThatnoCSI,NT, NFFT), NFFT ,2);
        XEMnoCSIhat                     =   demodulate(QAMdemod, UhatnoCSI/SymScale);
        NumVecSymErrsEstnoCSI(itSNR)    =   NumVecSymErrsEstnoCSI(itSNR) + sum(Xsym~=XEMnoCSIhat);%  vecsymerr(Xsym, XFFThat);
        % NOTE:  using sum(Xsym~=XFFThat) works only because we have a SISO
        % systems.
                         
        % [(4) in block format for SC]
        YTimeVec                        =   XVec + NoiseTimeVec; 
        XTimehat                        =   demodulate(QAMdemod,reshape(YTimeVec, NT , NFFT)/SymScale); % in [receive antenna x subcarrier] format
        NumVecSymErrsTime(itSNR)        =   NumVecSymErrsTime(itSNR) + sum(Xsym~=XTimehat);%vecsymerr(Xsym, XTimehat);
        % NOTE:  using sum(Xsym~=XFFThat) works only because we have a SISO
        % systems.
        
    end;
end;

VecSymErrRateFFT        =   NumVecSymErrsFFT/(NVecOFDMSym*NFFT); % this is the vector symbol error rate
VecSymErrRateTime       =   NumVecSymErrsTime/(NVecOFDMSym*NFFT); % this is the vector symbol error rate
VecSymErrRateEstCSI     =   NumVecSymErrsEstCSI/(NVecOFDMSym*NFFT);
VecSymErrRatenoCSI      =   NumVecSymErrsEstnoCSI/(NVecOFDMSym*NFFT);

% Plotting
figure;
semilogy(SNRvector,VecSymErrRateFFT, '-x',...
    SNRvector,VecSymErrRateTime, '-o', ...
    SNRvector,VecSymErrRateEstCSI, '-+', ...
    SNRvector, VecSymErrRatenoCSI, '-p'); 
legend('OFDM', 'Single Carrier', 'MMSE-OFDM (Perfect CSI)', 'MMSE-OFDM (No CSI)');

set(hObject,'enable','on');
set(hObject, 'String', 'Start Simulation'); drawnow; 
 currentStatus = get(handles.simulationStatus, 'String');
    set(handles.simulationStatus, 'String', strvcat(currentStatus, ['Simulation Done!']));drawnow;

function M_Callback(hObject, eventdata, handles)
% hObject    handle to M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M as text
%        str2double(get(hObject,'String')) returns contents of M as a double


% --- Executes during object creation, after setting all properties.
function M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function nSubCarriers_Callback(hObject, eventdata, handles)
% hObject    handle to nSubCarriers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nSubCarriers as text
%        str2double(get(hObject,'String')) returns contents of nSubCarriers as a double


% --- Executes during object creation, after setting all properties.
function nSubCarriers_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nSubCarriers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function nOFDMSymbols_Callback(hObject, eventdata, handles)
% hObject    handle to nOFDMSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nOFDMSymbols as text
%        str2double(get(hObject,'String')) returns contents of nOFDMSymbols as a double


% --- Executes during object creation, after setting all properties.
function nOFDMSymbols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nOFDMSymbols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function snrLowerLimit_Callback(hObject, eventdata, handles)
% hObject    handle to snrLowerLimit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of snrLowerLimit as text
%        str2double(get(hObject,'String')) returns contents of snrLowerLimit as a double


% --- Executes during object creation, after setting all properties.
function snrLowerLimit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to snrLowerLimit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function stepSize_Callback(hObject, eventdata, handles)
% hObject    handle to stepSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of stepSize as text
%        str2double(get(hObject,'String')) returns contents of stepSize as a double


% --- Executes during object creation, after setting all properties.
function stepSize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to stepSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function snrUpperLimit_Callback(hObject, eventdata, handles)
% hObject    handle to snrUpperLimit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of snrUpperLimit as text
%        str2double(get(hObject,'String')) returns contents of snrUpperLimit as a double


% --- Executes during object creation, after setting all properties.
function snrUpperLimit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to snrUpperLimit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in noiseType.
function noiseType_Callback(hObject, eventdata, handles)
% hObject    handle to noiseType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns noiseType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from noiseType


% --- Executes during object creation, after setting all properties.
function noiseType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to noiseType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function mixingVector_Callback(hObject, eventdata, handles)
% hObject    handle to mixingVector (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of mixingVector as text
%        str2double(get(hObject,'String')) returns contents of mixingVector as a double


% --- Executes during object creation, after setting all properties.
function mixingVector_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mixingVector (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function sigmas_Callback(hObject, eventdata, handles)
% hObject    handle to sigmas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of sigmas as text
%        str2double(get(hObject,'String')) returns contents of sigmas as a double


% --- Executes during object creation, after setting all properties.
function sigmas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sigmas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function simulationStatus_Callback(hObject, eventdata, handles)
% hObject    handle to simulationStatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of simulationStatus as text
%        str2double(get(hObject,'String')) returns contents of simulationStatus as a double


% --- Executes during object creation, after setting all properties.
function simulationStatus_CreateFcn(hObject, eventdata, handles)
% hObject    handle to simulationStatus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in clear.
function clear_Callback(hObject, eventdata, handles)
% hObject    handle to clear (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.simulationStatus, 'String', 'Idle.');
