function [ uhatvec ] = EstimatewoCSI(  y, p, SIGMAs, SNR, NR )
%ESTIMATEWOCSI This function generates the approximate MMSE estimate of u
%given y without CSI for the SISO case
%
% y is the received signal in the form y = Fx + 1/SNR*n
% p is the probability vector of the GM
% SIGMAs are the sigmas of the GM distribution
% SNR 
% NR number of received antennas (should be 1)
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar (nassar@ece.utexas.edu)
%
% Reference:J. Haring, Error tolerant communication over the compound channel,
% Ph.D. dissertation, Aachen, Germany: Shaker-Verlag, 2002.
%


SIGMAs = SIGMAs/(p*SIGMAs')/10^(SNR/10); %scale the noise power according to the SNR
signalScale = 1; %signal power is unity given the structure of y

numMixComp = length(p); %number of GM components
temp1 = repmat(abs(y(:)).^2,1,numMixComp);
temp2 = (repmat(SIGMAs(:)+signalScale,1,length(y)))';
c1 = 1./temp2;
c2 = c1.^2;
tempEXP = exp(- temp1.*c1);
num = p * (signalScale*c2.*tempEXP)';
denom = p * (c1.*tempEXP)';
alpha = (num./denom)';
y = (reshape(y, NR, [])).';
uhat = repmat(alpha,1,NR).*y;
uhatvec = uhat(:);

end

