function [ nonl_out ] = RFI_GMnonlinearity( x,  SNR, p, Sigmas, N)
%RFI_NONLINEARITY implements the nonlinearity found in the small signal
%approximation
% Inputs:   x                   - sample data matrix where the nonlinearity
%                                 is to be evaluated
%           p                   - mixing probability vector
%           Sigmas              - sigmas of the GMM
%           N                   - number of normal mixtures
%           SNR                 - SNR
%        
% Outputs:  nonl_out            - value of non-linearity
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

%x=x/sqrt(1 + 10^(-SNR/10));
stdx = x(:);
Sigmas = Sigmas*10^(-SNR/10);

term1 = RFI_MakePDFGMM(stdx, zeros(length(p),1), Sigmas(:), p(:));

tempvar1 = repmat((1./Sigmas(:)).^(1.5), 1, length(stdx)) .* ...
    exp(-repmat(stdx.', N, 1)./repmat(Sigmas(:), 1, length(stdx))); %temporary variable for calculations
term2 = stdx .* ((p*tempvar1).');

nonl_out = reshape(- term2./term1, size(x,1), []);