function [ uhatvec ] = RFI_EstimatewCSI( yvec, CSI, p, SIGMAs, SNR , NR, biasIt)
%ESTIMATEWCSI This function generates the approximate MMSE estimate of u
%given y  (in vector format) and CSI
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar (nassar@ece.utexas.edu)
%
% Reference:J. Haring, Error tolerant communication over the compound channel,
% Ph.D. dissertation, Aachen, Germany: Shaker-Verlag, 2002.
%
%
% Note: The implementation of alpha and beta calculations are independent
% of whether the noise or the signal are scaled according to SNR (not the case 
% if we don't have CSI)

SIGMAs = SIGMAs/(p*SIGMAs'); %normalize the power to unit variance
signalScale = 10^(SNR/10);
alpha = signalScale./(signalScale+SIGMAs(CSI));
beta = p*(signalScale./(signalScale+SIGMAs(:))); %bias calculations
y = (reshape(yvec, NR, [])).';
if biasIt
    uhat = (repmat(alpha(:),1, NR).*y).'; % the MMSE of IFFTx
else
    uhat = (repmat(alpha(:),1, NR).*y/beta).'; % the MMSE of IFFTx
end
    
uhatvec = uhat(:);

end
