function bits = RFI_bi_detector_appx( s1 , s2, x, SNR, nonLinearfhandle, opt ) % A, Gamma, N_T )
%bits = RFI_bi_detector_appx( s1 , s2, x, A, Gamma, N_T, SNR )
%This function chooses the most likelihood hypothesis between H1 and H2
%corresponding to s1 and s2, given that the additive noise follows Class A
%Middleton Model.
% Inputs:   
%           s1    - vector representing the transmitted signal under hypothesis
%                   H1 (bit 1 in this case)
%           s2    - vector representing the transmitted signal under hypothesis
%                   H2 (bit 0 in this case)
%           x     - matrix representing the received signal (each column represent
%                   a single modulated bit, that is given a i-th column it
%                   represents the i-th bit pulse shaped signal)
%           SNR   -  SNR
%           nonLinearfhandle - is the function handle to the nonlinearity
%           needed to preprocess the signal
%           opt   - are the options to the nonlinearity
%               in case of class A: [A , Gamma, N_T]
%               in case of GM: [p, sigmas, N]
% Outputs:  bits       - a vector containing the detected bit stream
%
% Reference:
% [1] A. Spaulding and D. Middleton, Optimum reception in an impulsive
%     interference environment-part I: Coherent detection, IEEE Transactions on 
%     Communications, vol. 25, no. 9, pp. 910923, 1977
%
% Copyright (c) The University of Texas
% Please see the file Copyright.txt that came with this release for details
% Programmers: Marcel Nassar   (nassar@ece.utexas.edu)

s1=s1(:);
s2=s2(:);

%[Ni M]=size(x); % number of samples

diff_s = s2-s1;
%N = RFI_nonlinearity( x, A, Gamma, N_T, SNR );
N = nonLinearfhandle( x, SNR,  opt{1}, opt{2}, opt{3});
prod = diff_s' * N;

[c sign_index] = max(abs(s1)); %obtain the index of the maximum magnitude of the raised cosine
                              % this maximum indicates the sign of the
                               % waveform s1, s2 has the same index
bits = (prod > 0)*sign(s1(sign_index)) + (prod <= 0)*sign(s2(sign_index)); %detect the bits