// PLLSim.h: interface for the PLLSim class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PLLSIM_H__D13DAEE2_769D_11D3_AD03_0080C8876A90__INCLUDED_)
#define AFX_PLLSIM_H__D13DAEE2_769D_11D3_AD03_0080C8876A90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <fstream.h>

class InterpolateArray
{
public:
	InterpolateArray() { array=NULL; xx=NULL; yy=NULL; size=0; }
	~InterpolateArray() { if (array!=NULL) delete [] array;
		if (xx!=NULL) delete [] xx; if (yy!=NULL) delete [] yy; }

	void load(char* filename,double s,double mx);
	void load(char* filename);
	double getY(double x);
	void print();

	double* array;
	double* xx;
	double* yy;
	double step,max,min;
	int size;
};

class Divider
{
public:
	Divider();
	Divider(int d);
	~Divider();

	void setup(int d);
	double step(double e);
	void print() { printf("Divider: div_ratio = %2d\n",div); }

	double e_last;
	int div;
};

class ChargePump
{
public:
	ChargePump();
	~ChargePump();

	void setup(char* filename);
	double step(double p);
	void print() { printf("Charge Pump Table (seconds vs. Amps):\n"); oI.print(); }

	InterpolateArray oI;
};

class Filter
{
public:
	Filter();
	~Filter();

	void setup(double vv,double v,double c);
	double step(double p,double i);
	void print() { printf("Filter: Cap=%.6g pF\n",dCap*1e12); }

	double dVolts,dCap,vdd;
};

class VCO
{
public:
	VCO();
	~VCO();

	void setup(char* filename);
	double step(double v,double i);
	void print() { printf("VCO Range Table (volts vs. Hz):\n"); oRange.print();
			printf("VCO: current_gain=%.6g Hz/Amp\n",dCurrentGain); }
	int iCycle;
	double dTime,dPeriod,dPeriodNom,dCurrentGain;
	InterpolateArray oRange;
};

class PulseGen
{
public:
	PulseGen();
	~PulseGen();

	void setup(double period);
	double step();
	void print();
	void doModulation(char* modfile);

	double dPeriod,dPeriodNom,dTime,dDeltaPeriod,dRate,dDeltaPhase;
	int iCycle,bSSC;
	InterpolateArray oSSC;
	
};

class PLLSim;
class PFD
{
public:
	PFD();
	~PFD();

	double step(PLLSim* pll);

	double e1,e2;
};

class PLLSim
{
public:
	PLLSim();
	virtual ~PLLSim();

	void go(int num_steps,char *simfile,char* outfile);
	void stepRef();
	void stepFeedback();

	double ref,feedback,cntl_v,cntl_i,vco_out;
	int iIterations,iStartOutput;

	VCO vco;
	PulseGen pg;
	PFD pfd;
	ChargePump cp;
	Filter filt;
	Divider div;

};

#endif // !defined(AFX_PLLSIM_H__D13DAEE2_769D_11D3_AD03_0080C8876A90__INCLUDED_)
