// FFT.c
// Runs on any processor
// Jonathan Valvano
// July 13, 2020

/* This example accompanies the book
   "Embedded Systems: Introduction to Robotics,
   Jonathan W. Valvano, ISBN: 9781074544300, copyright (c) 2020
 For more information about my classes, my research, and my books, see
 http://users.ece.utexas.edu/~valvano/

Simplified BSD License (FreeBSD License)
Copyright (c) 2020, Jonathan Valvano, All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are
those of the authors and should not be interpreted as representing official
policies, either expressed or implied, of the FreeBSD Project.
*/
/* Factored discrete Fourier transform, or FFT, and its inverse iFFT */
// Derived from 
// http://www.math.wustl.edu/~victor/mfmm/index.html#mfmm-software
// Mathematics for Multimedia, ISBN 978-0-8176-4879-4, was formerly managed by Elsevier/Academic Press.

#include <math.h>
#include <stdlib.h>
#include "../inc/FFT.h"

const float cosTab[1024][11]={
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, 0.99998118, 0.99999529},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, 0.99998118},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, 0.99983058, 0.99995764},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, 0.99952942, 0.99988235},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, 0.99983058},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, 0.99907773, 0.99976941},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, 0.99847558, 0.99961882},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, 0.99952942},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, 0.99772307, 0.99943060},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, 0.99682030, 0.99920476},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, 0.99907773},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, 0.99576741, 0.99894129},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, 0.99456457, 0.99864022},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, 0.99847558},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, 0.99321195, 0.99830154},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, 0.99170975, 0.99792529},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, 0.99772307},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, 0.99005821, 0.99751146},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, 0.98825757, 0.99706007},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, 0.99682030},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, 0.98630810, 0.99657115},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, 0.98421009, 0.99604470},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, 0.99576741},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, 0.98196387, 0.99548076},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, 0.97956977, 0.99487933},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, 0.99456457},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, 0.97702814, 0.99424045},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, 0.97433938, 0.99356414},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, 0.99321195},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, 0.97150389, 0.99285041},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, 0.96852209, 0.99209931},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, 0.99170975},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, 0.96539444, 0.99131086},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, 0.96212140, 0.99048508},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, 0.99005821},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, 0.95870347, 0.98962202},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, 0.95514117, 0.98872169},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, 0.98825757},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, 0.95143502, 0.98778414},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, 0.94758559, 0.98680940},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, 0.98630810},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, 0.94359346, 0.98579751},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, 0.93945922, 0.98474850},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, 0.98421009},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, 0.93518351, 0.98366242},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, 0.93076696, 0.98253930},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, 0.98196387},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, 0.92621024, 0.98137919},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, 0.92151404, 0.98018214},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, 0.97956977},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, 0.91667906, 0.97894818},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, 0.91170603, 0.97767736},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, 0.97702814},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, 0.90659570, 0.97636973},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, 0.90134885, 0.97502535},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, 0.97433938},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, 0.89596625, 0.97364425},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, 0.89044872, 0.97222650},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, 0.97150389},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, 0.88479710, 0.97077214},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, 0.87901223, 0.96928124},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, 0.96852209},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, 0.87309498, 0.96775384},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, 0.86704625, 0.96619000},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, 0.96539444},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, 0.86086694, 0.96458979},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, 0.85455799, 0.96295327},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, 0.96212140},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, 0.84812034, 0.96128049},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, 0.84155498, 0.95957151},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, 0.95870347},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, 0.83486287, 0.95782641},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, 0.82804505, 0.95604525},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, 0.95514117},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, 0.82110251, 0.95422810},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, 0.81403633, 0.95237501},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, 0.95143502},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, 0.80684755, 0.95048607},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, 0.79953727, 0.94856135},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, 0.94758559},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, 0.79210658, 0.94660091},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, 0.78455660, 0.94460484},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, 0.94359346},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, 0.77688847, 0.94257320},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, 0.76910334, 0.94050607},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, 0.93945922},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, 0.76120239, 0.93840353},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, 0.75318680, 0.93626567},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, 0.93518351},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, 0.74505779, 0.93409255},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, 0.73681657, 0.93188427},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, 0.93076696},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, 0.72846439, 0.92964090},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, 0.72000251, 0.92736253},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, 0.92621024},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, 0.71143220, 0.92504924},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, 0.70275474, 0.92270113},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, 0.92151404},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, 0.69397146, 0.92031828},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, 0.68508367, 0.91790078},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, 0.91667906},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, 0.67609270, 0.91544872},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, 0.66699992, 0.91296219},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, 0.91170603},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, 0.65780669, 0.91044129},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, 0.64851440, 0.90788612},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, 0.90659570},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, 0.63912444, 0.90529676},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, 0.62963824, 0.90267332},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, 0.90134885},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, 0.62005721, 0.90001589},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, 0.61038281, 0.89732458},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, 0.89596625},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, 0.60061648, 0.89459949},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, 0.59075970, 0.89184071},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, 0.89044872},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, 0.58081396, 0.88904836},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, 0.57078075, 0.88622253},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, 0.88479710},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, 0.56066158, 0.88336334},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, 0.55045797, 0.88047089},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, 0.87901223},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, 0.54017147, 0.87754529},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, 0.52980362, 0.87458665},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, 0.87309498},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, 0.51935599, 0.87159509},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, 0.50883014, 0.86857071},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, 0.86704625},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, 0.49822767, 0.86551362},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, 0.48755016, 0.86242396},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, 0.86086694},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, 0.47679923, 0.85930182},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, 0.46597650, 0.85614733},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, 0.85455799},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, 0.45508359, 0.85296060},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, 0.44412214, 0.84974177},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, 0.84812034},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, 0.43309382, 0.84649094},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, 0.42200027, 0.84320824},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, 0.84155498},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, 0.41084317, 0.83989379},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, 0.39962420, 0.83654773},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, 0.83486287},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, 0.38834505, 0.83317016},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, 0.37700741, 0.82976123},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, 0.82804505},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, 0.36561300, 0.82632106},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, 0.35416353, 0.82284978},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, 0.82110251},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, 0.34266072, 0.81934752},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, 0.33110631, 0.81581441},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, 0.81403633},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, 0.31950203, 0.81225059},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, 0.30784964, 0.80865618},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, 0.80684755},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, 0.29615089, 0.80503133},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, 0.28440754, 0.80137617},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, 0.79953727},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, 0.27262136, 0.79769084},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, 0.26079412, 0.79397548},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, 0.79210658},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, 0.24892761, 0.79023022},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, 0.23702361, 0.78645521},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, 0.78455660},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, 0.22508391, 0.78265060},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, 0.21311032, 0.77881651},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, 0.77688847},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, 0.20110463, 0.77495311},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, 0.18906866, 0.77106052},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, 0.76910334},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, 0.17700422, 0.76713891},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, 0.16491312, 0.76318842},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, 0.76120239},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, 0.15279719, 0.75920919},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, 0.14065824, 0.75520138},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, 0.75318680},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, 0.12849811, 0.75116513},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, 0.11631863, 0.74710061},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, 0.74505779},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, 0.10412163, 0.74300795},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, 0.09190896, 0.73888732},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, 0.73681657},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, 0.07968244, 0.73473888},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, 0.06744392, 0.73056277},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, 0.72846439},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, 0.05519524, 0.72635916},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, 0.04293826, 0.72212819},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, 0.72000251},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, 0.03067480, 0.71787005},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, 0.01840673, 0.71358487},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, 0.71143220},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, 0.00613588, 0.70927283},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, -0.00613588, 0.70493408},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, 0.70275474},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, -0.01840673, 0.70056879},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, -0.03067480, 0.69617713},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, 0.69397146},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, -0.04293826, 0.69175926},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, -0.05519524, 0.68731534},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, 0.68508367},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, -0.06744392, 0.68284555},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, -0.07968244, 0.67835004},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, 0.67609270},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, -0.09190896, 0.67382900},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, -0.10412163, 0.66928259},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, 0.66699992},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, -0.11631863, 0.66471098},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, -0.12849811, 0.66011434},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, 0.65780669},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, -0.14065824, 0.65549285},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, -0.15279719, 0.65084668},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, 0.64851440},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, -0.16491312, 0.64617601},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, -0.17700422, 0.64148101},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, 0.63912444},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, -0.18906866, 0.63676186},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, -0.20110463, 0.63201874},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, 0.62963824},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, -0.21311032, 0.62725182},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, -0.22508391, 0.62246128},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, 0.62005721},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, -0.23702361, 0.61764731},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, -0.24892761, 0.61281008},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, 0.61038281},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, -0.26079412, 0.60794978},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, -0.27262136, 0.60306660},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, 0.60061648},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, -0.28440754, 0.59816071},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, -0.29615089, 0.59323230},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, 0.59075970},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, -0.30784964, 0.58828155},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, -0.31950203, 0.58330865},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, 0.58081396},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, -0.33110631, 0.57831380},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, -0.34266072, 0.57329717},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, 0.57078075},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, -0.35416353, 0.56825895},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, -0.36561300, 0.56319934},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, 0.56066158},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, -0.37700741, 0.55811853},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, -0.38834505, 0.55301671},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, 0.55045797},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, -0.39962420, 0.54789406},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, -0.41084317, 0.54275078},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, 0.54017147},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, -0.42200027, 0.53758708},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, -0.43309382, 0.53240313},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, 0.52980362},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, -0.44412214, 0.52719913},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, -0.45508359, 0.52197529},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, 0.51935599},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, -0.46597650, 0.51673180},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, -0.47679923, 0.51146885},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, 0.50883014},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, -0.48755016, 0.50618665},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, -0.49822767, 0.50088538},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, 0.49822767},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, -0.50883014, 0.49556526},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, -0.51935599, 0.49022648},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, 0.48755016},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, -0.52980362, 0.48486925},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, -0.54017147, 0.47949376},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, 0.47679923},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, -0.55045797, 0.47410021},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, -0.56066158, 0.46868882},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, 0.46597650},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, -0.57078075, 0.46325978},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, -0.58081396, 0.45781330},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, 0.45508359},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, -0.59075970, 0.45234959},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, -0.60061648, 0.44686884},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, 0.44412214},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, -0.61038281, 0.44137127},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, -0.62005721, 0.43585708},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, 0.43309382},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, -0.62963824, 0.43032648},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, -0.63912444, 0.42477968},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, 0.42200027},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, -0.64851440, 0.41921689},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, -0.65780669, 0.41363831},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, 0.41084317},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, -0.66699992, 0.40804416},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, -0.67609270, 0.40243465},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, 0.39962420},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, -0.68508367, 0.39680999},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, -0.69397146, 0.39117038},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, 0.38834505},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, -0.70275474, 0.38551605},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, -0.71143220, 0.37984721},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, 0.37700741},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, -0.72000251, 0.37416406},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, -0.72846439, 0.36846683},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, 0.36561300},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, -0.73681657, 0.36275572},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, -0.74505779, 0.35703096},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, 0.35416353},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, -0.75318680, 0.35129276},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, -0.76120239, 0.34554132},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, 0.34266072},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, -0.76910334, 0.33977688},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, -0.77688847, 0.33399965},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, 0.33110631},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, -0.78455660, 0.32820984},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, -0.79210658, 0.32240768},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, 0.31950203},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, -0.79953727, 0.31659338},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, -0.80684755, 0.31076715},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, 0.30784964},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, -0.81403633, 0.30492923},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, -0.82110251, 0.29907983},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, 0.29615089},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, -0.82804505, 0.29321916},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, -0.83486287, 0.28734746},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, 0.28440754},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, -0.84155498, 0.28146494},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, -0.84812034, 0.27557182},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, 0.27262136},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, -0.85455799, 0.26966833},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, -0.86086694, 0.26375468},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, 0.26079412},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, -0.86704625, 0.25783110},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, -0.87309498, 0.25189782},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, 0.24892761},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, -0.87901223, 0.24595505},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, -0.88479710, 0.24000302},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, 0.23702361},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, -0.89044872, 0.23404196},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, -0.89596625, 0.22807208},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, 0.22508391},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, -0.90134885, 0.22209362},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, -0.90659570, 0.21610680},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, 0.21311032},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, -0.91170603, 0.21011184},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, -0.91667906, 0.20410897},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, 0.20110463},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, -0.92151404, 0.19809841},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, -0.92621024, 0.19208040},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, 0.18906866},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, -0.93076696, 0.18605515},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, -0.93518351, 0.18002290},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, 0.17700422},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, -0.93945922, 0.17398387},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, -0.94359346, 0.16793829},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, 0.16491312},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, -0.94758559, 0.16188639},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, -0.95143502, 0.15582840},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, 0.15279719},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, -0.95514117, 0.14976453},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, -0.95870347, 0.14369503},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, 0.14065824},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, -0.96212140, 0.13762012},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, -0.96539444, 0.13154003},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, 0.12849811},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, -0.96852209, 0.12545498},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, -0.97150389, 0.11936521},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, 0.11631863},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, -0.97433938, 0.11327095},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, -0.97702814, 0.10717242},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, 0.10412163},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, -0.97956977, 0.10106986},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, -0.98196387, 0.09496350},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, 0.09190896},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, -0.98421009, 0.08885355},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, -0.98630810, 0.08274026},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, 0.07968244},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, -0.98825757, 0.07662386},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, -0.99005821, 0.07050457},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, 0.06744392},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, -0.99170975, 0.06438263},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, -0.99321195, 0.05825826},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, 0.05519524},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, -0.99456457, 0.05213170},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, -0.99576741, 0.04600318},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, 0.04293826},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, -0.99682030, 0.03987293},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, -0.99772307, 0.03374117},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, 0.03067480},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, -0.99847558, 0.02760815},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, -0.99907773, 0.02147408},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, 0.01840673},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, -0.99952942, 0.01533921},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, -0.99983058, 0.00920375},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, 0.00613588},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, -0.99998118, 0.00306796},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, -0.99998118, -0.00306796},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, -0.00613588},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, -0.99983058, -0.00920375},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, -0.99952942, -0.01533921},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, -0.01840673},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, -0.99907773, -0.02147408},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, -0.99847558, -0.02760815},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, -0.03067480},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, -0.99772307, -0.03374117},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, -0.99682030, -0.03987293},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, -0.04293826},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, -0.99576741, -0.04600318},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, -0.99456457, -0.05213170},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, -0.05519524},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, -0.99321195, -0.05825826},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, -0.99170975, -0.06438263},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, -0.06744392},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, -0.99005821, -0.07050457},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, -0.98825757, -0.07662386},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, -0.07968244},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, -0.98630810, -0.08274026},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, -0.98421009, -0.08885355},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, -0.09190896},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, -0.98196387, -0.09496350},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, -0.97956977, -0.10106986},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, -0.10412163},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, -0.97702814, -0.10717242},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, -0.97433938, -0.11327095},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, -0.11631863},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, -0.97150389, -0.11936521},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, -0.96852209, -0.12545498},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, -0.12849811},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, -0.96539444, -0.13154003},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, -0.96212140, -0.13762012},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, -0.14065824},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, -0.95870347, -0.14369503},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, -0.95514117, -0.14976453},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, -0.15279719},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, -0.95143502, -0.15582840},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, -0.94758559, -0.16188639},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, -0.16491312},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, -0.94359346, -0.16793829},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, -0.93945922, -0.17398387},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, -0.17700422},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, -0.93518351, -0.18002290},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, -0.93076696, -0.18605515},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, -0.18906866},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, -0.92621024, -0.19208040},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, -0.92151404, -0.19809841},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, -0.20110463},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, -0.91667906, -0.20410897},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, -0.91170603, -0.21011184},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, -0.21311032},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, -0.90659570, -0.21610680},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, -0.90134885, -0.22209362},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, -0.22508391},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, -0.89596625, -0.22807208},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, -0.89044872, -0.23404196},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, -0.23702361},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, -0.88479710, -0.24000302},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, -0.87901223, -0.24595505},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, -0.24892761},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, -0.87309498, -0.25189782},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, -0.86704625, -0.25783110},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, -0.26079412},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, -0.86086694, -0.26375468},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, -0.85455799, -0.26966833},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, -0.27262136},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, -0.84812034, -0.27557182},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, -0.84155498, -0.28146494},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, -0.28440754},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, -0.83486287, -0.28734746},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, -0.82804505, -0.29321916},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, -0.29615089},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, -0.82110251, -0.29907983},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, -0.81403633, -0.30492923},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, -0.30784964},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, -0.80684755, -0.31076715},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, -0.79953727, -0.31659338},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, -0.31950203},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, -0.79210658, -0.32240768},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, -0.78455660, -0.32820984},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, -0.33110631},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, -0.77688847, -0.33399965},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, -0.76910334, -0.33977688},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, -0.34266072},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, -0.76120239, -0.34554132},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, -0.75318680, -0.35129276},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, -0.35416353},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, -0.74505779, -0.35703096},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, -0.73681657, -0.36275572},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, -0.36561300},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, -0.72846439, -0.36846683},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, -0.72000251, -0.37416406},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, -0.37700741},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, -0.71143220, -0.37984721},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, -0.70275474, -0.38551605},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, -0.38834505},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, -0.69397146, -0.39117038},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, -0.68508367, -0.39680999},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, -0.39962420},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, -0.67609270, -0.40243465},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, -0.66699992, -0.40804416},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, -0.41084317},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, -0.65780669, -0.41363831},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, -0.64851440, -0.41921689},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, -0.42200027},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, -0.63912444, -0.42477968},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, -0.62963824, -0.43032648},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, -0.43309382},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, -0.62005721, -0.43585708},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, -0.61038281, -0.44137127},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, -0.44412214},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, -0.60061648, -0.44686884},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, -0.59075970, -0.45234959},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, -0.45508359},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, -0.58081396, -0.45781330},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, -0.57078075, -0.46325978},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, -0.46597650},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, -0.56066158, -0.46868882},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, -0.55045797, -0.47410021},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, -0.47679923},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, -0.54017147, -0.47949376},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, -0.52980362, -0.48486925},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, -0.48755016},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, -0.51935599, -0.49022648},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, -0.50883014, -0.49556526},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, -0.49822767},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, -0.49822767, -0.50088538},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, -0.48755016, -0.50618665},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, -0.50883014},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, -0.47679923, -0.51146885},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, -0.46597650, -0.51673180},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, -0.51935599},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, -0.45508359, -0.52197529},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, -0.44412214, -0.52719913},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, -0.52980362},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, -0.43309382, -0.53240313},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, -0.42200027, -0.53758708},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, -0.54017147},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, -0.41084317, -0.54275078},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, -0.39962420, -0.54789406},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, -0.55045797},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, -0.38834505, -0.55301671},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, -0.37700741, -0.55811853},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, -0.56066158},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, -0.36561300, -0.56319934},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, -0.35416353, -0.56825895},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, -0.57078075},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, -0.34266072, -0.57329717},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, -0.33110631, -0.57831380},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, -0.58081396},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, -0.31950203, -0.58330865},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, -0.30784964, -0.58828155},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, -0.59075970},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, -0.29615089, -0.59323230},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, -0.28440754, -0.59816071},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, -0.60061648},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, -0.27262136, -0.60306660},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, -0.26079412, -0.60794978},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, -0.61038281},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, -0.24892761, -0.61281008},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, -0.23702361, -0.61764731},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, -0.62005721},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, -0.22508391, -0.62246128},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, -0.21311032, -0.62725182},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, -0.62963824},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, -0.20110463, -0.63201874},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, -0.18906866, -0.63676186},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, -0.63912444},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, -0.17700422, -0.64148101},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, -0.16491312, -0.64617601},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, -0.64851440},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, -0.15279719, -0.65084668},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, -0.14065824, -0.65549285},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, -0.65780669},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, -0.12849811, -0.66011434},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, -0.11631863, -0.66471098},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, -0.66699992},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, -0.10412163, -0.66928259},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, -0.09190896, -0.67382900},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, -0.67609270},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, -0.07968244, -0.67835004},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, -0.06744392, -0.68284555},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, -0.68508367},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, -0.05519524, -0.68731534},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, -0.04293826, -0.69175926},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, -0.69397146},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, -0.03067480, -0.69617713},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, -0.01840673, -0.70056879},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, -0.70275474},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, -0.00613588, -0.70493408},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470, 0.00613588, -0.70927283},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, -0.71143220},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238, 0.01840673, -0.71358487},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811, 0.03067480, -0.71787005},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, -0.72000251},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261, 0.04293826, -0.72212819},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697, 0.05519524, -0.72635916},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, -0.72846439},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264, 0.06744392, -0.73056277},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142, 0.07968244, -0.73473888},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, -0.73681657},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549, 0.09190896, -0.73888732},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737, 0.10412163, -0.74300795},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, -0.74505779},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995, 0.11631863, -0.74710061},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647, 0.12849811, -0.75116513},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, -0.75318680},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052, 0.14065824, -0.75520138},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604, 0.15279719, -0.75920919},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, -0.76120239},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733, 0.16491312, -0.76318842},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901, 0.17700422, -0.76713891},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, -0.76910334},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608, 0.18906866, -0.77106052},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385, 0.20110463, -0.77495311},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, -0.77688847},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798, 0.21311032, -0.77881651},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447, 0.22508391, -0.78265060},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, -0.78455660},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962, 0.23702361, -0.78645521},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009, 0.24892761, -0.79023022},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, -0.79210658},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286, 0.26079412, -0.79397548},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519, 0.27262136, -0.79769084},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, -0.79953727},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471, 0.28440754, -0.80137617},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930, 0.29615089, -0.80503133},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, -0.80684755},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720, 0.30784964, -0.80865618},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, -0.81045720},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, -0.79583690, 0.31950203, -0.81225059},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, -0.81403633},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, -0.78073723, 0.33110631, -0.81581441},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, -0.76516727, 0.34266072, -0.81934752},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, -0.82110251},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, -0.74913639, 0.35416353, -0.82284978},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, -0.82458930},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, -0.73265427, 0.36561300, -0.82632106},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, -0.82804505},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, -0.71573083, 0.37700741, -0.82976123},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, -0.69837625, 0.38834505, -0.83317016},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, -0.83486287},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, -0.68060100, 0.39962420, -0.83654773},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, -0.83822471},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, -0.66241578, 0.41084317, -0.83989379},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, -0.84155498},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, -0.64383154, 0.42200027, -0.84320824},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, -0.62485949, 0.43309382, -0.84649094},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, -0.84812034},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, -0.60551104, 0.44412214, -0.84974177},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, -0.85135519},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, -0.58579786, 0.45508359, -0.85296060},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, -0.85455799},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, -0.56573181, 0.46597650, -0.85614733},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, -0.54532499, 0.47679923, -0.85930182},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, -0.86086694},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, -0.52458968, 0.48755016, -0.86242396},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, -0.86397286},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, -0.50353838, 0.49822767, -0.86551362},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, -0.86704625},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, -0.48218377, 0.50883014, -0.86857071},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, -0.46053871, 0.51935599, -0.87159509},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, -0.87309498},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, -0.43861624, 0.52980362, -0.87458665},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, -0.87607009},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, -0.41642956, 0.54017147, -0.87754529},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, -0.87901223},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, -0.39399204, 0.55045797, -0.88047089},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, -0.37131719, 0.56066158, -0.88336334},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, -0.88479710},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, -0.34841868, 0.57078075, -0.88622253},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, -0.88763962},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, -0.32531029, 0.58081396, -0.88904836},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, -0.89044872},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, -0.30200595, 0.59075970, -0.89184071},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, -0.27851969, 0.60061648, -0.89459949},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, -0.89596625},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, -0.25486566, 0.61038281, -0.89732458},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, -0.89867447},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, -0.23105811, 0.62005721, -0.90001589},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, -0.90134885},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, -0.20711138, 0.62963824, -0.90267332},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, -0.18303989, 0.63912444, -0.90529676},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, -0.90659570},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, -0.15885814, 0.64851440, -0.90788612},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, -0.90916798},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, -0.13458071, 0.65780669, -0.91044129},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, -0.91170603},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, -0.11022221, 0.66699992, -0.91296219},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, -0.08579731, 0.67609270, -0.91544872},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, -0.91667906},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, -0.06132074, 0.68508367, -0.91790078},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, -0.91911385},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, -0.03680722, 0.69397146, -0.92031828},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, -0.92151404},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, -0.01227154, 0.70275474, -0.92270113},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882, 0.01227154, 0.71143220, -0.92504924},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, -0.92621024},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046, 0.03680722, 0.72000251, -0.92736253},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, -0.92850608},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953, 0.06132074, 0.72846439, -0.92964090},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, -0.93076696},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764, 0.08579731, 0.73681657, -0.93188427},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213, 0.11022221, 0.74505779, -0.93409255},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, -0.93518351},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607, 0.13458071, 0.75318680, -0.93626567},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, -0.93733901},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818, 0.15885814, 0.76120239, -0.93840353},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, -0.93945922},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, -0.93299280, 0.18303989, 0.76910334, -0.94050607},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, -0.91420976, 0.20711138, 0.77688847, -0.94257320},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, -0.94359346},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, -0.89322430, 0.23105811, 0.78455660, -0.94460484},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, -0.94560733},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, -0.87008699, 0.25486566, 0.79210658, -0.94660091},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, -0.94758559},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, -0.84485357, 0.27851969, 0.79953727, -0.94856135},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, -0.94952818},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, -0.81758481, 0.30200595, 0.80684755, -0.95048607},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, -0.95143502},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, -0.78834643, 0.32531029, 0.81403633, -0.95237501},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, -0.95330604},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, -0.75720885, 0.34841868, 0.82110251, -0.95422810},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, -0.95514117},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, -0.72424708, 0.37131719, 0.82804505, -0.95604525},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, -0.68954054, 0.39399204, 0.83486287, -0.95782641},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, -0.95870347},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, -0.65317284, 0.41642956, 0.84155498, -0.95957151},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, -0.96043052},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, -0.61523159, 0.43861624, 0.84812034, -0.96128049},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, -0.96212140},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, -0.57580819, 0.46053871, 0.85455799, -0.96295327},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, -0.96377607},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, -0.53499762, 0.48218377, 0.86086694, -0.96458979},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, -0.96539444},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, -0.49289819, 0.50353838, 0.86704625, -0.96619000},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, -0.96697647},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, -0.44961133, 0.52458968, 0.87309498, -0.96775384},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, -0.96852209},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, -0.40524131, 0.54532499, 0.87901223, -0.96928124},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, -0.35989504, 0.56573181, 0.88479710, -0.97077214},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, -0.97150389},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, -0.31368174, 0.58579786, 0.89044872, -0.97222650},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, -0.97293995},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, -0.26671276, 0.60551104, 0.89596625, -0.97364425},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, -0.97433938},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, -0.21910124, 0.62485949, 0.90134885, -0.97502535},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, -0.97570213},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, -0.17096189, 0.64383154, 0.90659570, -0.97636973},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, -0.97702814},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, -0.12241068, 0.66241578, 0.91170603, -0.97767736},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, -0.97831737},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, -0.07356456, 0.68060100, 0.91667906, -0.97894818},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, -0.97956977},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, -0.02454123, 0.69837625, 0.92151404, -0.98018214},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546, 0.02454123, 0.71573083, 0.92621024, -0.98137919},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, -0.98196387},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651, 0.07356456, 0.73265427, 0.93076696, -0.98253930},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, -0.98310549},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, -0.97003125, 0.12241068, 0.74913639, 0.93518351, -0.98366242},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, -0.98421009},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, -0.94154407, 0.17096189, 0.76516727, 0.93945922, -0.98474850},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, -0.98527764},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, -0.90398929, 0.21910124, 0.78073723, 0.94359346, -0.98579751},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, -0.98630810},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, -0.85772861, 0.26671276, 0.79583690, 0.94758559, -0.98680940},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, -0.98730142},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, -0.80320753, 0.31368174, 0.81045720, 0.95143502, -0.98778414},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, -0.98825757},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, -0.74095113, 0.35989504, 0.82458930, 0.95514117, -0.98872169},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, -0.98917651},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, -0.67155895, 0.40524131, 0.83822471, 0.95870347, -0.98962202},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, -0.99005821},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, -0.59569930, 0.44961133, 0.85135519, 0.96212140, -0.99048508},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, -0.99090264},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, -0.51410274, 0.49289819, 0.86397286, 0.96539444, -0.99131086},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, -0.99170975},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, -0.42755509, 0.53499762, 0.87607009, 0.96852209, -0.99209931},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, -0.99247953},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, -0.33688985, 0.57580819, 0.88763962, 0.97150389, -0.99285041},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, -0.99321195},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, -0.24298018, 0.61523159, 0.89867447, 0.97433938, -0.99356414},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, -0.99390697},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, -0.14673047, 0.65317284, 0.90916798, 0.97702814, -0.99424045},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, -0.99456457},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, -0.04906767, 0.68954054, 0.91911385, 0.97956977, -0.99487933},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, -0.99518473, 0.04906767, 0.72424708, 0.92850608, 0.98196387, -0.99548076},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, -0.99576741},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, -0.95694034, 0.14673047, 0.75720885, 0.93733901, 0.98421009, -0.99604470},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, -0.99631261},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, -0.88192126, 0.24298018, 0.78834643, 0.94560733, 0.98630810, -0.99657115},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, -0.99682030},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, -0.77301045, 0.33688985, 0.81758481, 0.95330604, 0.98825757, -0.99706007},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, -0.99729046},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, -0.63439328, 0.42755509, 0.84485357, 0.96043052, 0.99005821, -0.99751146},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, -0.99772307},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, -0.47139674, 0.51410274, 0.87008699, 0.96697647, 0.99170975, -0.99792529},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, -0.99811811},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, -0.29028468, 0.59569930, 0.89322430, 0.97293995, 0.99321195, -0.99830154},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, -0.99847558},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, -0.09801714, 0.67155895, 0.91420976, 0.97831737, 0.99456457, -0.99864022},
  {1.00000000, 1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, -0.99879546},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, -0.98078528, 0.09801714, 0.74095113, 0.93299280, 0.98310549, 0.99576741, -0.99894129},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, -0.99907773},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, -0.83146961, 0.29028468, 0.80320753, 0.94952818, 0.98730142, 0.99682030, -0.99920476},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, -0.99932238},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, -0.55557023, 0.47139674, 0.85772861, 0.96377607, 0.99090264, 0.99772307, -0.99943060},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, -0.99952942},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, -0.19509032, 0.63439328, 0.90398929, 0.97570213, 0.99390697, 0.99847558, -0.99961882},
  {1.00000000, 1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, -0.99969882},
  {-1.00000000, 0.00000000, 0.70710678, -0.92387953, 0.19509032, 0.77301045, 0.94154407, 0.98527764, 0.99631261, 0.99907773, -0.99976941},
  {1.00000000, -1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, -0.99983058},
  {-1.00000000, 0.00000000, -0.70710678, -0.38268343, 0.55557023, 0.88192126, 0.97003125, 0.99247953, 0.99811811, 0.99952942, -0.99988235},
  {1.00000000, 1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, -0.99992470},
  {-1.00000000, 0.00000000, -0.70710678, 0.38268343, 0.83146961, 0.95694034, 0.98917651, 0.99729046, 0.99932238, 0.99983058, -0.99995764},
  {1.00000000, -1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, -0.99998118},
  {-1.00000000, 0.00000000, 0.70710678, 0.92387953, 0.98078528, 0.99518473, 0.99879546, 0.99969882, 0.99992470, 0.99998118, -0.99999529}
};

const float sinTab[1024][11]={
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, 0.01227154, 0.00613588, 0.00306796},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, 0.01227154, 0.00613588},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, 0.03680722, 0.01840673, 0.00920375},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, 0.01227154},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, 0.06132074, 0.03067480, 0.01533921},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, 0.03680722, 0.01840673},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, 0.08579731, 0.04293826, 0.02147408},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, 0.11022221, 0.05519524, 0.02760815},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, 0.06132074, 0.03067480},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, 0.13458071, 0.06744392, 0.03374117},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, 0.03680722},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, 0.15885814, 0.07968244, 0.03987293},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, 0.08579731, 0.04293826},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, 0.18303989, 0.09190896, 0.04600318},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, 0.20711138, 0.10412163, 0.05213170},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, 0.11022221, 0.05519524},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, 0.23105811, 0.11631863, 0.05825826},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, 0.06132074},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, 0.25486566, 0.12849811, 0.06438263},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, 0.13458071, 0.06744392},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, 0.27851969, 0.14065824, 0.07050457},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, 0.30200595, 0.15279719, 0.07662386},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, 0.15885814, 0.07968244},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, 0.32531029, 0.16491312, 0.08274026},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, 0.08579731},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, 0.34841868, 0.17700422, 0.08885355},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, 0.18303989, 0.09190896},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, 0.37131719, 0.18906866, 0.09496350},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, 0.39399204, 0.20110463, 0.10106986},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, 0.20711138, 0.10412163},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, 0.41642956, 0.21311032, 0.10717242},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, 0.11022221},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, 0.43861624, 0.22508391, 0.11327095},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, 0.23105811, 0.11631863},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, 0.46053871, 0.23702361, 0.11936521},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, 0.48218377, 0.24892761, 0.12545498},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, 0.25486566, 0.12849811},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, 0.50353838, 0.26079412, 0.13154003},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, 0.13458071},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, 0.52458968, 0.27262136, 0.13762012},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, 0.27851969, 0.14065824},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, 0.54532499, 0.28440754, 0.14369503},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, 0.56573181, 0.29615089, 0.14976453},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, 0.30200595, 0.15279719},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, 0.58579786, 0.30784964, 0.15582840},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, 0.15885814},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, 0.60551104, 0.31950203, 0.16188639},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, 0.32531029, 0.16491312},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, 0.62485949, 0.33110631, 0.16793829},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, 0.64383154, 0.34266072, 0.17398387},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, 0.34841868, 0.17700422},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, 0.66241578, 0.35416353, 0.18002290},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, 0.18303989},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, 0.68060100, 0.36561300, 0.18605515},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, 0.37131719, 0.18906866},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, 0.69837625, 0.37700741, 0.19208040},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, 0.71573083, 0.38834505, 0.19809841},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, 0.39399204, 0.20110463},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, 0.73265427, 0.39962420, 0.20410897},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, 0.20711138},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, 0.74913639, 0.41084317, 0.21011184},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, 0.41642956, 0.21311032},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, 0.76516727, 0.42200027, 0.21610680},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, 0.78073723, 0.43309382, 0.22209362},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, 0.43861624, 0.22508391},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, 0.79583690, 0.44412214, 0.22807208},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, 0.23105811},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, 0.81045720, 0.45508359, 0.23404196},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, 0.46053871, 0.23702361},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, 0.82458930, 0.46597650, 0.24000302},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, 0.83822471, 0.47679923, 0.24595505},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, 0.48218377, 0.24892761},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, 0.85135519, 0.48755016, 0.25189782},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, 0.25486566},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, 0.86397286, 0.49822767, 0.25783110},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, 0.50353838, 0.26079412},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, 0.87607009, 0.50883014, 0.26375468},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, 0.88763962, 0.51935599, 0.26966833},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, 0.52458968, 0.27262136},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, 0.89867447, 0.52980362, 0.27557182},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, 0.27851969},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, 0.90916798, 0.54017147, 0.28146494},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, 0.54532499, 0.28440754},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, 0.91911385, 0.55045797, 0.28734746},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, 0.92850608, 0.56066158, 0.29321916},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, 0.56573181, 0.29615089},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, 0.93733901, 0.57078075, 0.29907983},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, 0.30200595},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, 0.94560733, 0.58081396, 0.30492923},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, 0.58579786, 0.30784964},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, 0.95330604, 0.59075970, 0.31076715},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, 0.96043052, 0.60061648, 0.31659338},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, 0.60551104, 0.31950203},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, 0.96697647, 0.61038281, 0.32240768},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, 0.32531029},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, 0.97293995, 0.62005721, 0.32820984},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, 0.62485949, 0.33110631},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, 0.97831737, 0.62963824, 0.33399965},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, 0.98310549, 0.63912444, 0.33977688},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, 0.64383154, 0.34266072},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, 0.98730142, 0.64851440, 0.34554132},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, 0.34841868},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, 0.99090264, 0.65780669, 0.35129276},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, 0.66241578, 0.35416353},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, 0.99390697, 0.66699992, 0.35703096},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, 0.99631261, 0.67609270, 0.36275572},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, 0.68060100, 0.36561300},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, 0.99811811, 0.68508367, 0.36846683},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, 0.37131719},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, 0.99932238, 0.69397146, 0.37416406},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, 0.69837625, 0.37700741},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, 0.99992470, 0.70275474, 0.37984721},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, 0.99992470, 0.71143220, 0.38551605},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, 0.71573083, 0.38834505},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, 0.99932238, 0.72000251, 0.39117038},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, 0.39399204},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, 0.99811811, 0.72846439, 0.39680999},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, 0.73265427, 0.39962420},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, 0.99631261, 0.73681657, 0.40243465},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, 0.99390697, 0.74505779, 0.40804416},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, 0.74913639, 0.41084317},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, 0.99090264, 0.75318680, 0.41363831},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, 0.41642956},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, 0.98730142, 0.76120239, 0.41921689},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, 0.76516727, 0.42200027},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, 0.98310549, 0.76910334, 0.42477968},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, 0.97831737, 0.77688847, 0.43032648},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, 0.78073723, 0.43309382},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, 0.97293995, 0.78455660, 0.43585708},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, 0.43861624},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, 0.96697647, 0.79210658, 0.44137127},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, 0.79583690, 0.44412214},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, 0.96043052, 0.79953727, 0.44686884},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, 0.95330604, 0.80684755, 0.45234959},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, 0.81045720, 0.45508359},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, 0.94560733, 0.81403633, 0.45781330},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, 0.46053871},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, 0.93733901, 0.82110251, 0.46325978},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, 0.82458930, 0.46597650},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, 0.92850608, 0.82804505, 0.46868882},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, 0.91911385, 0.83486287, 0.47410021},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, 0.83822471, 0.47679923},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, 0.90916798, 0.84155498, 0.47949376},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, 0.48218377},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, 0.89867447, 0.84812034, 0.48486925},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, 0.85135519, 0.48755016},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, 0.88763962, 0.85455799, 0.49022648},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, 0.87607009, 0.86086694, 0.49556526},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, 0.86397286, 0.49822767},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, 0.86397286, 0.86704625, 0.50088538},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, 0.50353838},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, 0.85135519, 0.87309498, 0.50618665},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, 0.87607009, 0.50883014},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, 0.83822471, 0.87901223, 0.51146885},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, 0.82458930, 0.88479710, 0.51673180},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, 0.88763962, 0.51935599},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, 0.81045720, 0.89044872, 0.52197529},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, 0.52458968},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, 0.79583690, 0.89596625, 0.52719913},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, 0.89867447, 0.52980362},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, 0.78073723, 0.90134885, 0.53240313},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, 0.76516727, 0.90659570, 0.53758708},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, 0.90916798, 0.54017147},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, 0.74913639, 0.91170603, 0.54275078},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, 0.54532499},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, 0.73265427, 0.91667906, 0.54789406},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, 0.91911385, 0.55045797},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, 0.71573083, 0.92151404, 0.55301671},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, 0.69837625, 0.92621024, 0.55811853},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, 0.92850608, 0.56066158},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, 0.68060100, 0.93076696, 0.56319934},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, 0.56573181},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, 0.66241578, 0.93518351, 0.56825895},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, 0.93733901, 0.57078075},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, 0.64383154, 0.93945922, 0.57329717},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, 0.62485949, 0.94359346, 0.57831380},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, 0.94560733, 0.58081396},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, 0.60551104, 0.94758559, 0.58330865},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, 0.58579786},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, 0.58579786, 0.95143502, 0.58828155},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, 0.95330604, 0.59075970},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, 0.56573181, 0.95514117, 0.59323230},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, 0.54532499, 0.95870347, 0.59816071},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, 0.96043052, 0.60061648},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, 0.52458968, 0.96212140, 0.60306660},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, 0.60551104},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, 0.50353838, 0.96539444, 0.60794978},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, 0.96697647, 0.61038281},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, 0.48218377, 0.96852209, 0.61281008},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, 0.46053871, 0.97150389, 0.61764731},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, 0.97293995, 0.62005721},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, 0.43861624, 0.97433938, 0.62246128},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, 0.62485949},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, 0.41642956, 0.97702814, 0.62725182},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, 0.97831737, 0.62963824},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, 0.39399204, 0.97956977, 0.63201874},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, 0.37131719, 0.98196387, 0.63676186},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, 0.98310549, 0.63912444},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, 0.34841868, 0.98421009, 0.64148101},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, 0.64383154},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, 0.32531029, 0.98630810, 0.64617601},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, 0.98730142, 0.64851440},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, 0.30200595, 0.98825757, 0.65084668},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, 0.27851969, 0.99005821, 0.65549285},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, 0.99090264, 0.65780669},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, 0.25486566, 0.99170975, 0.66011434},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, 0.66241578},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, 0.23105811, 0.99321195, 0.66471098},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, 0.99390697, 0.66699992},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, 0.20711138, 0.99456457, 0.66928259},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, 0.18303989, 0.99576741, 0.67382900},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, 0.99631261, 0.67609270},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, 0.15885814, 0.99682030, 0.67835004},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, 0.68060100},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, 0.13458071, 0.99772307, 0.68284555},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, 0.99811811, 0.68508367},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, 0.11022221, 0.99847558, 0.68731534},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, 0.08579731, 0.99907773, 0.69175926},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, 0.99932238, 0.69397146},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, 0.06132074, 0.99952942, 0.69617713},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, 0.69837625},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, 0.03680722, 0.99983058, 0.70056879},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, 0.99992470, 0.70275474},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, 0.01227154, 0.99998118, 0.70493408},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, -0.01227154, 0.99998118, 0.70927283},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, 0.99992470, 0.71143220},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, -0.03680722, 0.99983058, 0.71358487},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, 0.71573083},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, -0.06132074, 0.99952942, 0.71787005},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, 0.99932238, 0.72000251},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, -0.08579731, 0.99907773, 0.72212819},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, -0.11022221, 0.99847558, 0.72635916},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, 0.99811811, 0.72846439},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, -0.13458071, 0.99772307, 0.73056277},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, 0.73265427},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, -0.15885814, 0.99682030, 0.73473888},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, 0.99631261, 0.73681657},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, -0.18303989, 0.99576741, 0.73888732},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, -0.20711138, 0.99456457, 0.74300795},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, 0.99390697, 0.74505779},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, -0.23105811, 0.99321195, 0.74710061},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, 0.74913639},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, -0.25486566, 0.99170975, 0.75116513},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, 0.99090264, 0.75318680},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, -0.27851969, 0.99005821, 0.75520138},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, -0.30200595, 0.98825757, 0.75920919},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, 0.98730142, 0.76120239},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, -0.32531029, 0.98630810, 0.76318842},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, 0.76516727},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, -0.34841868, 0.98421009, 0.76713891},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, 0.98310549, 0.76910334},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, -0.37131719, 0.98196387, 0.77106052},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, -0.39399204, 0.97956977, 0.77495311},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, 0.97831737, 0.77688847},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, -0.41642956, 0.97702814, 0.77881651},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, 0.78073723},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, -0.43861624, 0.97433938, 0.78265060},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, 0.97293995, 0.78455660},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, -0.46053871, 0.97150389, 0.78645521},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, -0.48218377, 0.96852209, 0.79023022},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, 0.96697647, 0.79210658},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, -0.50353838, 0.96539444, 0.79397548},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, 0.79583690},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, -0.52458968, 0.96212140, 0.79769084},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, 0.96043052, 0.79953727},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, -0.54532499, 0.95870347, 0.80137617},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, -0.56573181, 0.95514117, 0.80503133},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, 0.95330604, 0.80684755},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, -0.58579786, 0.95143502, 0.80865618},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, 0.81045720},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, -0.60551104, 0.94758559, 0.81225059},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, 0.94560733, 0.81403633},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, -0.62485949, 0.94359346, 0.81581441},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, -0.64383154, 0.93945922, 0.81934752},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, 0.93733901, 0.82110251},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, -0.66241578, 0.93518351, 0.82284978},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, 0.82458930},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, -0.68060100, 0.93076696, 0.82632106},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, 0.92850608, 0.82804505},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, -0.69837625, 0.92621024, 0.82976123},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, -0.71573083, 0.92151404, 0.83317016},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, 0.91911385, 0.83486287},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, -0.73265427, 0.91667906, 0.83654773},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, 0.83822471},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, -0.74913639, 0.91170603, 0.83989379},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, 0.90916798, 0.84155498},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, -0.76516727, 0.90659570, 0.84320824},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, -0.78073723, 0.90134885, 0.84649094},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, 0.89867447, 0.84812034},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, -0.79583690, 0.89596625, 0.84974177},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, 0.85135519},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, -0.81045720, 0.89044872, 0.85296060},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, 0.88763962, 0.85455799},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, -0.82458930, 0.88479710, 0.85614733},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, -0.83822471, 0.87901223, 0.85930182},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, 0.87607009, 0.86086694},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, -0.85135519, 0.87309498, 0.86242396},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, 0.86397286},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, -0.86397286, 0.86704625, 0.86551362},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, 0.86397286, 0.86704625},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, -0.87607009, 0.86086694, 0.86857071},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, -0.88763962, 0.85455799, 0.87159509},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, 0.85135519, 0.87309498},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, -0.89867447, 0.84812034, 0.87458665},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, 0.87607009},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, -0.90916798, 0.84155498, 0.87754529},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, 0.83822471, 0.87901223},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, -0.91911385, 0.83486287, 0.88047089},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, -0.92850608, 0.82804505, 0.88336334},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, 0.82458930, 0.88479710},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, -0.93733901, 0.82110251, 0.88622253},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, 0.88763962},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, -0.94560733, 0.81403633, 0.88904836},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, 0.81045720, 0.89044872},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, -0.95330604, 0.80684755, 0.89184071},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, -0.96043052, 0.79953727, 0.89459949},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, 0.79583690, 0.89596625},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, -0.96697647, 0.79210658, 0.89732458},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, 0.89867447},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, -0.97293995, 0.78455660, 0.90001589},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, 0.78073723, 0.90134885},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, -0.97831737, 0.77688847, 0.90267332},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, -0.98310549, 0.76910334, 0.90529676},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, 0.76516727, 0.90659570},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, -0.98730142, 0.76120239, 0.90788612},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, 0.90916798},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, -0.99090264, 0.75318680, 0.91044129},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, 0.74913639, 0.91170603},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, -0.99390697, 0.74505779, 0.91296219},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, -0.99631261, 0.73681657, 0.91544872},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, 0.73265427, 0.91667906},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, -0.99811811, 0.72846439, 0.91790078},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, 0.91911385},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, -0.99932238, 0.72000251, 0.92031828},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, 0.71573083, 0.92151404},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, -0.99992470, 0.71143220, 0.92270113},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, -0.99992470, 0.70275474, 0.92504924},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, 0.69837625, 0.92621024},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, -0.99932238, 0.69397146, 0.92736253},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, 0.92850608},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, -0.99811811, 0.68508367, 0.92964090},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, 0.68060100, 0.93076696},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, -0.99631261, 0.67609270, 0.93188427},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, -0.99390697, 0.66699992, 0.93409255},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, 0.66241578, 0.93518351},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, -0.99090264, 0.65780669, 0.93626567},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, 0.93733901},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, -0.98730142, 0.64851440, 0.93840353},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, 0.64383154, 0.93945922},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, -0.98310549, 0.63912444, 0.94050607},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, -0.97831737, 0.62963824, 0.94257320},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, 0.62485949, 0.94359346},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, -0.97293995, 0.62005721, 0.94460484},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, 0.94560733},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, -0.96697647, 0.61038281, 0.94660091},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, 0.60551104, 0.94758559},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, -0.96043052, 0.60061648, 0.94856135},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, -0.95330604, 0.59075970, 0.95048607},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, 0.58579786, 0.95143502},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, -0.94560733, 0.58081396, 0.95237501},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, 0.95330604},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, -0.93733901, 0.57078075, 0.95422810},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, 0.56573181, 0.95514117},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, -0.92850608, 0.56066158, 0.95604525},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, -0.91911385, 0.55045797, 0.95782641},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, 0.54532499, 0.95870347},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, -0.90916798, 0.54017147, 0.95957151},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, 0.96043052},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, -0.89867447, 0.52980362, 0.96128049},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, 0.52458968, 0.96212140},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, -0.88763962, 0.51935599, 0.96295327},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, -0.87607009, 0.50883014, 0.96458979},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, 0.50353838, 0.96539444},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, -0.86397286, 0.49822767, 0.96619000},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, 0.96697647},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, -0.85135519, 0.48755016, 0.96775384},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, 0.48218377, 0.96852209},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, -0.83822471, 0.47679923, 0.96928124},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, -0.82458930, 0.46597650, 0.97077214},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, 0.46053871, 0.97150389},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, -0.81045720, 0.45508359, 0.97222650},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, 0.97293995},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, -0.79583690, 0.44412214, 0.97364425},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, 0.43861624, 0.97433938},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, -0.78073723, 0.43309382, 0.97502535},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, -0.76516727, 0.42200027, 0.97636973},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, 0.41642956, 0.97702814},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, -0.74913639, 0.41084317, 0.97767736},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, 0.97831737},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, -0.73265427, 0.39962420, 0.97894818},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, 0.39399204, 0.97956977},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, -0.71573083, 0.38834505, 0.98018214},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, -0.69837625, 0.37700741, 0.98137919},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, 0.37131719, 0.98196387},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, -0.68060100, 0.36561300, 0.98253930},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, 0.98310549},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, -0.66241578, 0.35416353, 0.98366242},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, 0.34841868, 0.98421009},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, -0.64383154, 0.34266072, 0.98474850},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, -0.62485949, 0.33110631, 0.98579751},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, 0.32531029, 0.98630810},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, -0.60551104, 0.31950203, 0.98680940},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, 0.98730142},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, -0.58579786, 0.30784964, 0.98778414},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, 0.30200595, 0.98825757},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, -0.56573181, 0.29615089, 0.98872169},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, -0.54532499, 0.28440754, 0.98962202},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, 0.27851969, 0.99005821},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, -0.52458968, 0.27262136, 0.99048508},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, 0.99090264},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, -0.50353838, 0.26079412, 0.99131086},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, 0.25486566, 0.99170975},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, -0.48218377, 0.24892761, 0.99209931},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, -0.46053871, 0.23702361, 0.99285041},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, 0.23105811, 0.99321195},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, -0.43861624, 0.22508391, 0.99356414},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, 0.99390697},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, -0.41642956, 0.21311032, 0.99424045},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, 0.20711138, 0.99456457},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, -0.39399204, 0.20110463, 0.99487933},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, -0.37131719, 0.18906866, 0.99548076},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, 0.18303989, 0.99576741},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, -0.34841868, 0.17700422, 0.99604470},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, 0.99631261},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, -0.32531029, 0.16491312, 0.99657115},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, 0.15885814, 0.99682030},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, -0.30200595, 0.15279719, 0.99706007},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, -0.27851969, 0.14065824, 0.99751146},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, 0.13458071, 0.99772307},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, -0.25486566, 0.12849811, 0.99792529},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, 0.99811811},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, -0.23105811, 0.11631863, 0.99830154},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, 0.11022221, 0.99847558},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, -0.20711138, 0.10412163, 0.99864022},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, -0.18303989, 0.09190896, 0.99894129},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, 0.08579731, 0.99907773},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, -0.15885814, 0.07968244, 0.99920476},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, 0.99932238},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, -0.13458071, 0.06744392, 0.99943060},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, 0.06132074, 0.99952942},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, -0.11022221, 0.05519524, 0.99961882},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, -0.08579731, 0.04293826, 0.99976941},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, 0.03680722, 0.99983058},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, -0.06132074, 0.03067480, 0.99988235},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, 0.99992470},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, -0.03680722, 0.01840673, 0.99995764},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, 0.01227154, 0.99998118},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, -0.01227154, 0.00613588, 0.99999529},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, 0.01227154, -0.00613588, 0.99999529},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, -0.01227154, 0.99998118},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, 0.03680722, -0.01840673, 0.99995764},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, 0.99992470},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, 0.06132074, -0.03067480, 0.99988235},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, -0.03680722, 0.99983058},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, 0.08579731, -0.04293826, 0.99976941},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, 0.11022221, -0.05519524, 0.99961882},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, -0.06132074, 0.99952942},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, 0.13458071, -0.06744392, 0.99943060},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, 0.99932238},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, 0.15885814, -0.07968244, 0.99920476},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, -0.08579731, 0.99907773},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, 0.18303989, -0.09190896, 0.99894129},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, 0.20711138, -0.10412163, 0.99864022},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, -0.11022221, 0.99847558},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, 0.23105811, -0.11631863, 0.99830154},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, 0.99811811},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, 0.25486566, -0.12849811, 0.99792529},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, -0.13458071, 0.99772307},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, 0.27851969, -0.14065824, 0.99751146},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, 0.30200595, -0.15279719, 0.99706007},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, -0.15885814, 0.99682030},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, 0.32531029, -0.16491312, 0.99657115},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, 0.99631261},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, 0.34841868, -0.17700422, 0.99604470},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, -0.18303989, 0.99576741},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, 0.37131719, -0.18906866, 0.99548076},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, 0.39399204, -0.20110463, 0.99487933},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, -0.20711138, 0.99456457},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, 0.41642956, -0.21311032, 0.99424045},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, 0.99390697},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, 0.43861624, -0.22508391, 0.99356414},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, -0.23105811, 0.99321195},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, 0.46053871, -0.23702361, 0.99285041},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, 0.48218377, -0.24892761, 0.99209931},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, -0.25486566, 0.99170975},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, 0.50353838, -0.26079412, 0.99131086},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, 0.99090264},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, 0.52458968, -0.27262136, 0.99048508},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, -0.27851969, 0.99005821},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, 0.54532499, -0.28440754, 0.98962202},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, 0.56573181, -0.29615089, 0.98872169},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, -0.30200595, 0.98825757},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, 0.58579786, -0.30784964, 0.98778414},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, 0.98730142},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, 0.60551104, -0.31950203, 0.98680940},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, -0.32531029, 0.98630810},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, 0.62485949, -0.33110631, 0.98579751},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, 0.64383154, -0.34266072, 0.98474850},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, -0.34841868, 0.98421009},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, 0.66241578, -0.35416353, 0.98366242},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, 0.98310549},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, 0.68060100, -0.36561300, 0.98253930},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, -0.37131719, 0.98196387},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, 0.69837625, -0.37700741, 0.98137919},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, 0.71573083, -0.38834505, 0.98018214},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, -0.39399204, 0.97956977},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, 0.73265427, -0.39962420, 0.97894818},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, 0.97831737},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, 0.74913639, -0.41084317, 0.97767736},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, -0.41642956, 0.97702814},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, 0.76516727, -0.42200027, 0.97636973},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, 0.78073723, -0.43309382, 0.97502535},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, -0.43861624, 0.97433938},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, 0.79583690, -0.44412214, 0.97364425},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, 0.97293995},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, 0.81045720, -0.45508359, 0.97222650},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, -0.46053871, 0.97150389},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, 0.82458930, -0.46597650, 0.97077214},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, 0.83822471, -0.47679923, 0.96928124},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, -0.48218377, 0.96852209},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, 0.85135519, -0.48755016, 0.96775384},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, 0.96697647},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, 0.86397286, -0.49822767, 0.96619000},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, -0.50353838, 0.96539444},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, 0.87607009, -0.50883014, 0.96458979},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, 0.88763962, -0.51935599, 0.96295327},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, -0.52458968, 0.96212140},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, 0.89867447, -0.52980362, 0.96128049},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, 0.96043052},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, 0.90916798, -0.54017147, 0.95957151},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, -0.54532499, 0.95870347},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, 0.91911385, -0.55045797, 0.95782641},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, 0.92850608, -0.56066158, 0.95604525},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, -0.56573181, 0.95514117},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, 0.93733901, -0.57078075, 0.95422810},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, 0.95330604},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, 0.94560733, -0.58081396, 0.95237501},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, -0.58579786, 0.95143502},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, 0.95330604, -0.59075970, 0.95048607},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, 0.96043052, -0.60061648, 0.94856135},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, -0.60551104, 0.94758559},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, 0.96697647, -0.61038281, 0.94660091},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, 0.94560733},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, 0.97293995, -0.62005721, 0.94460484},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, -0.62485949, 0.94359346},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, 0.97831737, -0.62963824, 0.94257320},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, 0.98310549, -0.63912444, 0.94050607},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, -0.64383154, 0.93945922},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, 0.98730142, -0.64851440, 0.93840353},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, 0.93733901},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, 0.99090264, -0.65780669, 0.93626567},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, -0.66241578, 0.93518351},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, 0.99390697, -0.66699992, 0.93409255},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, 0.99631261, -0.67609270, 0.93188427},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, -0.68060100, 0.93076696},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, 0.99811811, -0.68508367, 0.92964090},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, 0.92850608},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, 0.99932238, -0.69397146, 0.92736253},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, -0.69837625, 0.92621024},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, 0.99992470, -0.70275474, 0.92504924},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, 0.99992470, -0.71143220, 0.92270113},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, -0.71573083, 0.92151404},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, 0.99932238, -0.72000251, 0.92031828},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, 0.91911385},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, 0.99811811, -0.72846439, 0.91790078},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, -0.73265427, 0.91667906},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, 0.99631261, -0.73681657, 0.91544872},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, 0.99390697, -0.74505779, 0.91296219},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, -0.74913639, 0.91170603},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, 0.99090264, -0.75318680, 0.91044129},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, 0.90916798},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, 0.98730142, -0.76120239, 0.90788612},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, -0.76516727, 0.90659570},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, 0.98310549, -0.76910334, 0.90529676},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, 0.97831737, -0.77688847, 0.90267332},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, -0.78073723, 0.90134885},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, 0.97293995, -0.78455660, 0.90001589},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, 0.89867447},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, 0.96697647, -0.79210658, 0.89732458},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, -0.79583690, 0.89596625},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, 0.96043052, -0.79953727, 0.89459949},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, 0.95330604, -0.80684755, 0.89184071},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, -0.81045720, 0.89044872},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, 0.94560733, -0.81403633, 0.88904836},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, 0.88763962},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, 0.93733901, -0.82110251, 0.88622253},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, -0.82458930, 0.88479710},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, 0.92850608, -0.82804505, 0.88336334},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, 0.91911385, -0.83486287, 0.88047089},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, -0.83822471, 0.87901223},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, 0.90916798, -0.84155498, 0.87754529},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, 0.87607009},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, 0.89867447, -0.84812034, 0.87458665},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, -0.85135519, 0.87309498},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, 0.88763962, -0.85455799, 0.87159509},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, 0.87607009, -0.86086694, 0.86857071},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, -0.86397286, 0.86704625},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, 0.86397286, -0.86704625, 0.86551362},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, 0.86397286},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, 0.85135519, -0.87309498, 0.86242396},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, -0.87607009, 0.86086694},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, 0.83822471, -0.87901223, 0.85930182},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, 0.82458930, -0.88479710, 0.85614733},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, -0.88763962, 0.85455799},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, 0.81045720, -0.89044872, 0.85296060},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, 0.85135519},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, 0.79583690, -0.89596625, 0.84974177},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, -0.89867447, 0.84812034},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, 0.78073723, -0.90134885, 0.84649094},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, 0.76516727, -0.90659570, 0.84320824},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, -0.90916798, 0.84155498},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, 0.74913639, -0.91170603, 0.83989379},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, 0.83822471},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, 0.73265427, -0.91667906, 0.83654773},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, -0.91911385, 0.83486287},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, 0.71573083, -0.92151404, 0.83317016},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, 0.69837625, -0.92621024, 0.82976123},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, -0.92850608, 0.82804505},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, 0.68060100, -0.93076696, 0.82632106},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, 0.82458930},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, 0.66241578, -0.93518351, 0.82284978},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, -0.93733901, 0.82110251},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, 0.64383154, -0.93945922, 0.81934752},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, 0.62485949, -0.94359346, 0.81581441},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, -0.94560733, 0.81403633},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, 0.60551104, -0.94758559, 0.81225059},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, 0.81045720},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, 0.58579786, -0.95143502, 0.80865618},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, -0.95330604, 0.80684755},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, 0.56573181, -0.95514117, 0.80503133},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, 0.54532499, -0.95870347, 0.80137617},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, -0.96043052, 0.79953727},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, 0.52458968, -0.96212140, 0.79769084},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, 0.79583690},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, 0.50353838, -0.96539444, 0.79397548},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, -0.96697647, 0.79210658},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, 0.48218377, -0.96852209, 0.79023022},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, 0.46053871, -0.97150389, 0.78645521},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, -0.97293995, 0.78455660},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, 0.43861624, -0.97433938, 0.78265060},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, 0.78073723},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, 0.41642956, -0.97702814, 0.77881651},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, -0.97831737, 0.77688847},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, 0.39399204, -0.97956977, 0.77495311},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, 0.37131719, -0.98196387, 0.77106052},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, -0.98310549, 0.76910334},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, 0.34841868, -0.98421009, 0.76713891},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, 0.76516727},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, 0.32531029, -0.98630810, 0.76318842},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, -0.98730142, 0.76120239},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, 0.30200595, -0.98825757, 0.75920919},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, 0.27851969, -0.99005821, 0.75520138},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, -0.99090264, 0.75318680},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, 0.25486566, -0.99170975, 0.75116513},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, 0.74913639},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, 0.23105811, -0.99321195, 0.74710061},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, -0.99390697, 0.74505779},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, 0.20711138, -0.99456457, 0.74300795},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, 0.18303989, -0.99576741, 0.73888732},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, -0.99631261, 0.73681657},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, 0.15885814, -0.99682030, 0.73473888},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, 0.73265427},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, 0.13458071, -0.99772307, 0.73056277},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, -0.99811811, 0.72846439},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, 0.11022221, -0.99847558, 0.72635916},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, 0.08579731, -0.99907773, 0.72212819},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, -0.99932238, 0.72000251},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, 0.06132074, -0.99952942, 0.71787005},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, 0.71573083},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, 0.03680722, -0.99983058, 0.71358487},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, -0.99992470, 0.71143220},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, 0.01227154, -0.99998118, 0.70927283},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, 0.02454123, -0.01227154, -0.99998118, 0.70493408},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, -0.99992470, 0.70275474},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, 0.07356456, -0.03680722, -0.99983058, 0.70056879},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, 0.69837625},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, 0.12241068, -0.06132074, -0.99952942, 0.69617713},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, -0.99932238, 0.69397146},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, 0.17096189, -0.08579731, -0.99907773, 0.69175926},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, 0.21910124, -0.11022221, -0.99847558, 0.68731534},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, -0.99811811, 0.68508367},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, 0.26671276, -0.13458071, -0.99772307, 0.68284555},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, 0.68060100},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, 0.31368174, -0.15885814, -0.99682030, 0.67835004},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, -0.99631261, 0.67609270},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, 0.35989504, -0.18303989, -0.99576741, 0.67382900},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, 0.40524131, -0.20711138, -0.99456457, 0.66928259},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, -0.99390697, 0.66699992},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, 0.44961133, -0.23105811, -0.99321195, 0.66471098},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, 0.66241578},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, 0.49289819, -0.25486566, -0.99170975, 0.66011434},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, -0.99090264, 0.65780669},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, 0.53499762, -0.27851969, -0.99005821, 0.65549285},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, 0.57580819, -0.30200595, -0.98825757, 0.65084668},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, -0.98730142, 0.64851440},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, 0.61523159, -0.32531029, -0.98630810, 0.64617601},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, 0.64383154},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, 0.65317284, -0.34841868, -0.98421009, 0.64148101},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, -0.98310549, 0.63912444},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, 0.68954054, -0.37131719, -0.98196387, 0.63676186},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, 0.72424708, -0.39399204, -0.97956977, 0.63201874},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, -0.97831737, 0.62963824},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, 0.75720885, -0.41642956, -0.97702814, 0.62725182},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, 0.62485949},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, 0.78834643, -0.43861624, -0.97433938, 0.62246128},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, -0.97293995, 0.62005721},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, 0.81758481, -0.46053871, -0.97150389, 0.61764731},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, 0.84485357, -0.48218377, -0.96852209, 0.61281008},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, -0.96697647, 0.61038281},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, 0.87008699, -0.50353838, -0.96539444, 0.60794978},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, 0.60551104},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, 0.89322430, -0.52458968, -0.96212140, 0.60306660},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, -0.96043052, 0.60061648},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, 0.91420976, -0.54532499, -0.95870347, 0.59816071},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, 0.93299280, -0.56573181, -0.95514117, 0.59323230},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, -0.95330604, 0.59075970},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, 0.94952818, -0.58579786, -0.95143502, 0.58828155},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, 0.58579786},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, 0.96377607, -0.60551104, -0.94758559, 0.58330865},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, -0.94560733, 0.58081396},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, 0.97570213, -0.62485949, -0.94359346, 0.57831380},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, 0.98527764, -0.64383154, -0.93945922, 0.57329717},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, -0.93733901, 0.57078075},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, 0.99247953, -0.66241578, -0.93518351, 0.56825895},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, 0.56573181},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, 0.99729046, -0.68060100, -0.93076696, 0.56319934},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, -0.92850608, 0.56066158},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, 0.99969882, -0.69837625, -0.92621024, 0.55811853},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, 0.99969882, -0.71573083, -0.92151404, 0.55301671},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, -0.91911385, 0.55045797},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, 0.99729046, -0.73265427, -0.91667906, 0.54789406},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, 0.54532499},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, 0.99247953, -0.74913639, -0.91170603, 0.54275078},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, -0.90916798, 0.54017147},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, 0.98527764, -0.76516727, -0.90659570, 0.53758708},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, 0.97570213, -0.78073723, -0.90134885, 0.53240313},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, -0.89867447, 0.52980362},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, 0.96377607, -0.79583690, -0.89596625, 0.52719913},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, 0.52458968},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, 0.94952818, -0.81045720, -0.89044872, 0.52197529},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, -0.88763962, 0.51935599},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, 0.93299280, -0.82458930, -0.88479710, 0.51673180},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, 0.91420976, -0.83822471, -0.87901223, 0.51146885},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, -0.87607009, 0.50883014},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, 0.89322430, -0.85135519, -0.87309498, 0.50618665},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, 0.50353838},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, 0.87008699, -0.86397286, -0.86704625, 0.50088538},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, -0.86397286, 0.49822767},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, 0.84485357, -0.87607009, -0.86086694, 0.49556526},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, 0.81758481, -0.88763962, -0.85455799, 0.49022648},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, -0.85135519, 0.48755016},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, 0.78834643, -0.89867447, -0.84812034, 0.48486925},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, 0.48218377},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, 0.75720885, -0.90916798, -0.84155498, 0.47949376},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, -0.83822471, 0.47679923},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, 0.72424708, -0.91911385, -0.83486287, 0.47410021},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, 0.68954054, -0.92850608, -0.82804505, 0.46868882},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, -0.82458930, 0.46597650},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, 0.65317284, -0.93733901, -0.82110251, 0.46325978},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, 0.46053871},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, 0.61523159, -0.94560733, -0.81403633, 0.45781330},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, -0.81045720, 0.45508359},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, 0.57580819, -0.95330604, -0.80684755, 0.45234959},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, 0.53499762, -0.96043052, -0.79953727, 0.44686884},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, -0.79583690, 0.44412214},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, 0.49289819, -0.96697647, -0.79210658, 0.44137127},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, 0.43861624},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, 0.44961133, -0.97293995, -0.78455660, 0.43585708},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, -0.78073723, 0.43309382},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131, -0.97831737, -0.77688847, 0.43032648},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504, -0.98310549, -0.76910334, 0.42477968},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, -0.76516727, 0.42200027},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174, -0.98730142, -0.76120239, 0.41921689},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, 0.41642956},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276, -0.99090264, -0.75318680, 0.41363831},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, -0.74913639, 0.41084317},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124, -0.99390697, -0.74505779, 0.40804416},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, 0.40524131},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189, -0.99631261, -0.73681657, 0.40243465},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, -0.73265427, 0.39962420},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068, -0.99811811, -0.72846439, 0.39680999},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, 0.39399204},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456, -0.99932238, -0.72000251, 0.39117038},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, -0.71573083, 0.38834505},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123, -0.99992470, -0.71143220, 0.38551605},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, 0.04906767, -0.02454123, -0.99992470, -0.70275474, 0.37984721},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, -0.69837625, 0.37700741},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, 0.14673047, -0.07356456, -0.99932238, -0.69397146, 0.37416406},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, 0.37131719},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, 0.24298018, -0.12241068, -0.99811811, -0.68508367, 0.36846683},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, -0.68060100, 0.36561300},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, 0.33688985, -0.17096189, -0.99631261, -0.67609270, 0.36275572},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, 0.35989504},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, 0.42755509, -0.21910124, -0.99390697, -0.66699992, 0.35703096},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, -0.66241578, 0.35416353},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, 0.51410274, -0.26671276, -0.99090264, -0.65780669, 0.35129276},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, 0.34841868},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, 0.59569930, -0.31368174, -0.98730142, -0.64851440, 0.34554132},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, -0.64383154, 0.34266072},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, 0.67155895, -0.35989504, -0.98310549, -0.63912444, 0.33977688},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, 0.74095113, -0.40524131, -0.97831737, -0.62963824, 0.33399965},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, -0.62485949, 0.33110631},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, 0.80320753, -0.44961133, -0.97293995, -0.62005721, 0.32820984},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, 0.32531029},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, 0.85772861, -0.49289819, -0.96697647, -0.61038281, 0.32240768},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, -0.60551104, 0.31950203},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, 0.90398929, -0.53499762, -0.96043052, -0.60061648, 0.31659338},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, 0.31368174},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, 0.94154407, -0.57580819, -0.95330604, -0.59075970, 0.31076715},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, -0.58579786, 0.30784964},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, 0.97003125, -0.61523159, -0.94560733, -0.58081396, 0.30492923},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, 0.30200595},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, 0.98917651, -0.65317284, -0.93733901, -0.57078075, 0.29907983},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, -0.56573181, 0.29615089},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, 0.99879546, -0.68954054, -0.92850608, -0.56066158, 0.29321916},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, 0.99879546, -0.72424708, -0.91911385, -0.55045797, 0.28734746},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, -0.54532499, 0.28440754},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, 0.98917651, -0.75720885, -0.90916798, -0.54017147, 0.28146494},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, 0.27851969},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, 0.97003125, -0.78834643, -0.89867447, -0.52980362, 0.27557182},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, -0.52458968, 0.27262136},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, 0.94154407, -0.81758481, -0.88763962, -0.51935599, 0.26966833},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, 0.26671276},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, 0.90398929, -0.84485357, -0.87607009, -0.50883014, 0.26375468},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, -0.50353838, 0.26079412},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, 0.85772861, -0.87008699, -0.86397286, -0.49822767, 0.25783110},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, 0.25486566},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, 0.80320753, -0.89322430, -0.85135519, -0.48755016, 0.25189782},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, -0.48218377, 0.24892761},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, 0.74095113, -0.91420976, -0.83822471, -0.47679923, 0.24595505},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, 0.67155895, -0.93299280, -0.82458930, -0.46597650, 0.24000302},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, -0.46053871, 0.23702361},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, 0.59569930, -0.94952818, -0.81045720, -0.45508359, 0.23404196},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, 0.23105811},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, 0.51410274, -0.96377607, -0.79583690, -0.44412214, 0.22807208},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, -0.43861624, 0.22508391},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, 0.42755509, -0.97570213, -0.78073723, -0.43309382, 0.22209362},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, 0.21910124},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, 0.33688985, -0.98527764, -0.76516727, -0.42200027, 0.21610680},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, -0.41642956, 0.21311032},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, 0.24298018, -0.99247953, -0.74913639, -0.41084317, 0.21011184},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, 0.20711138},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047, -0.99729046, -0.73265427, -0.39962420, 0.20410897},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, -0.39399204, 0.20110463},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767, -0.99969882, -0.71573083, -0.38834505, 0.19809841},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, 0.09801714, -0.04906767, -0.99969882, -0.69837625, -0.37700741, 0.19208040},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, -0.37131719, 0.18906866},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, 0.29028468, -0.14673047, -0.99729046, -0.68060100, -0.36561300, 0.18605515},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, 0.18303989},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, 0.47139674, -0.24298018, -0.99247953, -0.66241578, -0.35416353, 0.18002290},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, -0.34841868, 0.17700422},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, 0.63439328, -0.33688985, -0.98527764, -0.64383154, -0.34266072, 0.17398387},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, 0.17096189},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, 0.77301045, -0.42755509, -0.97570213, -0.62485949, -0.33110631, 0.16793829},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, -0.32531029, 0.16491312},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, 0.88192126, -0.51410274, -0.96377607, -0.60551104, -0.31950203, 0.16188639},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, 0.15885814},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, 0.95694034, -0.59569930, -0.94952818, -0.58579786, -0.30784964, 0.15582840},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, -0.30200595, 0.15279719},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, 0.99518473, -0.67155895, -0.93299280, -0.56573181, -0.29615089, 0.14976453},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, 0.14673047},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, 0.99518473, -0.74095113, -0.91420976, -0.54532499, -0.28440754, 0.14369503},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, -0.27851969, 0.14065824},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, 0.95694034, -0.80320753, -0.89322430, -0.52458968, -0.27262136, 0.13762012},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, 0.13458071},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, 0.88192126, -0.85772861, -0.87008699, -0.50353838, -0.26079412, 0.13154003},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, -0.25486566, 0.12849811},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, 0.77301045, -0.90398929, -0.84485357, -0.48218377, -0.24892761, 0.12545498},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, 0.12241068},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, 0.63439328, -0.94154407, -0.81758481, -0.46053871, -0.23702361, 0.11936521},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, -0.23105811, 0.11631863},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, 0.47139674, -0.97003125, -0.78834643, -0.43861624, -0.22508391, 0.11327095},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, 0.11022221},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, 0.29028468, -0.98917651, -0.75720885, -0.41642956, -0.21311032, 0.10717242},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, -0.20711138, 0.10412163},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714, -0.99879546, -0.72424708, -0.39399204, -0.20110463, 0.10106986},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, 0.09801714},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, 0.19509032, -0.09801714, -0.99879546, -0.68954054, -0.37131719, -0.18906866, 0.09496350},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, -0.18303989, 0.09190896},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, 0.55557023, -0.29028468, -0.98917651, -0.65317284, -0.34841868, -0.17700422, 0.08885355},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, 0.08579731},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, 0.83146961, -0.47139674, -0.97003125, -0.61523159, -0.32531029, -0.16491312, 0.08274026},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, -0.15885814, 0.07968244},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, 0.98078528, -0.63439328, -0.94154407, -0.57580819, -0.30200595, -0.15279719, 0.07662386},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, 0.07356456},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, 0.98078528, -0.77301045, -0.90398929, -0.53499762, -0.27851969, -0.14065824, 0.07050457},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, -0.13458071, 0.06744392},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, 0.83146961, -0.88192126, -0.85772861, -0.49289819, -0.25486566, -0.12849811, 0.06438263},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, 0.06132074},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, 0.55557023, -0.95694034, -0.80320753, -0.44961133, -0.23105811, -0.11631863, 0.05825826},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, -0.11022221, 0.05519524},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, 0.19509032, -0.99518473, -0.74095113, -0.40524131, -0.20711138, -0.10412163, 0.05213170},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, 0.04906767},
  {0.00000000, 1.00000000, 0.70710678, 0.38268343, -0.19509032, -0.99518473, -0.67155895, -0.35989504, -0.18303989, -0.09190896, 0.04600318},
  {0.00000000, 0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, -0.08579731, 0.04293826},
  {0.00000000, -1.00000000, 0.70710678, 0.92387953, -0.55557023, -0.95694034, -0.59569930, -0.31368174, -0.15885814, -0.07968244, 0.03987293},
  {0.00000000, 0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, 0.03680722},
  {0.00000000, 1.00000000, -0.70710678, 0.92387953, -0.83146961, -0.88192126, -0.51410274, -0.26671276, -0.13458071, -0.06744392, 0.03374117},
  {0.00000000, 0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, -0.06132074, 0.03067480},
  {0.00000000, -1.00000000, -0.70710678, 0.38268343, -0.98078528, -0.77301045, -0.42755509, -0.21910124, -0.11022221, -0.05519524, 0.02760815},
  {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, 0.02454123},
  {0.00000000, 1.00000000, 0.70710678, -0.38268343, -0.98078528, -0.63439328, -0.33688985, -0.17096189, -0.08579731, -0.04293826, 0.02147408},
  {0.00000000, 0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, -0.03680722, 0.01840673},
  {0.00000000, -1.00000000, 0.70710678, -0.92387953, -0.83146961, -0.47139674, -0.24298018, -0.12241068, -0.06132074, -0.03067480, 0.01533921},
  {0.00000000, 0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, 0.01227154},
  {0.00000000, 1.00000000, -0.70710678, -0.92387953, -0.55557023, -0.29028468, -0.14673047, -0.07356456, -0.03680722, -0.01840673, 0.00920375},
  {0.00000000, 0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, -0.01227154, 0.00613588},
  {0.00000000, -1.00000000, -0.70710678, -0.38268343, -0.19509032, -0.09801714, -0.04906767, -0.02454123, -0.01227154, -0.00613588, 0.00306796}

};



/* 
   fft(v,N):
   [0] If N==1 then return.
   [1] For k = 0 to N/2-1, let ve[k] = v[2*k]
   [2] Compute fft(ve, N/2);
   [3] For k = 0 to N/2-1, let vo[k] = v[2*k+1]
   [4] Compute fft(vo, N/2);
   [5] For m = 0 to N/2-1, do [6] through [9]
   [6]   Let w.Real = cos(2*PI*m/N)
   [7]   Let w.Imag = -sin(2*PI*m/N)
   [8]   Let v[m] = ve[m] + w*vo[m]
   [9]   Let v[m+N/2] = ve[m] - w*vo[m]
Time to convert
   n    Time(us)
     64   1659
    128   3892
    256   8979
    512  20440
   1024  46035
   2048 102760
 */
void fft( complex_t *v, int n, complex_t *tmp ){
  if(n>1) {			/* otherwise, do nothing and return */
    int k,m,j,n1;
	complex_t z, w, *vo, *ve;
    ve = tmp; 
	vo = tmp+n/2;
    for(k=0; k<n/2; k++) {
      ve[k] = v[2*k];
      vo[k] = v[2*k+1];
    }
    fft( ve, n/2, v );		/* FFT on even-indexed elements of v[] */
    fft( vo, n/2, v );		/* FFT on odd-indexed elements of v[] */
    for(m=0; m<n/2; m++){
      j = 0; n1 = 2;
      while(n1<n){
        j++; n1 = n1*2;
      }
      // j goes 0,1,2, 3, 4, 5,  6,  7,  8,   9, 10,  11
      // n goes 2,4,8,16,32,64,128,256,512,1024,2048,4096
      w.Real = cosTab[m][j];
      w.Imag = -sinTab[m][j];;
    //  w.Real = cos(2*PI*m/(float)n);
    //  w.Imag = -sin(2*PI*m/(float)n);
      z.Real = w.Real*vo[m].Real - w.Imag*vo[m].Imag;	/* Re(w*vo[m]) */
      z.Imag = w.Real*vo[m].Imag + w.Imag*vo[m].Real;	/* Im(w*vo[m]) */
      v[  m  ].Real = ve[m].Real + z.Real;
      v[  m  ].Imag = ve[m].Imag + z.Imag;
      v[m+n/2].Real = ve[m].Real - z.Real;
      v[m+n/2].Imag = ve[m].Imag - z.Imag;
    }
  }
  return;
}


/* 
   ifft(v,N):
   [0] If N==1 then return.
   [1] For k = 0 to N/2-1, let ve[k] = v[2*k]
   [2] Compute ifft(ve, N/2);
   [3] For k = 0 to N/2-1, let vo[k] = v[2*k+1]
   [4] Compute ifft(vo, N/2);
   [5] For m = 0 to N/2-1, do [6] through [9]
   [6]   Let w.Real = cos(2*PI*m/N)
   [7]   Let w.Imag = sin(2*PI*m/N)
   [8]   Let v[m] = ve[m] + w*vo[m]
   [9]   Let v[m+N/2] = ve[m] - w*vo[m]
 */
void ifft( complex_t *v, int n, complex_t *tmp ){
  if(n>1) {			/* otherwise, do nothing and return */
    int k,m,j,n1;
	complex_t z, w, *vo, *ve;
    ve = tmp; vo = tmp+n/2;
    for(k=0; k<n/2; k++){
      ve[k] = v[2*k];
      vo[k] = v[2*k+1];
    }
    ifft( ve, n/2, v );		/* FFT on even-indexed elements of v[] */
    ifft( vo, n/2, v );		/* FFT on odd-indexed elements of v[] */
    for(m=0; m<n/2; m++) {
      j = 0; n1 = 2;
      while(n1<n){
        j++; n1 = n1*2;
      }
      // j goes 0,1,2, 3, 4, 5,  6,  7,  8,   9, 10,  11
      // n goes 2,4,8,16,32,64,128,256,512,1024,2048,4096
      w.Real = cosTab[m][j];
      w.Imag = sinTab[m][j];;
     // w.Real = cos(2*PI*m/(float)n);
     // w.Imag = sin(2*PI*m/(float)n);
      z.Real = w.Real*vo[m].Real - w.Imag*vo[m].Imag;	/* Re(w*vo[m]) */
      z.Imag = w.Real*vo[m].Imag + w.Imag*vo[m].Real;	/* Im(w*vo[m]) */
      v[  m  ].Real = ve[m].Real + z.Real;
      v[  m  ].Imag = ve[m].Imag + z.Imag;
      v[m+n/2].Real = ve[m].Real - z.Real;
      v[m+n/2].Imag = ve[m].Imag - z.Imag;
    }
  }
  return;
}

