/* TFLunaCommon.c
 * Jonathan Valvano
 * Date: 10/23/2025
   Initialization commands for TF Luna TOF distance sensor
 */
#include <stdint.h>
/**
 * Sampling rate in Hz
 * @warning only 100 tested
*/
#define TFLunaRate 100

const uint8_t ObtainFirmware[4]={0x5A,0x04,0x01,0x5F};
// expected response is 0x5A,0x07,0x01,a,b,c,SU version c.b.a
const uint8_t System_Reset[4]={0x5A,0x04,0x02,0x60};
// expected response is 0x5A,0x05,0x02,0x00, 0x60 for success
// expected response is 0x5A,0x05,0x02,0x01, 0x61 for failed
#define SU1 ((0x54+0x06+0x3+TFLunaRate)&0xFF)
const uint8_t Frame_Rate[6]={0x5A,0x06,0x03,TFLunaRate,0,SU1};
const uint8_t Trigger[4]={0x5A,0x04,0x04,0x62};
const uint8_t Format_Standard_cm[5]={0x5A,0x05,0x05,0x01,0x66};
const uint8_t Format_Pixhawk[5]={0x5A,0x05,0x05,0x02,0x67};
const uint8_t Format_Standard_mm[5]={0x5A,0x05,0x05,0x06,0x6A};
const uint8_t Output_Enable[5]={0x5A,0x05,0x07,0x00,0x66};
const uint8_t Output_Disable[5]={0x5A,0x05,0x07,0x01,0x67};
const uint8_t SaveSettings[4]={0x5A,0x04,0x11,0x6F};
