// fixed.c
// fixed-point trig functions
// Uses table lookup for speed
// TI-RSLK MAX
// Daniel Valvano and Jonathan Valvano
// April 10, 2019

/* This example accompanies the book
   "Embedded Systems: Introduction to Robotics,
   Jonathan W. Valvano, ISBN: 9781074544300, copyright (c) 2019
 For more information about my classes, my research, and my books, see
 http://users.ece.utexas.edu/~valvano/

Simplified BSD License (FreeBSD License)
Copyright (c) 2019, Jonathan Valvano, All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are
those of the authors and should not be interpreted as representing official
policies, either expressed or implied, of the FreeBSD Project.
*/


#include <stdint.h>
// index is angle in 0.001 radians
// index goes from 0 to 1571 (pi/2)
int16_t const SinTab[1572]={
  0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250, 260, 270,
  280, 290, 300, 310, 320, 330, 340, 350, 360, 370, 380, 390, 400, 410, 420, 430, 440, 450, 460, 470, 480, 490, 500, 510, 520, 530,
  540, 550, 560, 570, 580, 590, 600, 610, 620, 630, 640, 650, 660, 669, 679, 689, 699, 709, 719, 729, 739, 749, 759, 769, 779, 789,
  799, 809, 819, 829, 839, 849, 859, 869, 879, 889, 899, 909, 919, 929, 939, 949, 959, 968, 978, 988, 998, 1008, 1018, 1028, 1038,
  1048, 1058, 1068, 1078, 1088, 1098, 1108, 1118, 1128, 1138, 1147, 1157, 1167, 1177, 1187, 1197, 1207, 1217, 1227, 1237, 1247, 1257,
  1267, 1277, 1286, 1296, 1306, 1316, 1326, 1336, 1346, 1356, 1366, 1376, 1386, 1395, 1405, 1415, 1425, 1435, 1445, 1455, 1465, 1475,
  1484, 1494, 1504, 1514, 1524, 1534, 1544, 1554, 1564, 1573, 1583, 1593, 1603, 1613, 1623, 1633, 1643, 1652, 1662, 1672, 1682, 1692,
  1702, 1712, 1721, 1731, 1741, 1751, 1761, 1771, 1780, 1790, 1800, 1810, 1820, 1830, 1839, 1849, 1859, 1869, 1879, 1889, 1898, 1908,
  1918, 1928, 1938, 1947, 1957, 1967, 1977, 1987, 1996, 2006, 2016, 2026, 2036, 2045, 2055, 2065, 2075, 2085, 2094, 2104, 2114, 2124,
  2133, 2143, 2153, 2163, 2173, 2182, 2192, 2202, 2212, 2221, 2231, 2241, 2251, 2260, 2270, 2280, 2290, 2299, 2309, 2319, 2328, 2338,
  2348, 2358, 2367, 2377, 2387, 2396, 2406, 2416, 2426, 2435, 2445, 2455, 2464, 2474, 2484, 2493, 2503, 2513, 2522, 2532, 2542, 2551,
  2561, 2571, 2580, 2590, 2600, 2609, 2619, 2629, 2638, 2648, 2658, 2667, 2677, 2687, 2696, 2706, 2715, 2725, 2735, 2744, 2754, 2764,
  2773, 2783, 2792, 2802, 2812, 2821, 2831, 2840, 2850, 2860, 2869, 2879, 2888, 2898, 2907, 2917, 2927, 2936, 2946, 2955, 2965, 2974,
  2984, 2993, 3003, 3012, 3022, 3032, 3041, 3051, 3060, 3070, 3079, 3089, 3098, 3108, 3117, 3127, 3136, 3146, 3155, 3165, 3174, 3184,
  3193, 3203, 3212, 3222, 3231, 3240, 3250, 3259, 3269, 3278, 3288, 3297, 3307, 3316, 3325, 3335, 3344, 3354, 3363, 3373, 3382, 3391,
  3401, 3410, 3420, 3429, 3438, 3448, 3457, 3467, 3476, 3485, 3495, 3504, 3513, 3523, 3532, 3541, 3551, 3560, 3569, 3579, 3588, 3598,
  3607, 3616, 3625, 3635, 3644, 3653, 3663, 3672, 3681, 3691, 3700, 3709, 3718, 3728, 3737, 3746, 3756, 3765, 3774, 3783, 3793, 3802,
  3811, 3820, 3830, 3839, 3848, 3857, 3867, 3876, 3885, 3894, 3903, 3913, 3922, 3931, 3940, 3949, 3959, 3968, 3977, 3986, 3995, 4004,
  4014, 4023, 4032, 4041, 4050, 4059, 4068, 4078, 4087, 4096, 4105, 4114, 4123, 4132, 4141, 4151, 4160, 4169, 4178, 4187, 4196, 4205,
  4214, 4223, 4232, 4241, 4250, 4259, 4268, 4277, 4287, 4296, 4305, 4314, 4323, 4332, 4341, 4350, 4359, 4368, 4377, 4386, 4395, 4404,
  4413, 4422, 4431, 4439, 4448, 4457, 4466, 4475, 4484, 4493, 4502, 4511, 4520, 4529, 4538, 4547, 4556, 4564, 4573, 4582, 4591, 4600,
  4609, 4618, 4627, 4636, 4644, 4653, 4662, 4671, 4680, 4689, 4697, 4706, 4715, 4724, 4733, 4742, 4750, 4759, 4768, 4777, 4785, 4794,
  4803, 4812, 4821, 4829, 4838, 4847, 4856, 4864, 4873, 4882, 4890, 4899, 4908, 4917, 4925, 4934, 4943, 4951, 4960, 4969, 4977, 4986,
  4995, 5003, 5012, 5021, 5029, 5038, 5047, 5055, 5064, 5073, 5081, 5090, 5098, 5107, 5116, 5124, 5133, 5141, 5150, 5159, 5167, 5176,
  5184, 5193, 5201, 5210, 5218, 5227, 5235, 5244, 5252, 5261, 5269, 5278, 5286, 5295, 5303, 5312, 5320, 5329, 5337, 5346, 5354, 5363,
  5371, 5379, 5388, 5396, 5405, 5413, 5422, 5430, 5438, 5447, 5455, 5463, 5472, 5480, 5489, 5497, 5505, 5514, 5522, 5530, 5539, 5547,
  5555, 5564, 5572, 5580, 5589, 5597, 5605, 5613, 5622, 5630, 5638, 5646, 5655, 5663, 5671, 5679, 5688, 5696, 5704, 5712, 5720, 5729,
  5737, 5745, 5753, 5761, 5770, 5778, 5786, 5794, 5802, 5810, 5818, 5827, 5835, 5843, 5851, 5859, 5867, 5875, 5883, 5891, 5900, 5908,
  5916, 5924, 5932, 5940, 5948, 5956, 5964, 5972, 5980, 5988, 5996, 6004, 6012, 6020, 6028, 6036, 6044, 6052, 6060, 6068, 6076, 6084,
  6092, 6100, 6107, 6115, 6123, 6131, 6139, 6147, 6155, 6163, 6171, 6178, 6186, 6194, 6202, 6210, 6218, 6226, 6233, 6241, 6249, 6257,
  6265, 6272, 6280, 6288, 6296, 6303, 6311, 6319, 6327, 6334, 6342, 6350, 6358, 6365, 6373, 6381, 6388, 6396, 6404, 6412, 6419, 6427,
  6435, 6442, 6450, 6457, 6465, 6473, 6480, 6488, 6496, 6503, 6511, 6518, 6526, 6533, 6541, 6549, 6556, 6564, 6571, 6579, 6586, 6594,
  6601, 6609, 6616, 6624, 6631, 6639, 6646, 6654, 6661, 6669, 6676, 6684, 6691, 6698, 6706, 6713, 6721, 6728, 6735, 6743, 6750, 6758,
  6765, 6772, 6780, 6787, 6794, 6802, 6809, 6816, 6824, 6831, 6838, 6846, 6853, 6860, 6867, 6875, 6882, 6889, 6896, 6904, 6911, 6918,
  6925, 6933, 6940, 6947, 6954, 6961, 6969, 6976, 6983, 6990, 6997, 7004, 7011, 7019, 7026, 7033, 7040, 7047, 7054, 7061, 7068, 7075,
  7082, 7089, 7096, 7104, 7111, 7118, 7125, 7132, 7139, 7146, 7153, 7160, 7167, 7174, 7181, 7187, 7194, 7201, 7208, 7215, 7222, 7229,
  7236, 7243, 7250, 7257, 7264, 7270, 7277, 7284, 7291, 7298, 7305, 7311, 7318, 7325, 7332, 7339, 7345, 7352, 7359, 7366, 7373, 7379,
  7386, 7393, 7400, 7406, 7413, 7420, 7426, 7433, 7440, 7446, 7453, 7460, 7466, 7473, 7480, 7486, 7493, 7500, 7506, 7513, 7519, 7526,
  7533, 7539, 7546, 7552, 7559, 7565, 7572, 7578, 7585, 7591, 7598, 7604, 7611, 7617, 7624, 7630, 7637, 7643, 7650, 7656, 7663, 7669,
  7675, 7682, 7688, 7695, 7701, 7707, 7714, 7720, 7726, 7733, 7739, 7745, 7752, 7758, 7764, 7771, 7777, 7783, 7790, 7796, 7802, 7808,
  7815, 7821, 7827, 7833, 7839, 7846, 7852, 7858, 7864, 7870, 7877, 7883, 7889, 7895, 7901, 7907, 7913, 7920, 7926, 7932, 7938, 7944,
  7950, 7956, 7962, 7968, 7974, 7980, 7986, 7992, 7998, 8004, 8010, 8016, 8022, 8028, 8034, 8040, 8046, 8052, 8058, 8064, 8070, 8076,
  8081, 8087, 8093, 8099, 8105, 8111, 8117, 8123, 8128, 8134, 8140, 8146, 8152, 8157, 8163, 8169, 8175, 8180, 8186, 8192, 8198, 8203,
  8209, 8215, 8220, 8226, 8232, 8238, 8243, 8249, 8255, 8260, 8266, 8271, 8277, 8283, 8288, 8294, 8299, 8305, 8311, 8316, 8322, 8327,
  8333, 8338, 8344, 8349, 8355, 8360, 8366, 8371, 8377, 8382, 8388, 8393, 8398, 8404, 8409, 8415, 8420, 8425, 8431, 8436, 8442, 8447,
  8452, 8458, 8463, 8468, 8474, 8479, 8484, 8490, 8495, 8500, 8505, 8511, 8516, 8521, 8526, 8532, 8537, 8542, 8547, 8552, 8558, 8563,
  8568, 8573, 8578, 8583, 8588, 8594, 8599, 8604, 8609, 8614, 8619, 8624, 8629, 8634, 8639, 8644, 8649, 8654, 8659, 8664, 8669, 8674,
  8679, 8684, 8689, 8694, 8699, 8704, 8709, 8714, 8719, 8724, 8728, 8733, 8738, 8743, 8748, 8753, 8758, 8762, 8767, 8772, 8777, 8782,
  8786, 8791, 8796, 8801, 8805, 8810, 8815, 8820, 8824, 8829, 8834, 8838, 8843, 8848, 8852, 8857, 8862, 8866, 8871, 8876, 8880, 8885,
  8889, 8894, 8898, 8903, 8908, 8912, 8917, 8921, 8926, 8930, 8935, 8939, 8944, 8948, 8953, 8957, 8961, 8966, 8970, 8975, 8979, 8984,
  8988, 8992, 8997, 9001, 9005, 9010, 9014, 9018, 9023, 9027, 9031, 9036, 9040, 9044, 9048, 9053, 9057, 9061, 9065, 9070, 9074, 9078,
  9082, 9086, 9091, 9095, 9099, 9103, 9107, 9111, 9115, 9119, 9124, 9128, 9132, 9136, 9140, 9144, 9148, 9152, 9156, 9160, 9164, 9168,
  9172, 9176, 9180, 9184, 9188, 9192, 9196, 9200, 9204, 9208, 9211, 9215, 9219, 9223, 9227, 9231, 9235, 9238, 9242, 9246, 9250, 9254,
  9257, 9261, 9265, 9269, 9272, 9276, 9280, 9284, 9287, 9291, 9295, 9298, 9302, 9306, 9309, 9313, 9317, 9320, 9324, 9328, 9331, 9335,
  9338, 9342, 9346, 9349, 9353, 9356, 9360, 9363, 9367, 9370, 9374, 9377, 9381, 9384, 9388, 9391, 9394, 9398, 9401, 9405, 9408, 9411,
  9415, 9418, 9422, 9425, 9428, 9432, 9435, 9438, 9441, 9445, 9448, 9451, 9455, 9458, 9461, 9464, 9468, 9471, 9474, 9477, 9480, 9484,
  9487, 9490, 9493, 9496, 9499, 9502, 9505, 9509, 9512, 9515, 9518, 9521, 9524, 9527, 9530, 9533, 9536, 9539, 9542, 9545, 9548, 9551,
  9554, 9557, 9560, 9563, 9566, 9569, 9572, 9574, 9577, 9580, 9583, 9586, 9589, 9592, 9594, 9597, 9600, 9603, 9606, 9608, 9611, 9614,
  9617, 9619, 9622, 9625, 9628, 9630, 9633, 9636, 9638, 9641, 9644, 9646, 9649, 9651, 9654, 9657, 9659, 9662, 9664, 9667, 9670, 9672,
  9675, 9677, 9680, 9682, 9685, 9687, 9690, 9692, 9695, 9697, 9699, 9702, 9704, 9707, 9709, 9711, 9714, 9716, 9719, 9721, 9723, 9726,
  9728, 9730, 9733, 9735, 9737, 9739, 9742, 9744, 9746, 9748, 9751, 9753, 9755, 9757, 9759, 9762, 9764, 9766, 9768, 9770, 9772, 9774,
  9777, 9779, 9781, 9783, 9785, 9787, 9789, 9791, 9793, 9795, 9797, 9799, 9801, 9803, 9805, 9807, 9809, 9811, 9813, 9815, 9817, 9819,
  9820, 9822, 9824, 9826, 9828, 9830, 9832, 9833, 9835, 9837, 9839, 9841, 9842, 9844, 9846, 9848, 9849, 9851, 9853, 9854, 9856, 9858,
  9860, 9861, 9863, 9865, 9866, 9868, 9869, 9871, 9873, 9874, 9876, 9877, 9879, 9880, 9882, 9883, 9885, 9887, 9888, 9890, 9891, 9892,
  9894, 9895, 9897, 9898, 9900, 9901, 9902, 9904, 9905, 9907, 9908, 9909, 9911, 9912, 9913, 9915, 9916, 9917, 9918, 9920, 9921, 9922,
  9923, 9925, 9926, 9927, 9928, 9930, 9931, 9932, 9933, 9934, 9935, 9936, 9938, 9939, 9940, 9941, 9942, 9943, 9944, 9945, 9946, 9947,
  9948, 9949, 9950, 9951, 9952, 9953, 9954, 9955, 9956, 9957, 9958, 9959, 9960, 9961, 9961, 9962, 9963, 9964, 9965, 9966, 9967, 9967,
  9968, 9969, 9970, 9971, 9971, 9972, 9973, 9974, 9974, 9975, 9976, 9976, 9977, 9978, 9978, 9979, 9980, 9980, 9981, 9982, 9982, 9983,
  9983, 9984, 9984, 9985, 9986, 9986, 9987, 9987, 9988, 9988, 9989, 9989, 9990, 9990, 9990, 9991, 9991, 9992, 9992, 9992, 9993, 9993,
  9994, 9994, 9994, 9995, 9995, 9995, 9996, 9996, 9996, 9996, 9997, 9997, 9997, 9997, 9998, 9998, 9998, 9998, 9998, 9999, 9999, 9999,
  9999, 9999, 9999, 9999, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000
};

//*********fixed-point sin****************
// input: -3142 to 3142,  angle is in units radians/1000
// e.g., 90 degrees (pi/2 radians) is 1571
// output: -10000 to +10000, fixed point resolution 1/10000
int16_t fixed_sin(int32_t theta){
  if(theta>3142)  return 0;
  if(theta<-3142) return 0;
  if(theta<-1571) return -SinTab[3142+theta]; // -180 to -90 deg
  if(theta<0)     return -SinTab[-theta];     //  -90 to   0 deg
  if(theta<1571)  return SinTab[theta];       //    0 to  90 deg
                  return SinTab[3142-theta];  //   90 to 180 deg
}

// cos(theta) = sin(pi/2-theta)
//*********fixed-point cos****************
// input: -3142 to 3142,  angle is in units radians/1000
// e.g., 90 degrees (pi/2 radians) is 1571
// output: -10000 to +10000, fixed point resolution 1/10000
int16_t fixed_cos(int32_t theta){
  if(theta>3142)  return -10000;
  if(theta<-3142) return -10000;
  if(theta<-1571) return -SinTab[-1571-theta]; // -180 to -90 deg
  if(theta<0)     return SinTab[1571+theta];   //  -90 to   0 deg
  if(theta<1571)  return SinTab[1571-theta];   //    0 to  90 deg
                  return -SinTab[-1571+theta]; //   90 to 180 deg
}

uint16_t const SinTab2[4096]={
  0, 25, 50, 75, 101, 126, 151, 176, 201, 226, 251, 276, 302, 327, 352, 377, 402, 427, 452, 478, 503, 528, 553, 578, 603, 628, 653, 679, 704, 729, 754, 779, 804, 829, 854, 880, 905, 930, 955, 980, 1005, 1030, 1056, 1081, 1106, 1131, 1156, 1181, 1206, 1231, 1257, 1282, 1307, 1332, 1357, 1382, 1407, 1432, 1458, 1483, 1508, 1533, 1558, 1583, 1608, 1633, 1659, 1684, 1709, 1734, 1759, 1784, 1809, 1834, 1860, 1885, 1910, 1935, 1960, 1985, 2010, 2035, 2061, 2086, 2111, 2136, 2161, 2186, 2211, 2236, 2261, 2287, 2312, 2337, 2362, 2387, 2412, 2437, 2462, 2488, 2513, 2538, 2563, 2588, 2613, 2638, 2663, 2688, 2714, 2739, 2764, 2789, 2814, 2839, 2864, 2889, 2914, 2940, 2965, 2990, 3015, 3040, 3065, 3090, 3115, 3140, 3165, 3191, 3216, 3241, 3266, 3291, 3316, 3341, 3366, 3391, 3417, 3442, 3467, 3492, 3517, 3542, 3567, 3592, 3617, 3642, 3667, 3693, 3718, 3743, 3768, 3793, 3818, 3843, 3868, 3893, 3918, 3943, 3969, 3994, 4019, 4044, 4069, 4094, 4119, 4144, 4169, 4194, 4219, 4244, 4270, 4295, 4320, 4345, 4370, 4395, 4420, 4445, 4470, 4495, 4520, 4545, 4570, 4596, 4621, 4646, 4671, 4696, 4721, 4746, 4771, 4796, 4821, 4846, 4871, 4896, 4921, 4946, 4972, 4997, 5022, 5047, 5072, 5097, 5122, 5147, 5172, 5197, 5222, 5247, 5272, 5297, 5322, 5347, 5372, 5397, 5422, 5448, 5473, 5498, 5523, 5548, 5573, 5598, 5623, 5648, 5673, 5698, 5723, 5748, 5773, 5798, 5823, 5848, 5873, 5898, 5923, 5948, 5973, 5998, 6023, 6048, 6073, 6098, 6123, 6148, 6173, 6199, 6224, 6249, 6274, 6299, 6324, 6349, 6374, 6399, 6424, 6449, 6474, 6499, 6524, 6549, 6574, 6599, 6624, 6649, 6674, 6699, 6724, 6749, 6774, 6799, 6824, 6849, 6874, 6899, 6924, 6949, 6974, 6999, 7024, 7049, 7074, 7099, 7124, 7149, 7174, 7199, 7224, 7249, 7273, 7298, 7323, 7348, 7373, 7398, 7423, 7448, 7473, 7498, 7523, 7548, 7573, 7598, 7623, 7648, 7673, 7698, 7723, 7748, 7773, 7798, 7823, 7848, 7873, 7898, 7923, 7947, 7972, 7997, 8022, 8047, 8072, 8097, 8122, 8147, 8172, 8197, 8222, 8247, 8272, 8297, 8322, 8346, 8371, 8396, 8421, 8446, 8471, 8496, 8521, 8546, 8571, 8596, 8621, 8646, 8670, 8695, 8720, 8745, 8770, 8795, 8820, 8845, 8870, 8895, 8919, 8944, 8969, 8994, 9019, 9044, 9069, 9094, 9119, 9144, 9168, 9193, 9218, 9243, 9268, 9293, 9318, 9343, 9367, 9392, 9417, 9442, 9467, 9492, 9517, 9542, 9566, 9591, 9616, 9641, 9666, 9691, 9716, 9740, 9765, 9790, 9815, 9840, 9865, 9890, 9914, 9939, 9964, 9989, 10014, 10039, 10063, 10088, 10113, 10138, 10163, 10188, 10212, 10237, 10262, 10287, 10312, 10336, 10361, 10386, 10411, 10436, 10461, 10485, 10510, 10535, 10560, 10585, 10609, 10634, 10659, 10684, 10709, 10733, 10758, 10783, 10808, 10833, 10857, 10882, 10907, 10932, 10956, 10981, 11006, 11031, 11056, 11080, 11105, 11130, 11155, 11179, 11204, 11229, 11254, 11278, 11303, 11328, 11353, 11377, 11402, 11427, 11452, 11476, 11501, 11526, 11551, 11575, 11600, 11625, 11650, 11674, 11699, 11724, 11749, 11773, 11798, 11823, 11847, 11872, 11897, 11922, 11946, 11971, 11996, 12020, 12045, 12070, 12095, 12119, 12144, 12169, 12193, 12218, 12243, 12267, 12292, 12317, 12341, 12366, 12391, 12415, 12440, 12465, 12490, 12514, 12539, 12564, 12588, 12613, 12638, 12662, 12687, 12711, 12736, 12761, 12785, 12810, 12835, 12859, 12884, 12909, 12933, 12958, 12983, 13007, 13032, 13056, 13081, 13106, 13130, 13155, 13180, 13204, 13229, 13253, 13278, 13303, 13327, 13352, 13376, 13401, 13426, 13450, 13475, 13499, 13524, 13549, 13573, 13598, 13622, 13647, 13672, 13696, 13721, 13745, 13770, 13794, 13819, 13844, 13868, 13893, 13917, 13942, 13966, 13991, 14016, 14040, 14065, 14089, 14114, 14138, 14163, 14187, 14212, 14236, 14261, 14285, 14310, 14334, 14359, 14384, 14408, 14433, 14457, 14482, 14506, 14531, 14555, 14580, 14604, 14629, 14653, 14678, 14702, 14727, 14751, 14776, 14800, 14825, 14849, 14874, 14898, 14922, 14947, 14971, 14996, 15020, 15045, 15069, 15094, 15118, 15143, 15167, 15192, 15216, 15240, 15265, 15289, 15314, 15338, 15363, 15387, 15411, 15436, 15460, 15485, 15509, 15534, 15558, 15582, 15607, 15631, 15656, 15680, 15704, 15729, 15753, 15778, 15802, 15826, 15851, 15875, 15900, 15924, 15948, 15973, 15997, 16021, 16046, 16070, 16095, 16119, 16143, 16168, 16192, 16216, 16241, 16265, 16289, 16314, 16338, 16362, 16387, 16411, 16435, 16460, 16484, 16508, 16533, 16557, 16581, 16606, 16630, 16654, 16679, 16703, 16727, 16751, 16776, 16800, 16824, 16849, 16873, 16897, 16922, 16946, 16970, 16994, 17019, 17043, 17067, 17091, 17116, 17140, 17164, 17188, 17213, 17237, 17261, 17285, 17310, 17334, 17358, 17382, 17407, 17431, 17455, 17479, 17504, 17528, 17552, 17576, 17600, 17625, 17649, 17673, 17697, 17721, 17746, 17770, 17794, 17818, 17842, 17867, 17891, 17915, 17939, 17963, 17987, 18012, 18036, 18060, 18084, 18108, 18132, 18156, 18181, 18205, 18229, 18253, 18277, 18301, 18325, 18350, 18374, 18398, 18422, 18446, 18470, 18494, 18518, 18543, 18567, 18591, 18615, 18639, 18663, 18687, 18711, 18735, 18759, 18783, 18808, 18832, 18856, 18880, 18904, 18928, 18952, 18976, 19000, 19024, 19048, 19072, 19096, 19120, 19144, 19168, 19192, 19216, 19240, 19264, 19288, 19313, 19337, 19361, 19385, 19409, 19433, 19457, 19481, 19505, 19529, 19553, 19577, 19600, 19624, 19648, 19672, 19696, 19720, 19744, 19768, 19792, 19816, 19840, 19864, 19888, 19912, 19936, 19960, 19984, 20008, 20032, 20056, 20080, 20103, 20127, 20151, 20175, 20199, 20223, 20247, 20271, 20295, 20319, 20343, 20366, 20390, 20414, 20438, 20462, 20486, 20510, 20534, 20557, 20581, 20605, 20629, 20653, 20677, 20701, 20724, 20748, 20772, 20796, 20820, 20844, 20867, 20891, 20915, 20939, 20963, 20987, 21010, 21034, 21058, 21082, 21106, 21129, 21153, 21177, 21201, 21224, 21248, 21272, 21296, 21320, 21343, 21367, 21391, 21415, 21438, 21462, 21486, 21510, 21533, 21557, 21581, 21604, 21628, 21652, 21676, 21699, 21723, 21747, 21771, 21794, 21818, 21842, 21865, 21889, 21913, 21936, 21960, 21984, 22007, 22031, 22055, 22078, 22102, 22126, 22149, 22173, 22197, 22220, 22244, 22268, 22291, 22315, 22339, 22362, 22386, 22409, 22433, 22457, 22480, 22504, 22527, 22551, 22575, 22598, 22622, 22645, 22669, 22693, 22716, 22740, 22763, 22787, 22810, 22834, 22858, 22881, 22905, 22928, 22952, 22975, 22999, 23022, 23046, 23069, 23093, 23116, 23140, 23163, 23187, 23210, 23234, 23257, 23281, 23304, 23328, 23351, 23375, 23398, 23422, 23445, 23469, 23492, 23516, 23539, 23563, 23586, 23610, 23633, 23656, 23680, 23703, 23727, 23750, 23774, 23797, 23820, 23844, 23867, 23891, 23914, 23937, 23961, 23984, 24008, 24031, 24054, 24078, 24101, 24124, 24148, 24171, 24195, 24218, 24241, 24265, 24288, 24311, 24335, 24358, 24381, 24405, 24428, 24451, 24475, 24498, 24521, 24545, 24568, 24591, 24614, 24638, 24661, 24684, 24708, 24731, 24754, 24777, 24801, 24824, 24847, 24870, 24894, 24917, 24940, 24963, 24987, 25010, 25033, 25056, 25080, 25103, 25126, 25149, 25172, 25196, 25219, 25242, 25265, 25288, 25312, 25335, 25358, 25381, 25404, 25427, 25451, 25474, 25497, 25520, 25543, 25566, 25589, 25613, 25636, 25659, 25682, 25705, 25728, 25751, 25774, 25798, 25821, 25844, 25867, 25890, 25913, 25936, 25959, 25982, 26005, 26028, 26051, 26075, 26098, 26121, 26144, 26167, 26190, 26213, 26236, 26259, 26282, 26305, 26328, 26351, 26374, 26397, 26420, 26443, 26466, 26489, 26512, 26535, 26558, 26581, 26604, 26627, 26650, 26673, 26696, 26719, 26742, 26765, 26787, 26810, 26833, 26856, 26879, 26902, 26925, 26948, 26971, 26994, 27017, 27040, 27062, 27085, 27108, 27131, 27154, 27177, 27200, 27223, 27245, 27268, 27291, 27314, 27337, 27360, 27382, 27405, 27428, 27451, 27474, 27497, 27519, 27542, 27565, 27588, 27611, 27633, 27656, 27679, 27702, 27725, 27747, 27770, 27793, 27816, 27838, 27861, 27884, 27907, 27929, 27952, 27975, 27998, 28020, 28043, 28066, 28088, 28111, 28134, 28156, 28179, 28202, 28225, 28247, 28270, 28293, 28315, 28338, 28361, 28383, 28406, 28429, 28451, 28474, 28496, 28519, 28542, 28564, 28587, 28610, 28632, 28655, 28677, 28700, 28723, 28745, 28768, 28790, 28813, 28835, 28858, 28881, 28903, 28926, 28948, 28971, 28993, 29016, 29038, 29061, 29083, 29106, 29129, 29151, 29174, 29196, 29219, 29241, 29264, 29286, 29308, 29331, 29353, 29376, 29398, 29421, 29443, 29466, 29488, 29511, 29533, 29555, 29578, 29600, 29623, 29645, 29668, 29690, 29712, 29735, 29757, 29780, 29802, 29824, 29847, 29869, 29891, 29914, 29936, 29959, 29981, 30003, 30026, 30048, 30070, 30093, 30115, 30137, 30160, 30182, 30204, 30226, 30249, 30271, 30293, 30316, 30338, 30360, 30382, 30405, 30427, 30449, 30472, 30494, 30516, 30538, 30560, 30583, 30605, 30627, 30649, 30672, 30694, 30716, 30738, 30760, 30783, 30805, 30827, 30849, 30871, 30893, 30916, 30938, 30960, 30982, 31004, 31026, 31049, 31071, 31093, 31115, 31137, 31159, 31181, 31203, 31225, 31248, 31270, 31292, 31314, 31336, 31358, 31380, 31402, 31424, 31446, 31468, 31490, 31512, 31534, 31556, 31578, 31600, 31622, 31644, 31666, 31688, 31710, 31732, 31754, 31776, 31798, 31820, 31842, 31864, 31886, 31908, 31930, 31952, 31974, 31996, 32018, 32040, 32062, 32084, 32106, 32127, 32149, 32171, 32193, 32215, 32237, 32259, 32281, 32303, 32324, 32346, 32368, 32390, 32412, 32434, 32456, 32477, 32499, 32521, 32543, 32565, 32586, 32608, 32630, 32652, 32674, 32695, 32717, 32739, 32761, 32783, 32804, 32826, 32848, 32870, 32891, 32913, 32935, 32956, 32978, 33000, 33022, 33043, 33065, 33087, 33108, 33130, 33152, 33173, 33195, 33217, 33238, 33260, 33282, 33303, 33325, 33347, 33368, 33390, 33412, 33433, 33455, 33476, 33498, 33520, 33541, 33563, 33584, 33606, 33628, 33649, 33671, 33692, 33714, 33735, 33757, 33778, 33800, 33821, 33843, 33865, 33886, 33908, 33929, 33951, 33972, 33994, 34015, 34037, 34058, 34079, 34101, 34122, 34144, 34165, 34187, 34208, 34230, 34251, 34272, 34294, 34315, 34337, 34358, 34380, 34401, 34422, 34444, 34465, 34486, 34508, 34529, 34551, 34572, 34593, 34615, 34636, 34657, 34679, 34700, 34721, 34743, 34764, 34785, 34806, 34828, 34849, 34870, 34892, 34913, 34934, 34955, 34977, 34998, 35019, 35040, 35062, 35083, 35104, 35125, 35146, 35168, 35189, 35210, 35231, 35252, 35274, 35295, 35316, 35337, 35358, 35380, 35401, 35422, 35443, 35464, 35485, 35506, 35527, 35549, 35570, 35591, 35612, 35633, 35654, 35675, 35696, 35717, 35738, 35759, 35781, 35802, 35823, 35844, 35865, 35886, 35907, 35928, 35949, 35970, 35991, 36012, 36033, 36054, 36075, 36096, 36117, 36138, 36159, 36180, 36201, 36222, 36243, 36263, 36284, 36305, 36326, 36347, 36368, 36389, 36410, 36431, 36452, 36473, 36493, 36514, 36535, 36556, 36577, 36598, 36619, 36639, 36660, 36681, 36702, 36723, 36744, 36764, 36785, 36806, 36827, 36848, 36868, 36889, 36910, 36931, 36951, 36972, 36993, 37014, 37034, 37055, 37076, 37097, 37117, 37138, 37159, 37179, 37200, 37221, 37241, 37262, 37283, 37303, 37324, 37345, 37365, 37386, 37407, 37427, 37448, 37469, 37489, 37510, 37530, 37551, 37572, 37592, 37613, 37633, 37654, 37674, 37695, 37716, 37736, 37757, 37777, 37798, 37818, 37839, 37859, 37880, 37900, 37921, 37941, 37962, 37982, 38003, 38023, 38044, 38064, 38085, 38105, 38126, 38146, 38166, 38187, 38207, 38228, 38248, 38269, 38289, 38309, 38330, 38350, 38370, 38391, 38411, 38432, 38452, 38472, 38493, 38513, 38533, 38554, 38574, 38594, 38615, 38635, 38655, 38675, 38696, 38716, 38736, 38757, 38777, 38797, 38817, 38838, 38858, 38878, 38898, 38919, 38939, 38959, 38979, 38999, 39020, 39040, 39060, 39080, 39100, 39120, 39141, 39161, 39181, 39201, 39221, 39241, 39261, 39282, 39302, 39322, 39342, 39362, 39382, 39402, 39422, 39442, 39462, 39482, 39503, 39523, 39543, 39563, 39583, 39603, 39623, 39643, 39663, 39683, 39703, 39723, 39743, 39763, 39783, 39803, 39823, 39843, 39863, 39882, 39902, 39922, 39942, 39962, 39982, 40002, 40022, 40042, 40062, 40082, 40102, 40121, 40141, 40161, 40181, 40201, 40221, 40241, 40260, 40280, 40300, 40320, 40340, 40359, 40379, 40399, 40419, 40439, 40458, 40478, 40498, 40518, 40537, 40557, 40577, 40597, 40616, 40636, 40656, 40675, 40695, 40715, 40735, 40754, 40774, 40794, 40813, 40833, 40853, 40872, 40892, 40912, 40931, 40951, 40970, 40990, 41010, 41029, 41049, 41068, 41088, 41108, 41127, 41147, 41166, 41186, 41205, 41225, 41244, 41264, 41283, 41303, 41323, 41342, 41362, 41381, 41401, 41420, 41439, 41459, 41478, 41498, 41517, 41537, 41556, 41576, 41595, 41614, 41634, 41653, 41673, 41692, 41711, 41731, 41750, 41770, 41789, 41808, 41828, 41847, 41866, 41886, 41905, 41924, 41944, 41963, 41982, 42002, 42021, 42040, 42059, 42079, 42098, 42117, 42136, 42156, 42175, 42194, 42213, 42233, 42252, 42271, 42290, 42309, 42329, 42348, 42367, 42386, 42405, 42424, 42444, 42463, 42482, 42501, 42520, 42539, 42558, 42578, 42597, 42616, 42635, 42654, 42673, 42692, 42711, 42730, 42749, 42768, 42787, 42806, 42825, 42844, 42863, 42882, 42901, 42920, 42939, 42958, 42977, 42996, 43015, 43034, 43053, 43072, 43091, 43110, 43129, 43148, 43167, 43186, 43205, 43223, 43242, 43261, 43280, 43299, 43318, 43337, 43356, 43374, 43393, 43412, 43431, 43450, 43469, 43487, 43506, 43525, 43544, 43562, 43581, 43600, 43619, 43638, 43656, 43675, 43694, 43713, 43731, 43750, 43769, 43787, 43806, 43825, 43843, 43862, 43881, 43899, 43918, 43937, 43955, 43974, 43993, 44011, 44030, 44049, 44067, 44086, 44104, 44123, 44141, 44160, 44179, 44197, 44216, 44234, 44253, 44271, 44290, 44308, 44327, 44345, 44364, 44382, 44401, 44419, 44438, 44456, 44475, 44493, 44512, 44530, 44549, 44567, 44585, 44604, 44622, 44641, 44659, 44677, 44696, 44714, 44733, 44751, 44769, 44788, 44806, 44824, 44843, 44861, 44879, 44898, 44916, 44934, 44953, 44971, 44989, 45007, 45026, 45044, 45062, 45080, 45099, 45117, 45135, 45153, 45172, 45190, 45208, 45226, 45244, 45262, 45281, 45299, 45317, 45335, 45353, 45371, 45390, 45408, 45426, 45444, 45462, 45480, 45498, 45516, 45534, 45552, 45571, 45589, 45607, 45625, 45643, 45661, 45679, 45697, 45715, 45733, 45751, 45769, 45787, 45805, 45823, 45841, 45859, 45877, 45895, 45912, 45930, 45948, 45966, 45984, 46002, 46020, 46038, 46056, 46074, 46091, 46109, 46127, 46145, 46163, 46181, 46199, 46216, 46234, 46252, 46270, 46288, 46305, 46323, 46341, 46359, 46376, 46394, 46412, 46430, 46447, 46465, 46483, 46501, 46518, 46536, 46554, 46571, 46589, 46607, 46624, 46642, 46660, 46677, 46695, 46713, 46730, 46748, 46765, 46783, 46801, 46818, 46836, 46853, 46871, 46889, 46906, 46924, 46941, 46959, 46976, 46994, 47011, 47029, 47046, 47064, 47081, 47099, 47116, 47134, 47151, 47169, 47186, 47204, 47221, 47238, 47256, 47273, 47291, 47308, 47325, 47343, 47360, 47378, 47395, 47412, 47430, 47447, 47464, 47482, 47499, 47516, 47534, 47551, 47568, 47585, 47603, 47620, 47637, 47654, 47672, 47689, 47706, 47723, 47741, 47758, 47775, 47792, 47809, 47827, 47844, 47861, 47878, 47895, 47912, 47930, 47947, 47964, 47981, 47998, 48015, 48032, 48049, 48067, 48084, 48101, 48118, 48135, 48152, 48169, 48186, 48203, 48220, 48237, 48254, 48271, 48288, 48305, 48322, 48339, 48356, 48373, 48390, 48407, 48424, 48441, 48458, 48474, 48491, 48508, 48525, 48542, 48559, 48576, 48593, 48610, 48626, 48643, 48660, 48677, 48694, 48711, 48727, 48744, 48761, 48778, 48795, 48811, 48828, 48845, 48862, 48878, 48895, 48912, 48929, 48945, 48962, 48979, 48995, 49012, 49029, 49045, 49062, 49079, 49095, 49112, 49129, 49145, 49162, 49179, 49195, 49212, 49228, 49245, 49262, 49278, 49295, 49311, 49328, 49344, 49361, 49377, 49394, 49410, 49427, 49443, 49460, 49476, 49493, 49509, 49526, 49542, 49559, 49575, 49592, 49608, 49624, 49641, 49657, 49674, 49690, 49706, 49723, 49739, 49756, 49772, 49788, 49805, 49821, 49837, 49854, 49870, 49886, 49902, 49919, 49935, 49951, 49968, 49984, 50000, 50016, 50033, 50049, 50065, 50081, 50097, 50114, 50130, 50146, 50162, 50178, 50195, 50211, 50227, 50243, 50259, 50275, 50291, 50307, 50324, 50340, 50356, 50372, 50388, 50404, 50420, 50436, 50452, 50468, 50484, 50500, 50516, 50532, 50548, 50564, 50580, 50596, 50612, 50628, 50644, 50660, 50676, 50692, 50708, 50724, 50740, 50756, 50771, 50787, 50803, 50819, 50835, 50851, 50867, 50882, 50898, 50914, 50930, 50946, 50962, 50977, 50993, 51009, 51025, 51041, 51056, 51072, 51088, 51104, 51119, 51135, 51151, 51166, 51182, 51198, 51213, 51229, 51245, 51260, 51276, 51292, 51307, 51323, 51339, 51354, 51370, 51386, 51401, 51417, 51432, 51448, 51463, 51479, 51495, 51510, 51526, 51541, 51557, 51572, 51588, 51603, 51619, 51634, 51650, 51665, 51681, 51696, 51711, 51727, 51742, 51758, 51773, 51789, 51804, 51819, 51835, 51850, 51865, 51881, 51896, 51911, 51927, 51942, 51957, 51973, 51988, 52003, 52019, 52034, 52049, 52065, 52080, 52095, 52110, 52126, 52141, 52156, 52171, 52186, 52202, 52217, 52232, 52247, 52262, 52277, 52293, 52308, 52323, 52338, 52353, 52368, 52383, 52398, 52414, 52429, 52444, 52459, 52474, 52489, 52504, 52519, 52534, 52549, 52564, 52579, 52594, 52609, 52624, 52639, 52654, 52669, 52684, 52699, 52714, 52729, 52744, 52759, 52773, 52788, 52803, 52818, 52833, 52848, 52863, 52878, 52892, 52907, 52922, 52937, 52952, 52967, 52981, 52996, 53011, 53026, 53040, 53055, 53070, 53085, 53099, 53114, 53129, 53144, 53158, 53173, 53188, 53202, 53217, 53232, 53246, 53261, 53276, 53290, 53305, 53319, 53334, 53349, 53363, 53378, 53392, 53407, 53422, 53436, 53451, 53465, 53480, 53494, 53509, 53523, 53538, 53552, 53567, 53581, 53596, 53610, 53625, 53639, 53653, 53668, 53682, 53697, 53711, 53726, 53740, 53754, 53769, 53783, 53797, 53812, 53826, 53840, 53855, 53869, 53883, 53898, 53912, 53926, 53941, 53955, 53969, 53983, 53998, 54012, 54026, 54040, 54054, 54069, 54083, 54097, 54111, 54125, 54140, 54154, 54168, 54182, 54196, 54210, 54224, 54239, 54253, 54267, 54281, 54295, 54309, 54323, 54337, 54351, 54365, 54379, 54393, 54407, 54421, 54435, 54449, 54463, 54477, 54491, 54505, 54519, 54533, 54547, 54561, 54575, 54589, 54603, 54617, 54630, 54644, 54658, 54672, 54686, 54700, 54714, 54727, 54741, 54755, 54769, 54783, 54796, 54810, 54824, 54838, 54852, 54865, 54879, 54893, 54906, 54920, 54934, 54948, 54961, 54975, 54989, 55002, 55016, 55030, 55043, 55057, 55071, 55084, 55098, 55111, 55125, 55139, 55152, 55166, 55179, 55193, 55206, 55220, 55233, 55247, 55260, 55274, 55288, 55301, 55314, 55328, 55341, 55355, 55368, 55382, 55395, 55409, 55422, 55435, 55449, 55462, 55476, 55489, 55502, 55516, 55529, 55542, 55556, 55569, 55582, 55596, 55609, 55622, 55636, 55649, 55662, 55675, 55689, 55702, 55715, 55728, 55742, 55755, 55768, 55781, 55794, 55808, 55821, 55834, 55847, 55860, 55873, 55887, 55900, 55913, 55926, 55939, 55952, 55965, 55978, 55991, 56004, 56017, 56030, 56043, 56056, 56069, 56082, 56095, 56108, 56121, 56134, 56147, 56160, 56173, 56186, 56199, 56212, 56225, 56238, 56251, 56264, 56277, 56289, 56302, 56315, 56328, 56341, 56354, 56367, 56379, 56392, 56405, 56418, 56431, 56443, 56456, 56469, 56482, 56494, 56507, 56520, 56533, 56545, 56558, 56571, 56583, 56596, 56609, 56621, 56634, 56647, 56659, 56672, 56684, 56697, 56710, 56722, 56735, 56747, 56760, 56773, 56785, 56798, 56810, 56823, 56835, 56848, 56860, 56873, 56885, 56898, 56910, 56923, 56935, 56948, 56960, 56972, 56985, 56997, 57010, 57022, 57034, 57047, 57059, 57072, 57084, 57096, 57109, 57121, 57133, 57145, 57158, 57170, 57182, 57195, 57207, 57219, 57231, 57244, 57256, 57268, 57280, 57293, 57305, 57317, 57329, 57341, 57353, 57366, 57378, 57390, 57402, 57414, 57426, 57438, 57450, 57463, 57475, 57487, 57499, 57511, 57523, 57535, 57547, 57559, 57571, 57583, 57595, 57607, 57619, 57631, 57643, 57655, 57667, 57679, 57691, 57703, 57714, 57726, 57738, 57750, 57762, 57774, 57786, 57798, 57809, 57821, 57833, 57845, 57857, 57869, 57880, 57892, 57904, 57916, 57927, 57939, 57951, 57963, 57974, 57986, 57998, 58009, 58021, 58033, 58045, 58056, 58068, 58079, 58091, 58103, 58114, 58126, 58138, 58149, 58161, 58172, 58184, 58195, 58207, 58219, 58230, 58242, 58253, 58265, 58276, 58288, 58299, 58311, 58322, 58334, 58345, 58356, 58368, 58379, 58391, 58402, 58414, 58425, 58436, 58448, 58459, 58470, 58482, 58493, 58504, 58516, 58527, 58538, 58550, 58561, 58572, 58583, 58595, 58606, 58617, 58628, 58640, 58651, 58662, 58673, 58685, 58696, 58707, 58718, 58729, 58740, 58751, 58763, 58774, 58785, 58796, 58807, 58818, 58829, 58840, 58851, 58862, 58873, 58885, 58896, 58907, 58918, 58929, 58940, 58951, 58962, 58972, 58983, 58994, 59005, 59016, 59027, 59038, 59049, 59060, 59071, 59082, 59093, 59103, 59114, 59125, 59136, 59147, 59158, 59168, 59179, 59190, 59201, 59212, 59222, 59233, 59244, 59255, 59265, 59276, 59287, 59297, 59308, 59319, 59330, 59340, 59351, 59362, 59372, 59383, 59393, 59404, 59415, 59425, 59436, 59446, 59457, 59468, 59478, 59489, 59499, 59510, 59520, 59531, 59541, 59552, 59562, 59573, 59583, 59594, 59604, 59615, 59625, 59635, 59646, 59656, 59667, 59677, 59687, 59698, 59708, 59719, 59729, 59739, 59750, 59760, 59770, 59781, 59791, 59801, 59811, 59822, 59832, 59842, 59852, 59863, 59873, 59883, 59893, 59903, 59914, 59924, 59934, 59944, 59954, 59964, 59975, 59985, 59995, 60005, 60015, 60025, 60035, 60045, 60055, 60065, 60075, 60086, 60096, 60106, 60116, 60126, 60136, 60146, 60156, 60166, 60175, 60185, 60195, 60205, 60215, 60225, 60235, 60245, 60255, 60265, 60275, 60284, 60294, 60304, 60314, 60324, 60334, 60343, 60353, 60363, 60373, 60383, 60392, 60402, 60412, 60422, 60431, 60441, 60451, 60460, 60470, 60480, 60490, 60499, 60509, 60518, 60528, 60538, 60547, 60557, 60567, 60576, 60586, 60595, 60605, 60614, 60624, 60634, 60643, 60653, 60662, 60672, 60681, 60691, 60700, 60710, 60719, 60728, 60738, 60747, 60757, 60766, 60776, 60785, 60794, 60804, 60813, 60823, 60832, 60841, 60851, 60860, 60869, 60879, 60888, 60897, 60906, 60916, 60925, 60934, 60943, 60953, 60962, 60971, 60980, 60990, 60999, 61008, 61017, 61026, 61035, 61045, 61054, 61063, 61072, 61081, 61090, 61099, 61108, 61117, 61127, 61136, 61145, 61154, 61163, 61172, 61181, 61190, 61199, 61208, 61217, 61226, 61235, 61244, 61253, 61261, 61270, 61279, 61288, 61297, 61306, 61315, 61324, 61333, 61341, 61350, 61359, 61368, 61377, 61386, 61394, 61403, 61412, 61421, 61429, 61438, 61447, 61456, 61464, 61473, 61482, 61491, 61499, 61508, 61517, 61525, 61534, 61543, 61551, 61560, 61568, 61577, 61586, 61594, 61603, 61611, 61620, 61628, 61637, 61646, 61654, 61663, 61671, 61680, 61688, 61697, 61705, 61713, 61722, 61730, 61739, 61747, 61756, 61764, 61772, 61781, 61789, 61798, 61806, 61814, 61823, 61831, 61839, 61848, 61856, 61864, 61873, 61881, 61889, 61897, 61906, 61914, 61922, 61930, 61939, 61947, 61955, 61963, 61971, 61979, 61988, 61996, 62004, 62012, 62020, 62028, 62036, 62045, 62053, 62061, 62069, 62077, 62085, 62093, 62101, 62109, 62117, 62125, 62133, 62141, 62149, 62157, 62165, 62173, 62181, 62189, 62197, 62205, 62212, 62220, 62228, 62236, 62244, 62252, 62260, 62268, 62275, 62283, 62291, 62299, 62307, 62314, 62322, 62330, 62338, 62346, 62353, 62361, 62369, 62376, 62384, 62392, 62400, 62407, 62415, 62423, 62430, 62438, 62445, 62453, 62461, 62468, 62476, 62483, 62491, 62499, 62506, 62514, 62521, 62529, 62536, 62544, 62551, 62559, 62566, 62574, 62581, 62589, 62596, 62604, 62611, 62618, 62626, 62633, 62641, 62648, 62655, 62663, 62670, 62677, 62685, 62692, 62699, 62707, 62714, 62721, 62729, 62736, 62743, 62750, 62758, 62765, 62772, 62779, 62787, 62794, 62801, 62808, 62815, 62822, 62830, 62837, 62844, 62851, 62858, 62865, 62872, 62879, 62886, 62894, 62901, 62908, 62915, 62922, 62929, 62936, 62943, 62950, 62957, 62964, 62971, 62978, 62985, 62992, 62998, 63005, 63012, 63019, 63026, 63033, 63040, 63047, 63054, 63060, 63067, 63074, 63081, 63088, 63095, 63101, 63108, 63115, 63122, 63128, 63135, 63142, 63149, 63155, 63162, 63169, 63175, 63182, 63189, 63195, 63202, 63209, 63215, 63222, 63229, 63235, 63242, 63248, 63255, 63262, 63268, 63275, 63281, 63288, 63294, 63301, 63307, 63314, 63320, 63327, 63333, 63340, 63346, 63353, 63359, 63365, 63372, 63378, 63385, 63391, 63397, 63404, 63410, 63416, 63423, 63429, 63435, 63442, 63448, 63454, 63461, 63467, 63473, 63479, 63486, 63492, 63498, 63504, 63510, 63517, 63523, 63529, 63535, 63541, 63547, 63554, 63560, 63566, 63572, 63578, 63584, 63590, 63596, 63602, 63608, 63614, 63621, 63627, 63633, 63639, 63645, 63651, 63657, 63663, 63668, 63674, 63680, 63686, 63692, 63698, 63704, 63710, 63716, 63722, 63728, 63733, 63739, 63745, 63751, 63757, 63763, 63768, 63774, 63780, 63786, 63792, 63797, 63803, 63809, 63814, 63820, 63826, 63832, 63837, 63843, 63849, 63854, 63860, 63866, 63871, 63877, 63882, 63888, 63894, 63899, 63905, 63910, 63916, 63922, 63927, 63933, 63938, 63944, 63949, 63955, 63960, 63966, 63971, 63976, 63982, 63987, 63993, 63998, 64004, 64009, 64014, 64020, 64025, 64031, 64036, 64041, 64047, 64052, 64057, 64062, 64068, 64073, 64078, 64084, 64089, 64094, 64099, 64105, 64110, 64115, 64120, 64125, 64131, 64136, 64141, 64146, 64151, 64156, 64161, 64167, 64172, 64177, 64182, 64187, 64192, 64197, 64202, 64207, 64212, 64217, 64222, 64227, 64232, 64237, 64242, 64247, 64252, 64257, 64262, 64267, 64272, 64277, 64282, 64287, 64291, 64296, 64301, 64306, 64311, 64316, 64320, 64325, 64330, 64335, 64340, 64344, 64349, 64354, 64359, 64363, 64368, 64373, 64378, 64382, 64387, 64392, 64396, 64401, 64406, 64410, 64415, 64420, 64424, 64429, 64433, 64438, 64443, 64447, 64452, 64456, 64461, 64465, 64470, 64474, 64479, 64483, 64488, 64492, 64497, 64501, 64506, 64510, 64514, 64519, 64523, 64528, 64532, 64536, 64541, 64545, 64550, 64554, 64558, 64563, 64567, 64571, 64575, 64580, 64584, 64588, 64593, 64597, 64601, 64605, 64609, 64614, 64618, 64622, 64626, 64630, 64635, 64639, 64643, 64647, 64651, 64655, 64659, 64663, 64667, 64672, 64676, 64680, 64684, 64688, 64692, 64696, 64700, 64704, 64708, 64712, 64716, 64720, 64724, 64728, 64732, 64735, 64739, 64743, 64747, 64751, 64755, 64759, 64763, 64766, 64770, 64774, 64778, 64782, 64786, 64789, 64793, 64797, 64801, 64804, 64808, 64812, 64816, 64819, 64823, 64827, 64830, 64834, 64838, 64841, 64845, 64849, 64852, 64856, 64859, 64863, 64867, 64870, 64874, 64877, 64881, 64884, 64888, 64892, 64895, 64899, 64902, 64905, 64909, 64912, 64916, 64919, 64923, 64926, 64930, 64933, 64936, 64940, 64943, 64947, 64950, 64953, 64957, 64960, 64963, 64967, 64970, 64973, 64976, 64980, 64983, 64986, 64989, 64993, 64996, 64999, 65002, 65006, 65009, 65012, 65015, 65018, 65021, 65025, 65028, 65031, 65034, 65037, 65040, 65043, 65046, 65049, 65052, 65055, 65058, 65061, 65064, 65067, 65070, 65073, 65076, 65079, 65082, 65085, 65088, 65091, 65094, 65097, 65100, 65103, 65106, 65109, 65111, 65114, 65117, 65120, 65123, 65126, 65128, 65131, 65134, 65137, 65139, 65142, 65145, 65148, 65150, 65153, 65156, 65159, 65161, 65164, 65167, 65169, 65172, 65175, 65177, 65180, 65182, 65185, 65188, 65190, 65193, 65195, 65198, 65200, 65203, 65205, 65208, 65210, 65213, 65215, 65218, 65220, 65223, 65225, 65228, 65230, 65233, 65235, 65237, 65240, 65242, 65245, 65247, 65249, 65252, 65254, 65256, 65259, 65261, 65263, 65265, 65268, 65270, 65272, 65275, 65277, 65279, 65281, 65283, 65286, 65288, 65290, 65292, 65294, 65296, 65299, 65301, 65303, 65305, 65307, 65309, 65311, 65313, 65315, 65317, 65320, 65322, 65324, 65326, 65328, 65330, 65332, 65334, 65336, 65338, 65339, 65341, 65343, 65345, 65347, 65349, 65351, 65353, 65355, 65357, 65358, 65360, 65362, 65364, 65366, 65368, 65369, 65371, 65373, 65375, 65376, 65378, 65380, 65382, 65383, 65385, 65387, 65388, 65390, 65392, 65393, 65395, 65397, 65398, 65400, 65402, 65403, 65405, 65406, 65408, 65410, 65411, 65413, 65414, 65416, 65417, 65419, 65420, 65422, 65423, 65425, 65426, 65428, 65429, 65430, 65432, 65433, 65435, 65436, 65437, 65439, 65440, 65442, 65443, 65444, 65446, 65447, 65448, 65449, 65451, 65452, 65453, 65455, 65456, 65457, 65458, 65460, 65461, 65462, 65463, 65464, 65465, 65467, 65468, 65469, 65470, 65471, 65472, 65473, 65474, 65476, 65477, 65478, 65479, 65480, 65481, 65482, 65483, 65484, 65485, 65486, 65487, 65488, 65489, 65490, 65491, 65492, 65493, 65493, 65494, 65495, 65496, 65497, 65498, 65499, 65500, 65500, 65501, 65502, 65503, 65504, 65504, 65505, 65506, 65507, 65507, 65508, 65509, 65510, 65510, 65511, 65512, 65512, 65513, 65514, 65514, 65515, 65516, 65516, 65517, 65517, 65518, 65519, 65519, 65520, 65520, 65521, 65521, 65522, 65522, 65523, 65523, 65524, 65524, 65525, 65525, 65526, 65526, 65527, 65527, 65527, 65528, 65528, 65529, 65529, 65529, 65530, 65530, 65530, 65531, 65531, 65531, 65532, 65532, 65532, 65532, 65533, 65533, 65533, 65533, 65534, 65534, 65534, 65534, 65534, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535
};

//*********fixed-point sin****************
// input: -8192 to 8191,  angle is in units 2*pi/16384 radians (-pi to +pi)
// e.g., 90 degrees (pi/2 radians) is 4096
// output: -65536 to +65536, fixed point resolution 1/65536
int32_t fixed_sin2(int32_t theta){
  if(theta> 8191) return 0;
  if(theta<-8192) return 0;
  if(theta<-4106) return -SinTab2[8192+theta]; // -180 to -90 deg
  if(theta<-4086) return -65536;               //  -90 deg
  if(theta<    0) return -SinTab2[-theta];     //  -90 to   0 deg
  if(theta< 4086) return  SinTab2[theta];      //    0 to  90 deg
  if(theta< 4106) return  65536;               //   90 deg
                  return  SinTab2[8192-theta]; //   90 to 180 deg
}

//*********fixed-point cos****************
// input: -8192 to 8191,  angle is in units 2*pi/16384 radians (-pi to +pi)
// e.g., 90 degrees (pi/2 radians) is 4096
// output: -65536 to +65536, fixed point resolution 1/65536
int32_t fixed_cos2(int32_t theta){
  if(theta> 8181) return -65536;
  if(theta<-8182) return -65536;
  if(theta<-4096) return -SinTab2[-4096-theta]; // -180 to -90 deg
  if(theta<  -10) return  SinTab2[4096+theta];  //  -90 to   0 deg
  if(theta<   10) return  65536;                //    0 deg
  if(theta< 4096) return  SinTab2[4096-theta];  //    0 to  90 deg
                  return -SinTab2[-4096+theta]; //   90 to 180 deg
}


int32_t SinTab540[540] = {
0, 763, 1525, 2287, 3049, 3811, 4572, 5332, 6092, 6850, 7608, 8365, 9121, 9875, 10628, 11380, 12130, 12879, 13626, 14371, 15114, 15855, 16593, 17330, 18064, 18796, 19525, 20252, 20976, 21697, 22415, 23130, 23842, 24550, 25256, 25957, 26656, 27351, 28042, 28729, 29413, 30092, 30767, 31438, 32105, 32768, 33426, 34080, 34729, 35373, 36013, 36647, 37277, 37902, 38521, 39135, 39744, 40348, 40946, 41539, 42126, 42707, 43283, 43852, 44416, 44974, 45525, 46071, 46610, 47143, 47669, 48189, 48703, 49210, 49710, 50203, 50690, 51170, 51643, 52109, 52568, 53020, 53464, 53902, 54332, 54755, 55170, 55578, 55978, 56371, 56756, 57133, 57503, 57865, 58219, 58565, 58903, 59234, 59556, 59870, 60176, 60474, 60764, 61045, 61319, 61584, 61840, 62089, 62328, 62560, 62783, 62997, 63203, 63401, 63589, 63769, 63941, 64104, 64258, 64404, 64540, 64668, 64788, 64898, 65000, 65093, 65177, 65252, 65319, 65376, 65425, 65465, 65496, 65518, 65532, 65536, 

65532, 65518, 65496, 65465, 65425, 65376, 65319, 65252, 65177, 65093, 65000, 64898, 64788, 64668, 64540, 64404, 64258, 64104, 63941, 63769, 63589, 63401, 63203, 62997, 62783, 62560, 62328, 62089, 61840, 61584, 61319, 61045, 60764, 60474, 60176, 59870, 59556, 59234, 58903, 58565, 58219, 57865, 57503, 57133, 56756, 56371, 55978, 55578, 55170, 54755, 54332, 53902, 53464, 53020, 52568, 52109, 51643, 51170, 50690, 50203, 49710, 49210, 48703, 48189, 47669, 47143, 46610, 46071, 45525, 44974, 44416, 43852, 43283, 42707, 42126, 41539, 40946, 40348, 39744, 39135, 38521, 37902, 37277, 36647, 36013, 35373, 34729, 34080, 33426, 32768, 32105, 31438, 30767, 30092, 29413, 28729, 28042, 27351, 26656, 25957, 25256, 24550, 23842, 23130, 22415, 21697, 20976, 20252, 19525, 18796, 18064, 17330, 16593, 15855, 15114, 14371, 13626, 12879, 12130, 11380, 10628, 9875, 9121, 8365, 7608, 6850, 6092, 5332, 4572, 3811, 3049, 2287, 1525, 763, 0,

 -763, -1525, -2287, -3049, -3811, -4572, -5332, -6092, -6850, -7608, -8365, -9121, -9875, -10628, -11380, -12130, -12879, -13626, -14371, -15114, -15855, -16593, -17330, -18064, -18796, -19525, -20252, -20976, -21697, -22415, -23130, -23842, -24550, -25256, -25957, -26656, -27351, -28042, -28729, -29413, -30092, -30767, -31438, -32105, -32768, -33426, -34080, -34729, -35373, -36013, -36647, -37277, -37902, -38521, -39135, -39744, -40348, -40946, -41539, -42126, -42707, -43283, -43852, -44416, -44974, -45525, -46071, -46610, -47143, -47669, -48189, -48703, -49210, -49710, -50203, -50690, -51170, -51643, -52109, -52568, -53020, -53464, -53902, -54332, -54755, -55170, -55578, -55978, -56371, -56756, -57133, -57503, -57865, -58219, -58565, -58903, -59234, -59556, -59870, -60176, -60474, -60764, -61045, -61319, -61584, -61840, -62089, -62328, -62560, -62783, -62997, -63203, -63401, -63589, -63769, -63941, -64104, -64258, -64404, -64540, -64668, -64788, -64898, -65000, -65093, -65177, -65252, -65319, -65376, -65425, -65465, -65496, -65518, -65532, -65536, 
 
 -65532, -65518, -65496, -65465, -65425, -65376, -65319, -65252, -65177, -65093, -65000, -64898, -64788, -64668, -64540, -64404, -64258, -64104, -63941, -63769, -63589, -63401, -63203, -62997, -62783, -62560, -62328, -62089, -61840, -61584, -61319, -61045, -60764, -60474, -60176, -59870, -59556, -59234, -58903, -58565, -58219, -57865, -57503, -57133, -56756, -56371, -55978, -55578, -55170, -54755, -54332, -53902, -53464, -53020, -52568, -52109, -51643, -51170, -50690, -50203, -49710, -49210, -48703, -48189, -47669, -47143, -46610, -46071, -45525, -44974, -44416, -43852, -43283, -42707, -42126, -41539, -40946, -40348, -39744, -39135, -38521, -37902, -37277, -36647, -36013, -35373, -34729, -34080, -33426, -32768, -32105, -31438, -30767, -30092, -29413, -28729, -28042, -27351, -26656, -25957, -25256, -24550, -23842, -23130, -22415, -21697, -20976, -20252, -19525, -18796, -18064, -17330, -16593, -15855, -15114, -14371, -13626, -12879, -12130, -11380, -10628, -9875, -9121, -8365, -7608, -6850, -6092, -5332, -4572, -3811, -3049, -2287, -1525, -763};
//*********sin540****************
// input: 0 to 539,  angle is in units 2*pi/540 = 0.011635528 radians (0 to 2pi)
// e.g., 359.3degrees (2pi radians)  theta=539  sin540(539) = -763   (-0.0116)
// e.g., 270 degrees (3pi/4 radians) theta=405  sin540(405) = -65536 (-1)
// e.g., 180 degrees (pi radians)    theta=270  sin540(270) = 0      (0)
// e.g., 90 degrees (pi/2 radians)   theta=135  sin540(135) = 65536  (+1)
// e.g., 45 degrees (pi/4 radians)   theta= 67  sin540(67)  = 46071  (sqrt(2)/2)
// e.g.,  0 degrees (0 radians)      theta= 0   sin540(0)   = 0      (0)
// output: -65536 to +65536, fixed point resolution 1/65536
int32_t sin540(int32_t theta){
  if((theta<0)||(theta>539)) return 0;
  return SinTab540[theta];
}

int32_t cos540(int32_t theta){
  if((theta<0)||(theta>539)) return 65536;
  if(theta > 539)   return -65536;
  if(theta <   0)   return  65536;
  if(theta < 135)   return  SinTab540[135-theta];  //   0 to  90 deg
  if(theta < 270)   return -SinTab540[theta-270];  //  90 to 180 deg
  if(theta < 405)   return -SinTab540[405-theta];  // 180 to 270 deg
                    return  SinTab540[theta-405];  // 270 to 539
}

